/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.integration;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDMShopIntegration {
    private static final Logger LOGGER = LogManager.getLogger(SDMShopIntegration.class);
    private static Class<?> sdmShopClass = null;
    private static Method getMoneyMethod = null;
    private static Method setMoneyMethod = null;
    private static boolean initialized = false;
    private static boolean available = false;

    private static void initialize() {
        if (initialized) {
            return;
        }
        try {
            CharSequence[] possibleClasses;
            LOGGER.info("Attempting to initialize SDMShop integration...");
            for (String string : possibleClasses = new String[]{"net.sixik.sdmshoprework.SDMShopR", "net.sixik.sdmshop.SDMShop", "net.sixik.sdmshop.api.ShopAPI", "net.sixik.sdmshoprework.api.ShopAPI", "net.sixik.sdmshop.SDMShopRework", "net.sixik.sdmeconomy.api.EconomyAPI", "net.sixik.sdmeconomy.SDMEconomy"}) {
                try {
                    LOGGER.info("Trying SDMShop class: {}", (Object)string);
                    sdmShopClass = Class.forName(string);
                    LOGGER.info("\u2713 Found SDMShop class: {}", (Object)string);
                    break;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.debug("\u2717 SDMShop class not found: {}", (Object)string);
                }
            }
            if (sdmShopClass == null) {
                LOGGER.warn("No SDMShop classes found. Tried: {}", (Object)String.join((CharSequence)", ", possibleClasses));
                throw new ClassNotFoundException("No SDMShop classes found");
            }
            String[] getMoneyMethods = new String[]{"getMoney", "getBalance", "getPlayerMoney", "getPlayerBalance"};
            Class[] getMoneyParamTypes = new Class[]{Player.class, ServerPlayer.class, UUID.class, String.class};
            String[] setMoneyMethods = new String[]{"setMoney", "setBalance", "setPlayerMoney", "setPlayerBalance"};
            Class[][] classArrayArray = new Class[][]{{Player.class, Long.TYPE}, {Player.class, Double.TYPE}, {Player.class, Integer.TYPE}, {ServerPlayer.class, Long.TYPE}, {ServerPlayer.class, Double.TYPE}, {ServerPlayer.class, Integer.TYPE}, {UUID.class, Long.TYPE}, {UUID.class, Double.TYPE}, {String.class, Long.TYPE}, {String.class, Double.TYPE}};
            for (String methodName : getMoneyMethods) {
                for (Class clazz : getMoneyParamTypes) {
                    try {
                        getMoneyMethod = sdmShopClass.getMethod(methodName, clazz);
                        LOGGER.info("\u2713 Found getMoney method: {} with parameter type: {}", (Object)methodName, (Object)clazz.getSimpleName());
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.debug("\u2717 Method not found: {}({})", (Object)methodName, (Object)clazz.getSimpleName());
                    }
                }
                if (getMoneyMethod != null) break;
            }
            for (String methodName : setMoneyMethods) {
                for (Class clazz : classArrayArray) {
                    try {
                        setMoneyMethod = sdmShopClass.getMethod(methodName, clazz);
                        LOGGER.info("\u2713 Found setMoney method: {} with parameter types: {}", (Object)methodName, (Object)Arrays.toString((Object[])clazz));
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        LOGGER.debug("\u2717 Method not found: {}({})", (Object)methodName, (Object)Arrays.toString((Object[])clazz));
                    }
                }
                if (setMoneyMethod != null) break;
            }
            if (getMoneyMethod == null) {
                LOGGER.error("Could not find any getMoney method in class: {}", (Object)sdmShopClass.getName());
                Method[] methods = sdmShopClass.getMethods();
                LOGGER.error("Available methods in {}:", (Object)sdmShopClass.getName());
                for (Method method : methods) {
                    LOGGER.error("  - {}", (Object)method.toString());
                }
            }
            if (setMoneyMethod == null) {
                LOGGER.error("Could not find any setMoney method in class: {}", (Object)sdmShopClass.getName());
            }
            if (getMoneyMethod == null || setMoneyMethod == null) {
                throw new NoSuchMethodException("Required SDMShop methods not found");
            }
            available = true;
            LOGGER.info("SDMShop integration successfully initialized");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("SDMShop not found - integration disabled");
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("SDMShop API methods not found - integration disabled: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize SDMShop integration: {}", (Object)e.getMessage());
        }
        initialized = true;
    }

    public static boolean isAvailable() {
        return available;
    }

    public static long getMoney(ServerPlayer player) {
        if (!available || player == null) {
            LOGGER.debug("SDMShop not available or player is null");
            return 0L;
        }
        try {
            long amount;
            Object result;
            LOGGER.debug("Getting money for player: {}", (Object)player.m_7755_().getString());
            Class<?> paramType = getMoneyMethod.getParameterTypes()[0];
            if (paramType == Player.class || paramType == ServerPlayer.class) {
                result = getMoneyMethod.invoke(null, player);
            } else if (paramType == UUID.class) {
                result = getMoneyMethod.invoke(null, player.m_20148_());
            } else if (paramType == String.class) {
                result = getMoneyMethod.invoke(null, player.m_7755_().getString());
            } else {
                LOGGER.error("Unknown parameter type for getMoney: {}", paramType);
                return 0L;
            }
            if (result instanceof Long) {
                amount = (Long)result;
            } else if (result instanceof Double) {
                amount = Math.round((Double)result);
            } else if (result instanceof Integer) {
                amount = ((Integer)result).intValue();
            } else {
                LOGGER.error("Unknown return type from getMoney: {}", result.getClass());
                return 0L;
            }
            LOGGER.debug("Retrieved balance for {}: {}", (Object)player.m_7755_().getString(), (Object)amount);
            return amount;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get money for player {}: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean setMoney(ServerPlayer player, long amount) {
        if (!available || player == null) {
            LOGGER.debug("SDMShop not available or player is null");
            return false;
        }
        try {
            Number secondParam;
            Object firstParam;
            LOGGER.debug("Setting money for player {}: {}", (Object)player.m_7755_().getString(), (Object)amount);
            Class<?>[] paramTypes = setMoneyMethod.getParameterTypes();
            Class<?> firstParamType = paramTypes[0];
            Class<?> secondParamType = paramTypes[1];
            if (firstParamType == Player.class || firstParamType == ServerPlayer.class) {
                firstParam = player;
            } else if (firstParamType == UUID.class) {
                firstParam = player.m_20148_();
            } else if (firstParamType == String.class) {
                firstParam = player.m_7755_().getString();
            } else {
                LOGGER.error("Unknown first parameter type for setMoney: {}", firstParamType);
                return false;
            }
            if (secondParamType == Long.TYPE || secondParamType == Long.class) {
                secondParam = amount;
            } else if (secondParamType == Double.TYPE || secondParamType == Double.class) {
                secondParam = amount;
            } else if (secondParamType == Integer.TYPE || secondParamType == Integer.class) {
                secondParam = (int)amount;
            } else {
                LOGGER.error("Unknown second parameter type for setMoney: {}", secondParamType);
                return false;
            }
            setMoneyMethod.invoke(null, firstParam, secondParam);
            LOGGER.debug("Successfully set money for {}: {}", (Object)player.m_7755_().getString(), (Object)amount);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to set money for player {} to {}: {}", (Object)player.m_7755_().getString(), (Object)amount, (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean addMoney(ServerPlayer player, long amount) {
        if (!available || player == null) {
            return false;
        }
        try {
            long currentBalance = SDMShopIntegration.getMoney(player);
            return SDMShopIntegration.setMoney(player, currentBalance + amount);
        }
        catch (Exception e) {
            LOGGER.error("Failed to add money {} to player {}: {}", (Object)amount, (Object)player.m_7755_().getString(), (Object)e.getMessage());
            return false;
        }
    }

    public static boolean removeMoney(ServerPlayer player, long amount) {
        if (!available || player == null) {
            return false;
        }
        try {
            long currentBalance = SDMShopIntegration.getMoney(player);
            if (currentBalance < amount) {
                return false;
            }
            return SDMShopIntegration.setMoney(player, currentBalance - amount);
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove money {} from player {}: {}", (Object)amount, (Object)player.m_7755_().getString(), (Object)e.getMessage());
            return false;
        }
    }

    public static int deductPlayerBalance(ServerPlayer player, int amount) {
        if (!available || player == null || amount <= 0) {
            return 0;
        }
        long currentBalance = SDMShopIntegration.getMoney(player);
        if (currentBalance < (long)amount) {
            return 0;
        }
        if (SDMShopIntegration.removeMoney(player, amount)) {
            return amount;
        }
        return 0;
    }

    static {
        SDMShopIntegration.initialize();
    }
}

