/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.militia;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.militia.MilitiaAttackGoal;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitizenMilitiaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitizenMilitiaManager.class);
    private final Map<Integer, Set<Integer>> colonyMilitiaMembers = new ConcurrentHashMap<Integer, Set<Integer>>();
    private final Map<Integer, Integer> guardsKilledPerColony = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Integer> militiaKilledPerColony = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Integer> totalDefendersPerColony = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Integer> totalGuardsPerColony = new ConcurrentHashMap<Integer, Integer>();
    private static CitizenMilitiaManager instance;

    private CitizenMilitiaManager() {
    }

    public static CitizenMilitiaManager getInstance() {
        if (instance == null) {
            instance = new CitizenMilitiaManager();
        }
        return instance;
    }

    public int activateMilitia(IColony colony) {
        if (!((Boolean)TaxConfig.ENABLE_CITIZEN_MILITIA.get()).booleanValue()) {
            LOGGER.debug("Militia system disabled in config for colony {}", (Object)colony.getID());
            return 0;
        }
        int colonyId = colony.getID();
        this.deactivateMilitia(colony);
        HashSet<Integer> militiaMembers = new HashSet<Integer>();
        List<ICitizenData> eligibleCitizens = this.getEligibleCitizens(colony);
        int targetMilitiaCount = (int)Math.ceil((double)eligibleCitizens.size() * (Double)TaxConfig.MILITIA_CONVERSION_PERCENTAGE.get());
        Collections.shuffle(eligibleCitizens);
        int converted = 0;
        for (ICitizenData citizen : eligibleCitizens) {
            if (converted >= targetMilitiaCount) break;
            this.applyMilitiaEquipment(citizen);
            this.enableMilitiaCombatAI(citizen);
            militiaMembers.add(citizen.getId());
            ++converted;
            LOGGER.debug("Applied militia equipment and combat AI to citizen {} in colony {}", (Object)citizen.getName(), (Object)colonyId);
        }
        int existingGuards = this.countExistingGuards(colony);
        int totalDefenders = existingGuards + converted;
        this.colonyMilitiaMembers.put(colonyId, militiaMembers);
        this.guardsKilledPerColony.put(colonyId, 0);
        this.militiaKilledPerColony.put(colonyId, 0);
        this.totalDefendersPerColony.put(colonyId, totalDefenders);
        this.totalGuardsPerColony.put(colonyId, existingGuards);
        LOGGER.info("Activated militia for colony {}: {} citizens equipped with weapons", (Object)colonyId, (Object)converted);
        LOGGER.info("DEFENDER COUNT DEBUG - Colony {}: {} existing guards + {} militia = {} total defenders", new Object[]{colonyId, existingGuards, converted, totalDefenders});
        return converted;
    }

    public void deactivateMilitia(IColony colony) {
        int colonyId = colony.getID();
        LOGGER.info("Deactivating militia for colony {}", (Object)colonyId);
        Set militiaMembers = this.colonyMilitiaMembers.getOrDefault(colonyId, new HashSet());
        for (Integer citizenId : militiaMembers) {
            ICitizenData citizen = colony.getCitizenManager().getCivilian(citizenId.intValue());
            if (citizen == null) continue;
            this.removeMilitiaEquipment(citizen);
            this.disableMilitiaCombatAI(citizen);
            LOGGER.debug("Removed militia equipment and combat AI from citizen {} in colony {}", (Object)citizen.getName(), (Object)colonyId);
        }
        this.colonyMilitiaMembers.remove(colonyId);
        LOGGER.info("Deactivated militia for colony {}: {} members restored", (Object)colonyId, (Object)militiaMembers.size());
    }

    private int countExistingGuards(IColony colony) {
        return (int)colony.getCitizenManager().getCitizens().stream().filter(citizen -> {
            IJob job = citizen.getJob();
            return job != null && job.isGuard();
        }).count();
    }

    private List<ICitizenData> getEligibleCitizens(IColony colony) {
        List allCitizens = colony.getCitizenManager().getCitizens();
        LOGGER.debug("Total citizens in colony {}: {}", (Object)colony.getID(), (Object)allCitizens.size());
        return allCitizens.stream().filter(citizen -> {
            String jobName;
            if (citizen.isChild()) {
                LOGGER.debug("Citizen {} is a child - skipping", (Object)citizen.getName());
                return false;
            }
            if (citizen.getEntity().isEmpty()) {
                LOGGER.debug("Citizen {} has no entity - skipping", (Object)citizen.getName());
                return false;
            }
            if (citizen.getCitizenSkillHandler() == null) {
                LOGGER.debug("Citizen {} has no skill handler - skipping", (Object)citizen.getName());
                return false;
            }
            IJob job = citizen.getJob();
            if (job != null && job.isGuard()) {
                LOGGER.debug("Citizen {} is already a guard - skipping", (Object)citizen.getName());
                return false;
            }
            if (job != null && (jobName = job.getJobRegistryEntry().getKey().m_135815_()).equals("deliveryman")) {
                LOGGER.debug("Citizen {} is critical worker ({}) - skipping", (Object)citizen.getName(), (Object)jobName);
                return false;
            }
            LOGGER.debug("Citizen {} is eligible for militia conversion", (Object)citizen.getName());
            return true;
        }).collect(Collectors.toList());
    }

    private void applyMilitiaEquipment(ICitizenData citizen) {
        if (citizen.getEntity().isEmpty()) {
            return;
        }
        try {
            AbstractEntityCitizen entity = (AbstractEntityCitizen)citizen.getEntity().get();
            ItemStack woodenSword = new ItemStack((ItemLike)Items.f_42420_);
            entity.m_8061_(EquipmentSlot.MAINHAND, woodenSword);
            LOGGER.info("Applied militia equipment to {} - wooden sword", (Object)citizen.getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply militia equipment to citizen {}", (Object)citizen.getName(), (Object)e);
        }
    }

    private void removeMilitiaEquipment(ICitizenData citizen) {
        if (citizen.getEntity().isEmpty()) {
            return;
        }
        try {
            AbstractEntityCitizen entity = (AbstractEntityCitizen)citizen.getEntity().get();
            ItemStack mainHand = entity.m_21205_();
            if (mainHand.m_41720_() == Items.f_42420_) {
                entity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                LOGGER.debug("Removed wooden sword from former militia member {}", (Object)citizen.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove equipment from former militia member {}", (Object)citizen.getName(), (Object)e);
        }
    }

    private void enableMilitiaCombatAI(ICitizenData citizen) {
        if (citizen.getEntity().isEmpty()) {
            return;
        }
        try {
            AbstractEntityCitizen entity = (AbstractEntityCitizen)citizen.getEntity().get();
            entity.f_21345_.m_262460_(goal -> true);
            entity.f_21346_.m_262460_(goal -> true);
            entity.f_21345_.m_25352_(0, (Goal)new MilitiaAttackGoal(entity, 1.2));
            entity.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
            entity.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)entity, ServerPlayer.class, 16, true, false, target -> {
                if (target instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    boolean isRaiding = RaidManager.isPlayerCurrentlyRaiding(serverPlayer.m_20148_(), citizen.getColony());
                    if (isRaiding) {
                        LOGGER.info("MILITIA TARGETING: {} is targeting raiding player: {}", (Object)citizen.getName(), (Object)serverPlayer.m_7755_().getString());
                    }
                    return isRaiding;
                }
                return false;
            }));
            LOGGER.info("Enabled custom combat AI for militia member {} (bypasses ATTACK_DAMAGE requirement)", (Object)citizen.getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to enable combat AI for militia member {}", (Object)citizen.getName(), (Object)e);
        }
    }

    private void disableMilitiaCombatAI(ICitizenData citizen) {
        if (citizen.getEntity().isEmpty()) {
            return;
        }
        try {
            AbstractEntityCitizen entity = (AbstractEntityCitizen)citizen.getEntity().get();
            entity.f_21345_.m_262460_(goal -> true);
            entity.f_21346_.m_262460_(goal -> true);
            if (citizen.getJob() != null) {
                entity.getCitizenJobHandler().onJobChanged(citizen.getJob());
            }
            LOGGER.debug("Disabled combat AI and restored original AI for former militia member {}", (Object)citizen.getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to disable combat AI for former militia member {}", (Object)citizen.getName(), (Object)e);
        }
    }

    public void recordDefenderDeath(IColony colony, boolean isGuard) {
        String defenderType;
        int colonyId = colony.getID();
        String string = defenderType = isGuard ? "guard" : "militia";
        if (isGuard) {
            this.guardsKilledPerColony.compute(colonyId, (k, v) -> v == null ? 1 : v + 1);
            LOGGER.info("GUARD ELIMINATED - {} killed in colony {}, total guards eliminated: {}", new Object[]{defenderType.toUpperCase(), colonyId, this.guardsKilledPerColony.get(colonyId)});
        } else {
            this.militiaKilledPerColony.compute(colonyId, (k, v) -> v == null ? 1 : v + 1);
            LOGGER.info("MILITIA ELIMINATED - {} killed in colony {}, total militia eliminated: {}", new Object[]{defenderType.toUpperCase(), colonyId, this.militiaKilledPerColony.get(colonyId)});
        }
    }

    @Deprecated
    public void recordGuardDeath(IColony colony) {
        this.recordDefenderDeath(colony, true);
    }

    public int getDefendersKilled(int colonyId) {
        int guardsKilled = this.guardsKilledPerColony.getOrDefault(colonyId, 0);
        int militiaKilled = this.militiaKilledPerColony.getOrDefault(colonyId, 0);
        return guardsKilled + militiaKilled;
    }

    public int getGuardsKilledCount(int colonyId) {
        return this.guardsKilledPerColony.getOrDefault(colonyId, 0);
    }

    public int getTotalGuardsCount(int colonyId) {
        return this.totalGuardsPerColony.getOrDefault(colonyId, 0);
    }

    @Deprecated
    public int getGuardsKilled(int colonyId) {
        return this.getDefendersKilled(colonyId);
    }

    public int getTotalDefenders(int colonyId) {
        return this.totalDefendersPerColony.getOrDefault(colonyId, 0);
    }

    public double calculateTaxPercentage(int colonyId) {
        int defendersKilled = this.getDefendersKilled(colonyId);
        int totalDefenders = this.getTotalDefenders(colonyId);
        if (totalDefenders == 0) {
            return 0.0;
        }
        if (defendersKilled == 0) {
            return 0.0;
        }
        double maxTaxPercentage = (Double)TaxConfig.MAX_RAID_TAX_PERCENTAGE.get();
        double percentagePerDefender = maxTaxPercentage / (double)totalDefenders;
        double finalPercentage = (double)defendersKilled * percentagePerDefender;
        return Math.min(finalPercentage, maxTaxPercentage);
    }

    public int calculateTaxToSteal(IColony colony, int currentTax) {
        if (!((Boolean)TaxConfig.TAX_STEAL_PER_GUARD_KILLED.get()).booleanValue()) {
            return 0;
        }
        int defendersKilled = this.getDefendersKilled(colony.getID());
        double stealPercentage = (Double)TaxConfig.TAX_STEAL_PERCENTAGE_PER_GUARD.get();
        int taxToSteal = (int)((double)(currentTax * defendersKilled) * stealPercentage);
        LOGGER.debug("Colony {} - Defenders killed: {}, Tax to steal: {} ({}% per defender)", new Object[]{colony.getID(), defendersKilled, taxToSteal, stealPercentage * 100.0});
        return Math.min(taxToSteal, currentTax);
    }

    public boolean isMilitiaMember(int colonyId, int citizenId) {
        Set<Integer> militia = this.colonyMilitiaMembers.get(colonyId);
        return militia != null && militia.contains(citizenId);
    }

    public int getMilitiaCount(int colonyId) {
        Set<Integer> militia = this.colonyMilitiaMembers.get(colonyId);
        return militia != null ? militia.size() : 0;
    }

    public void initializeColonyMilitia(int colonyId) {
        this.colonyMilitiaMembers.putIfAbsent(colonyId, ConcurrentHashMap.newKeySet());
        this.guardsKilledPerColony.putIfAbsent(colonyId, 0);
        this.totalDefendersPerColony.putIfAbsent(colonyId, 0);
        LOGGER.debug("Initialized militia system for colony {}", (Object)colonyId);
    }

    public void addMilitiaMember(int colonyId, int citizenId) {
        this.colonyMilitiaMembers.computeIfAbsent(colonyId, k -> ConcurrentHashMap.newKeySet()).add(citizenId);
        LOGGER.debug("Added citizen {} as militia member in colony {}", (Object)citizenId, (Object)colonyId);
    }

    public void setTotalDefenders(int colonyId, int count) {
        this.totalDefendersPerColony.put(colonyId, count);
        LOGGER.debug("Set total defenders for colony {} to {}", (Object)colonyId, (Object)count);
    }

    public void setTotalGuardsCount(int colonyId, int count) {
        this.totalGuardsPerColony.put(colonyId, count);
        LOGGER.debug("Set total guards for colony {} to {}", (Object)colonyId, (Object)count);
    }

    public void clearColonyMilitia(int colonyId) {
        this.colonyMilitiaMembers.remove(colonyId);
        this.guardsKilledPerColony.remove(colonyId);
        this.militiaKilledPerColony.remove(colonyId);
        this.totalDefendersPerColony.remove(colonyId);
        this.totalGuardsPerColony.remove(colonyId);
        LOGGER.debug("Cleared militia data for colony {}", (Object)colonyId);
    }

    public Set<Integer> getMilitiaMembers(int colonyId) {
        return this.colonyMilitiaMembers.getOrDefault(colonyId, new HashSet());
    }
}

