/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.militia;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilitiaAttackGoal
extends Goal {
    private static final Logger LOGGER = LoggerFactory.getLogger(MilitiaAttackGoal.class);
    private final AbstractEntityCitizen citizen;
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;

    public MilitiaAttackGoal(AbstractEntityCitizen citizen, double speedModifier) {
        this.citizen = citizen;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.citizen.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.citizen.m_9236_().m_6857_().m_61937_(livingentity.m_20183_())) {
            return false;
        }
        this.target = livingentity;
        return true;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.citizen.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.citizen.m_9236_().m_6857_().m_61937_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.citizen.getNavigation().m_5624_((Entity)this.target, this.speedModifier);
        this.citizen.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.attackTime = -1;
        LOGGER.debug("Militia {} started attacking target {}", (Object)this.citizen.m_7755_().getString(), (Object)(this.target != null ? this.target.m_7755_().getString() : "null"));
    }

    public void m_8041_() {
        LivingEntity livingentity = this.citizen.m_5448_();
        if (livingentity != null && !livingentity.m_6084_()) {
            this.target = null;
        }
        this.citizen.m_21561_(false);
        this.citizen.getNavigation().m_26573_();
        LOGGER.debug("Militia {} stopped attacking", (Object)this.citizen.m_7755_().getString());
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        this.citizen.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        double distanceToTarget = this.citizen.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (this.ticksUntilNextPathRecalculation <= 0) {
            this.ticksUntilNextPathRecalculation = 4 + this.citizen.m_217043_().m_188503_(7);
            if (distanceToTarget > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (distanceToTarget > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.citizen.getNavigation().m_5624_((Entity)this.target, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.attackTime = Math.max(this.attackTime - 1, 0);
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        if (distanceToTarget <= 4.0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.performAttack();
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.attackInterval;
    }

    protected void performAttack() {
        if (this.target == null || !this.target.m_6084_()) {
            return;
        }
        try {
            ItemStack mainHand = this.citizen.m_21120_(InteractionHand.MAIN_HAND);
            if (mainHand.m_41619_() || mainHand.m_41720_() != Items.f_42420_) {
                this.citizen.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42420_));
            }
            this.citizen.m_6674_(InteractionHand.MAIN_HAND);
            float damage = 4.0f;
            this.target.m_6469_(this.citizen.m_269291_().m_269333_((LivingEntity)this.citizen), damage);
            LOGGER.debug("Militia {} attacked {} for {} damage", new Object[]{this.citizen.m_7755_().getString(), this.target.m_7755_().getString(), Float.valueOf(damage)});
            double knockbackStrength = 0.4;
            if (this.target instanceof LivingEntity) {
                LivingEntity livingTarget = this.target;
                double deltaX = this.target.m_20185_() - this.citizen.m_20185_();
                double deltaZ = this.target.m_20189_() - this.citizen.m_20189_();
                livingTarget.m_147240_(knockbackStrength, -deltaX, -deltaZ);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during militia attack by {}", (Object)this.citizen.m_7755_().getString(), (Object)e);
        }
    }
}

