/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class GlowClientHandler {
    private static final Map<Integer, Long> glowingEntities = new ConcurrentHashMap<Integer, Long>();

    public static void handleGlowPacket(int entityId, boolean shouldGlow, int durationTicks) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Entity e = level.m_6815_(entityId);
        if (e == null) {
            return;
        }
        if (shouldGlow) {
            e.m_146915_(true);
            long end = level.m_46467_() + (long)Math.max(0, durationTicks);
            glowingEntities.put(entityId, end);
        } else {
            e.m_146915_(false);
            glowingEntities.remove(entityId);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        long now = level.m_46467_();
        Iterator<Map.Entry<Integer, Long>> it = glowingEntities.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Long> entry = it.next();
            int id = entry.getKey();
            long end = entry.getValue();
            Entity e = level.m_6815_(id);
            if (e == null || !e.m_6084_() || now >= end) {
                if (e != null) {
                    e.m_146915_(false);
                }
                it.remove();
                continue;
            }
            e.m_146915_(true);
        }
    }
}

