/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network;

import net.machiavelli.minecolonytax.MineColonyTax;
import net.machiavelli.minecolonytax.network.EntityGlowPacket;
import net.machiavelli.minecolonytax.network.packets.ClaimTaxPacket;
import net.machiavelli.minecolonytax.network.packets.ColonyDataResponsePacket;
import net.machiavelli.minecolonytax.network.packets.EndVassalizationPacket;
import net.machiavelli.minecolonytax.network.packets.OfficerDataResponsePacket;
import net.machiavelli.minecolonytax.network.packets.PayTaxDebtPacket;
import net.machiavelli.minecolonytax.network.packets.RequestColonyDataPacket;
import net.machiavelli.minecolonytax.network.packets.RequestOfficerDataPacket;
import net.machiavelli.minecolonytax.network.packets.UpdatePlayerTaxPermissionPacket;
import net.machiavelli.minecolonytax.network.packets.UpdateTaxPermissionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("minecolonytax", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int nextId() {
        return packetId++;
    }

    public static void register() {
        CHANNEL.registerMessage(NetworkHandler.nextId(), EntityGlowPacket.class, EntityGlowPacket::encode, EntityGlowPacket::decode, EntityGlowPacket::handle);
        CHANNEL.messageBuilder(RequestColonyDataPacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).decoder(RequestColonyDataPacket::new).encoder(RequestColonyDataPacket::toBytes).consumerMainThread(RequestColonyDataPacket::handle).add();
        CHANNEL.messageBuilder(ColonyDataResponsePacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_CLIENT).decoder(ColonyDataResponsePacket::new).encoder(ColonyDataResponsePacket::toBytes).consumerMainThread(ColonyDataResponsePacket::handle).add();
        CHANNEL.messageBuilder(ClaimTaxPacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).decoder(ClaimTaxPacket::new).encoder(ClaimTaxPacket::toBytes).consumerMainThread(ClaimTaxPacket::handle).add();
        CHANNEL.messageBuilder(PayTaxDebtPacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).decoder(PayTaxDebtPacket::new).encoder(PayTaxDebtPacket::toBytes).consumerMainThread(PayTaxDebtPacket::handle).add();
        CHANNEL.messageBuilder(EndVassalizationPacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).decoder(EndVassalizationPacket::new).encoder(EndVassalizationPacket::toBytes).consumerMainThread(EndVassalizationPacket::handle).add();
        CHANNEL.messageBuilder(UpdateTaxPermissionPacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).decoder(UpdateTaxPermissionPacket::new).encoder(UpdateTaxPermissionPacket::toBytes).consumerMainThread(UpdateTaxPermissionPacket::handle).add();
        CHANNEL.messageBuilder(UpdatePlayerTaxPermissionPacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).decoder(UpdatePlayerTaxPermissionPacket::new).encoder(UpdatePlayerTaxPermissionPacket::encode).consumerMainThread(UpdatePlayerTaxPermissionPacket::handle).add();
        CHANNEL.messageBuilder(RequestOfficerDataPacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_SERVER).decoder(RequestOfficerDataPacket::new).encoder(RequestOfficerDataPacket::toBytes).consumerMainThread(RequestOfficerDataPacket::handle).add();
        CHANNEL.messageBuilder(OfficerDataResponsePacket.class, NetworkHandler.nextId(), NetworkDirection.PLAY_TO_CLIENT).decoder(OfficerDataResponsePacket::new).encoder(OfficerDataResponsePacket::toBytes).consumerMainThread(OfficerDataResponsePacket::handle).add();
        MineColonyTax.LOGGER.info("Network channel registered with {} packets", (Object)packetId);
    }

    public static <MSG> void sendToServer(MSG message) {
        CHANNEL.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(ServerPlayer player, MSG message) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
    }
}

