/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.machiavelli.minecolonytax.vassalization.VassalManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClaimTaxPacket {
    private final int colonyId;
    private final int amount;

    public ClaimTaxPacket(int colonyId, int amount) {
        this.colonyId = colonyId;
        this.amount = amount;
    }

    public ClaimTaxPacket(FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.amount = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.amount);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            IColony colony = colonyManager.getAllColonies().stream().filter(c -> c.getID() == this.colonyId).findFirst().orElse(null);
            if (colony == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Colony not found!"));
                return;
            }
            int claimedAmount = 0;
            if (this.amount == -2) {
                claimedAmount = VassalManager.claimVassalTribute(player.m_20148_(), this.colonyId);
                if (claimedAmount <= 0) {
                    player.m_213846_((Component)Component.m_237113_((String)"No tribute available from this vassal colony."));
                    return;
                }
            } else {
                Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
                if (playerRank == null || !playerRank.isColonyManager()) {
                    player.m_213846_((Component)Component.m_237113_((String)"You don't have permission to claim tax from this colony!"));
                    return;
                }
                if (WarSystem.ACTIVE_WARS.containsKey(this.colonyId)) {
                    player.m_213846_((Component)Component.m_237113_((String)"Cannot claim tax while colony is at war!"));
                    return;
                }
                if (RaidManager.getActiveRaidForColony(this.colonyId) != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"Cannot claim tax while colony is under raid!"));
                    return;
                }
                claimedAmount = TaxManager.claimTax(colony, this.amount);
            }
            if (claimedAmount > 0) {
                boolean paymentSuccessful = false;
                if (TaxConfig.isSDMShopConversionEnabled()) {
                    if (SDMShopIntegration.isAvailable()) {
                        long currentBalance = SDMShopIntegration.getMoney(player);
                        paymentSuccessful = SDMShopIntegration.addMoney(player, claimedAmount);
                        if (paymentSuccessful) {
                            long newBalance = SDMShopIntegration.getMoney(player);
                            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u2713 Successfully added " + claimedAmount + " to your balance!")));
                            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a  Balance: " + currentBalance + " \u2192 " + newBalance)));
                        } else {
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u2717 Failed to add money to SDMShop balance!"));
                        }
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u2717 SDMShop integration is not available!"));
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7eCheck that SDMShop mod is installed and working"));
                    }
                } else {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
                    if (item != null) {
                        ItemStack itemStack = new ItemStack((ItemLike)item, claimedAmount);
                        boolean added = player.m_150109_().m_36054_(itemStack);
                        if (!added) {
                            player.m_36176_(itemStack, false);
                            player.m_213846_((Component)Component.m_237110_((String)"taxmanager.inventory_full", (Object[])new Object[]{claimedAmount, TaxConfig.getCurrencyItemName()}));
                        } else {
                            player.m_213846_((Component)Component.m_237110_((String)"taxmanager.currency_received", (Object[])new Object[]{claimedAmount, TaxConfig.getCurrencyItemName()}));
                        }
                        paymentSuccessful = true;
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u2717 Currency item not found: " + TaxConfig.getCurrencyItemName())));
                    }
                }
                if (paymentSuccessful) {
                    player.m_213846_((Component)Component.m_237110_((String)"command.claimtax.success", (Object[])new Object[]{claimedAmount, colony.getName()}));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u2717 Failed to claim tax - payment system error!"));
                }
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"command.claimtax.no_tax", (Object[])new Object[]{colony.getName()}));
            }
        });
        return true;
    }
}

