/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import java.util.function.Supplier;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.vassalization.VassalManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ClaimVassalTributePacket {
    private final int vassalColonyId;

    public ClaimVassalTributePacket(int vassalColonyId) {
        this.vassalColonyId = vassalColonyId;
    }

    public ClaimVassalTributePacket(FriendlyByteBuf buf) {
        this.vassalColonyId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.vassalColonyId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                this.handlePacket(player, this.vassalColonyId);
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    private void handlePacket(ServerPlayer player, int vassalColonyId) {
        try {
            int tributeAmount = VassalManager.claimVassalTribute(player.m_20148_(), vassalColonyId);
            if (tributeAmount > 0) {
                if (TaxConfig.isSDMShopConversionEnabled()) {
                    long currentBalance = SDMShopIntegration.getMoney(player);
                    SDMShopIntegration.setMoney(player, currentBalance + (long)tributeAmount);
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Vassal Tribute] Claimed " + tributeAmount + " coins from vassal colony!")));
                } else {
                    String currencyItemName = TaxConfig.getCurrencyItemName();
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Vassal Tribute] Claimed " + tributeAmount + " " + currencyItemName + " from vassal colony!")));
                }
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Vassal Tribute] No tribute available to claim from this vassal."));
            }
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[Error] Failed to claim vassal tribute: " + e.getMessage())));
        }
    }
}

