/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.gui.TaxManagementScreen;
import net.machiavelli.minecolonytax.gui.data.ColonyTaxData;
import net.machiavelli.minecolonytax.gui.data.VassalIncomeData;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ColonyDataResponsePacket {
    private final List<ColonyTaxData> colonyData;
    private final List<VassalIncomeData> vassalData;

    public ColonyDataResponsePacket(List<ColonyTaxData> colonyData) {
        this.colonyData = colonyData;
        this.vassalData = new ArrayList<VassalIncomeData>();
    }

    public ColonyDataResponsePacket(List<ColonyTaxData> colonyData, List<VassalIncomeData> vassalData) {
        this.colonyData = colonyData;
        this.vassalData = vassalData;
    }

    public ColonyDataResponsePacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.colonyData = new ArrayList<ColonyTaxData>();
        for (int i = 0; i < size; ++i) {
            int colonyId = buf.readInt();
            String colonyName = buf.m_130277_();
            int taxBalance = buf.readInt();
            int maxTaxRevenue = buf.readInt();
            int buildingCount = buf.readInt();
            int guardCount = buf.readInt();
            int guardTowerCount = buf.readInt();
            boolean canClaimTax = buf.readBoolean();
            boolean isAtWar = buf.readBoolean();
            boolean isBeingRaided = buf.readBoolean();
            boolean isVassal = buf.readBoolean();
            int vassalTributeRate = buf.readInt();
            boolean hasVassals = buf.readBoolean();
            int vassalCount = buf.readInt();
            long lastTaxGeneration = buf.readLong();
            int debtAmount = buf.readInt();
            int approximateRevenuePerInterval = buf.readInt();
            boolean isOwner = buf.readBoolean();
            this.colonyData.add(new ColonyTaxData(colonyId, colonyName, taxBalance, maxTaxRevenue, buildingCount, guardCount, guardTowerCount, canClaimTax, isAtWar, isBeingRaided, isVassal, vassalTributeRate, hasVassals, vassalCount, lastTaxGeneration, debtAmount, approximateRevenuePerInterval, isOwner));
        }
        int vassalSize = buf.readInt();
        this.vassalData = new ArrayList<VassalIncomeData>();
        for (int i = 0; i < vassalSize; ++i) {
            int vassalColonyId = buf.readInt();
            String vassalColonyName = buf.m_130277_();
            int tributeRate = buf.readInt();
            int tributeOwed = buf.readInt();
            int lastTribute = buf.readInt();
            long lastPayment = buf.readLong();
            boolean canClaim = buf.readBoolean();
            this.vassalData.add(new VassalIncomeData(vassalColonyId, vassalColonyName, tributeRate, tributeOwed, lastTribute, lastPayment, canClaim));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colonyData.size());
        for (ColonyTaxData colonyTaxData : this.colonyData) {
            buf.writeInt(colonyTaxData.getColonyId());
            buf.m_130070_(colonyTaxData.getColonyName());
            buf.writeInt(colonyTaxData.getTaxBalance());
            buf.writeInt(colonyTaxData.getMaxTaxRevenue());
            buf.writeInt(colonyTaxData.getBuildingCount());
            buf.writeInt(colonyTaxData.getGuardCount());
            buf.writeInt(colonyTaxData.getGuardTowerCount());
            buf.writeBoolean(colonyTaxData.canClaimTax());
            buf.writeBoolean(colonyTaxData.isAtWar());
            buf.writeBoolean(colonyTaxData.isBeingRaided());
            buf.writeBoolean(colonyTaxData.isVassal());
            buf.writeInt(colonyTaxData.getVassalTributeRate());
            buf.writeBoolean(colonyTaxData.hasVassals());
            buf.writeInt(colonyTaxData.getVassalCount());
            buf.writeLong(colonyTaxData.getLastTaxGeneration());
            buf.writeInt(colonyTaxData.getDebtAmount());
            buf.writeInt(colonyTaxData.getApproximateRevenuePerInterval());
            buf.writeBoolean(colonyTaxData.isOwner());
        }
        buf.writeInt(this.vassalData.size());
        for (VassalIncomeData vassalIncomeData : this.vassalData) {
            buf.writeInt(vassalIncomeData.getVassalColonyId());
            buf.m_130070_(vassalIncomeData.getVassalColonyName());
            buf.writeInt(vassalIncomeData.getTributeRate());
            buf.writeInt(vassalIncomeData.getTributeOwed());
            buf.writeInt(vassalIncomeData.getLastTribute());
            buf.writeLong(vassalIncomeData.getLastPayment());
            buf.writeBoolean(vassalIncomeData.canClaim());
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof TaxManagementScreen) {
                TaxManagementScreen screen = (TaxManagementScreen)mc.f_91080_;
                screen.updateColonyData(this.colonyData);
                screen.updateVassalData(this.vassalData);
            }
        });
        return true;
    }
}

