/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.vassalization.VassalManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class EndVassalizationPacket {
    private final int colonyId;

    public EndVassalizationPacket(int colonyId) {
        this.colonyId = colonyId;
    }

    public EndVassalizationPacket(FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            IColony colony = colonyManager.getAllColonies().stream().filter(c -> c.getID() == this.colonyId).findFirst().orElse(null);
            if (colony == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Colony not found!"));
                return;
            }
            Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
            if (playerRank == null || !playerRank.isColonyManager()) {
                player.m_213846_((Component)Component.m_237113_((String)"You don't have permission to end vassalization for this colony!"));
                return;
            }
            if (!VassalManager.isColonyVassal(this.colonyId)) {
                player.m_213846_((Component)Component.m_237113_((String)"This colony is not a vassal!"));
                return;
            }
            boolean success = VassalManager.endVassalizationWithNotification(this.colonyId, player, colony);
            if (success) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7aVassalization ended for " + colony.getName())));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7eYour overlord has been notified of this decision."));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7cFailed to end vassalization!"));
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

