/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.gui.TaxManagementScreen;
import net.machiavelli.minecolonytax.gui.data.OfficerData;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OfficerDataResponsePacket {
    private final List<OfficerData> officers;
    private final int colonyId;

    public OfficerDataResponsePacket(List<OfficerData> officers, int colonyId) {
        this.officers = officers;
        this.colonyId = colonyId;
    }

    public OfficerDataResponsePacket(FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        int count = buf.readInt();
        this.officers = new ArrayList<OfficerData>();
        for (int i = 0; i < count; ++i) {
            UUID playerId = buf.m_130259_();
            String playerName = buf.m_130277_();
            String rank = buf.m_130277_();
            boolean canClaimTax = buf.readBoolean();
            boolean isOnline = buf.readBoolean();
            long lastSeen = buf.readLong();
            this.officers.add(new OfficerData(playerId, playerName, rank, canClaimTax, isOnline, lastSeen));
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.officers.size());
        for (OfficerData officer : this.officers) {
            buf.m_130077_(officer.getPlayerId());
            buf.m_130070_(officer.getPlayerName());
            buf.m_130070_(officer.getRank());
            buf.writeBoolean(officer.canClaimTax());
            buf.writeBoolean(officer.isOnline());
            buf.writeLong(officer.getLastSeen());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof TaxManagementScreen) {
                TaxManagementScreen screen = (TaxManagementScreen)mc.f_91080_;
                screen.updateOfficerData(this.officers, this.colonyId);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

