/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PayDebtPacket {
    private final int colonyId;
    private final int amount;

    public PayDebtPacket(int colonyId, int amount) {
        this.colonyId = colonyId;
        this.amount = amount;
    }

    public static void encode(PayDebtPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.colonyId);
        buffer.writeInt(packet.amount);
    }

    public static PayDebtPacket decode(FriendlyByteBuf buffer) {
        return new PayDebtPacket(buffer.readInt(), buffer.readInt());
    }

    public static void handle(PayDebtPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            int payAmount;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            IColony colony = colonyManager.getAllColonies().stream().filter(c -> c.getID() == packet.colonyId).findFirst().orElse(null);
            if (colony == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Colony not found!"));
                return;
            }
            Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
            if (playerRank == null || !playerRank.isColonyManager()) {
                player.m_213846_((Component)Component.m_237113_((String)"You don't have permission to pay debt for this colony!"));
                return;
            }
            int currentBalance = TaxManager.getStoredTaxForColony(colony);
            if (currentBalance >= 0) {
                player.m_213846_((Component)Component.m_237113_((String)"This colony has no debt to pay!"));
                return;
            }
            int currentDebt = Math.abs(currentBalance);
            int n = payAmount = packet.amount == -1 ? currentDebt : Math.min(packet.amount, currentDebt);
            if (payAmount <= 0) {
                player.m_213846_((Component)Component.m_237113_((String)"No debt to pay!"));
                return;
            }
            boolean hasEnoughFunds = false;
            if (TaxConfig.isSDMShopConversionEnabled()) {
                double playerBalance = SDMShopIntegration.getMoney(player);
                hasEnoughFunds = playerBalance >= (double)payAmount;
            } else {
                Item currencyItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
                if (currencyItem != null) {
                    int itemCount = 0;
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        if (stack.m_41720_() != currencyItem) continue;
                        itemCount += stack.m_41613_();
                    }
                    boolean bl = hasEnoughFunds = itemCount >= payAmount;
                }
            }
            if (!hasEnoughFunds) {
                player.m_213846_((Component)Component.m_237113_((String)"You don't have enough money to pay this debt!"));
                return;
            }
            if (TaxConfig.isSDMShopConversionEnabled()) {
                SDMShopIntegration.removeMoney(player, payAmount);
            } else {
                Item currencyItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
                if (currencyItem != null) {
                    int remainingToRemove = payAmount;
                    for (int i = 0; i < player.m_150109_().f_35974_.size() && remainingToRemove > 0; ++i) {
                        ItemStack stack;
                        stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                        if (stack.m_41720_() != currencyItem) continue;
                        int toRemove = Math.min(remainingToRemove, stack.m_41613_());
                        stack.m_41774_(toRemove);
                        remainingToRemove -= toRemove;
                    }
                }
            }
            TaxManager.payTaxDebt(colony, payAmount);
            player.m_213846_((Component)Component.m_237113_((String)("Paid " + payAmount + " towards colony debt. Remaining debt: " + Math.max(0, currentDebt - payAmount))));
        });
        context.setPacketHandled(true);
    }
}

