/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Rank;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.permissions.TaxPermissionManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PayTaxDebtPacket {
    private final int colonyId;

    public PayTaxDebtPacket(int colonyId) {
        this.colonyId = colonyId;
    }

    public PayTaxDebtPacket(FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            IColony colony = colonyManager.getAllColonies().stream().filter(c -> c.getID() == this.colonyId).findFirst().orElse(null);
            if (colony == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Colony not found!"));
                return;
            }
            Rank playerRank = colony.getPermissions().getRank(player.m_20148_());
            boolean canPayDebt = false;
            if (playerRank != null && playerRank.isColonyManager()) {
                canPayDebt = true;
            } else if (playerRank != null && playerRank.getId() > 0 && TaxPermissionManager.canOfficersClaim(this.colonyId)) {
                canPayDebt = true;
            }
            if (!canPayDebt) {
                player.m_213846_((Component)Component.m_237113_((String)"You don't have permission to pay debt for this colony!"));
                return;
            }
            int currentTax = TaxManager.getStoredTaxForColony(colony);
            if (currentTax >= 0) {
                player.m_213846_((Component)Component.m_237113_((String)"Colony has no debt to pay!"));
                return;
            }
            int debtAmount = Math.abs(currentTax);
            if (!TaxConfig.isSDMShopConversionEnabled()) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u2717 SDMShop conversion is disabled in config!"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7eDebt payment requires SDMShop integration to be enabled"));
                return;
            }
            long currentBalance = SDMShopIntegration.getMoney(player);
            if (!SDMShopIntegration.isAvailable()) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u2717 SDMShop integration is not available!"));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7eCheck that SDMShop mod is installed and working"));
                return;
            }
            if (currentBalance < (long)debtAmount) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u2717 Insufficient funds!"));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c  Need: " + debtAmount + ", Have: " + currentBalance)));
                return;
            }
            int deductedAmount = SDMShopIntegration.deductPlayerBalance(player, debtAmount);
            if (deductedAmount <= 0) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u2717 Failed to deduct payment from your balance!"));
                return;
            }
            long newBalance = SDMShopIntegration.getMoney(player);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u2713 Successfully deducted " + deductedAmount + " from balance")));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a  Balance: " + currentBalance + " \u2192 " + newBalance)));
            int paidAmount = TaxManager.payTaxDebt(colony, deductedAmount);
            player.m_213846_((Component)Component.m_237113_((String)("Paid " + paidAmount + " towards " + colony.getName() + "'s debt. Remaining debt: " + Math.max(0, debtAmount - paidAmount))));
        });
        ctx.get().setPacketHandled(true);
    }
}

