/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import java.util.List;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.gui.data.ColonyTaxData;
import net.machiavelli.minecolonytax.gui.data.VassalIncomeData;
import net.machiavelli.minecolonytax.network.NetworkHandler;
import net.machiavelli.minecolonytax.network.packets.ColonyDataResponsePacket;
import net.machiavelli.minecolonytax.server.ColonyDataCollector;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class RequestColonyDataPacket {
    public RequestColonyDataPacket() {
    }

    public RequestColonyDataPacket(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                List<ColonyTaxData> colonyData = ColonyDataCollector.collectColonyData(player);
                List<VassalIncomeData> vassalData = ColonyDataCollector.collectVassalIncomeData(player);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ColonyDataResponsePacket(colonyData, vassalData));
            }
        });
        return true;
    }
}

