/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.gui.data.OfficerData;
import net.machiavelli.minecolonytax.network.NetworkHandler;
import net.machiavelli.minecolonytax.network.packets.OfficerDataResponsePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class RequestOfficerDataPacket {
    private final int colonyId;

    public RequestOfficerDataPacket() {
        this.colonyId = -1;
    }

    public RequestOfficerDataPacket(int colonyId) {
        this.colonyId = colonyId;
    }

    public RequestOfficerDataPacket(FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                ArrayList<OfficerData> officers = new ArrayList<OfficerData>();
                if (this.colonyId == -1) {
                    for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                        if (!this.hasColonyAccess(player, colony)) continue;
                        officers.addAll(this.getColonyOfficers(colony));
                    }
                } else {
                    IColony colony = IColonyManager.getInstance().getColonyByWorld(this.colonyId, (Level)player.m_284548_());
                    if (colony != null && this.hasColonyAccess(player, colony)) {
                        officers.addAll(this.getColonyOfficers(colony));
                    }
                }
                NetworkHandler.sendToPlayer(player, new OfficerDataResponsePacket(officers, this.colonyId));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private boolean hasColonyAccess(ServerPlayer player, IColony colony) {
        IPermissions permissions = colony.getPermissions();
        return permissions.hasPermission((Player)player, Action.ACCESS_HUTS);
    }

    private List<OfficerData> getColonyOfficers(IColony colony) {
        ArrayList<OfficerData> officers = new ArrayList<OfficerData>();
        IPermissions permissions = colony.getPermissions();
        for (ColonyPlayer colonyPlayer : permissions.getPlayers().values()) {
            UUID playerId = colonyPlayer.getID();
            Rank rank = colonyPlayer.getRank();
            if (rank.getId() <= 1) continue;
            String playerName = colonyPlayer.getName();
            if (playerName == null || playerName.isEmpty()) {
                playerName = "Unknown Player";
            }
            boolean canClaimTax = rank.getId() >= 3;
            boolean isOnline = false;
            long lastSeen = System.currentTimeMillis();
            try {
                MinecraftServer server = colony.getWorld().m_7654_();
                if (server != null) {
                    isOnline = server.m_6846_().m_11259_(playerId) != null;
                }
            }
            catch (Exception e) {
                isOnline = false;
            }
            officers.add(new OfficerData(playerId, playerName, this.getRankName(rank.getId()), canClaimTax, isOnline, lastSeen));
        }
        return officers;
    }

    private String getRankName(int rankId) {
        switch (rankId) {
            case 5: {
                return "Owner";
            }
            case 4: {
                return "Officer";
            }
            case 3: {
                return "Friend";
            }
            case 2: {
                return "Neutral";
            }
            case 1: {
                return "Hostile";
            }
        }
        return "Unknown";
    }
}

