/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.permissions.TaxPermissionManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdatePlayerTaxPermissionPacket {
    private static final Logger LOGGER = LogManager.getLogger(UpdatePlayerTaxPermissionPacket.class);
    private final int colonyId;
    private final UUID playerId;
    private final boolean allowed;

    public UpdatePlayerTaxPermissionPacket(int colonyId, UUID playerId, boolean allowed) {
        this.colonyId = colonyId;
        this.playerId = playerId;
        this.allowed = allowed;
    }

    public UpdatePlayerTaxPermissionPacket(FriendlyByteBuf buffer) {
        this.colonyId = buffer.readInt();
        this.playerId = buffer.m_130259_();
        this.allowed = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.colonyId);
        buffer.m_130077_(this.playerId);
        buffer.writeBoolean(this.allowed);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                LOGGER.warn("UpdatePlayerTaxPermissionPacket received with null sender");
                return;
            }
            try {
                TaxPermissionManager.setPlayerClaimPermission(this.colonyId, this.playerId, this.allowed);
                LOGGER.info("Player {} updated tax claim permission for player {} in colony {} to: {}", (Object)player.m_36316_().getName(), (Object)this.playerId, (Object)this.colonyId, (Object)this.allowed);
            }
            catch (Exception e) {
                LOGGER.error("Error handling UpdatePlayerTaxPermissionPacket from player {}: {}", (Object)player.m_36316_().getName(), (Object)e.getMessage(), (Object)e);
            }
        });
        context.setPacketHandled(true);
    }
}

