/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.network.packets;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import java.util.function.Supplier;
import net.machiavelli.minecolonytax.permissions.TaxPermissionManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class UpdateTaxPermissionPacket {
    private final int colonyId;
    private final boolean allowOfficers;

    public UpdateTaxPermissionPacket(int colonyId, boolean allowOfficers) {
        this.colonyId = colonyId;
        this.allowOfficers = allowOfficers;
    }

    public UpdateTaxPermissionPacket(FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.allowOfficers = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.allowOfficers);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                IColony colony = IColonyManager.getInstance().getColonyByWorld(this.colonyId, (Level)player.m_284548_());
                if (colony != null) {
                    IPermissions permissions = colony.getPermissions();
                    if (permissions.hasPermission((Player)player, Action.MANAGE_HUTS)) {
                        TaxPermissionManager.setOfficerClaimPermission(this.colonyId, this.allowOfficers);
                        String status = this.allowOfficers ? "allowed" : "blocked";
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7aTax claiming permissions updated! Officers are now " + status + " from claiming taxes for " + colony.getName())));
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7cYou must be the colony owner to change tax permissions!"));
                    }
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7cColony not found!"));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

