/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.peace;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import java.util.Map;
import java.util.UUID;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.event.WarEconomyHandler;
import net.machiavelli.minecolonytax.peace.PeaceProposal;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeaceProposalManager {
    private static final Logger LOGGER = LogManager.getLogger(PeaceProposalManager.class);

    public int suePeaceWhite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.handleSuePeaceProposal(ctx, PeaceProposal.Type.WHITEPEACE, 0);
    }

    public int suePeaceReparations(CommandContext<CommandSourceStack> ctx, int amount) throws CommandSyntaxException {
        return this.handleSuePeaceProposal(ctx, PeaceProposal.Type.REPARATIONS, amount);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int handleSuePeaceProposal(CommandContext<CommandSourceStack> ctx, PeaceProposal.Type type, int amount) throws CommandSyntaxException {
        Team userTeam;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active war."));
            return 0;
        }
        if (war.getActiveProposal() != null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"A peace proposal is already active!"));
            return 0;
        }
        PeaceProposal proposal = new PeaceProposal(type, amount, player.m_20148_());
        war.setActiveProposal(proposal);
        MutableComponent acceptButton = Component.m_237113_((String)"[Accept Peace]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt peace accept")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Only the colony owner may confirm!"))));
        MutableComponent declineButton = Component.m_237113_((String)"[Decline]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt peace decline")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Only the colony owner may decline!"))));
        MutableComponent msg = Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)player.m_7755_().getString()).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" proposes ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(type.toString() + " Peace")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)("! (Reparations = " + amount + " coins)\n")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)acceptButton).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)declineButton);
        Team team = userTeam = WarSystem.FTB_TEAMS_INSTALLED ? (Team)WarSystem.FTB_TEAM_MANAGER.getPlayerTeamForPlayerID(player.m_20148_()).orElse(null) : null;
        if (WarSystem.FTB_TEAMS_INSTALLED && userTeam != null) {
            if (userTeam.getId().equals(war.getAttackerTeamID())) {
                this.sendMessageToTeamFallback(war, false, (Component)msg);
            } else {
                if (!userTeam.getId().equals(war.getDefenderTeamID())) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Error: Your team is not part of this war."));
                    return 0;
                }
                this.sendMessageToTeamFallback(war, true, (Component)msg);
            }
        } else if (war.getAttackerLives().containsKey(player.m_20148_())) {
            this.sendMessageToTeamFallback(war, false, (Component)msg);
        } else {
            if (!war.getDefenderLives().containsKey(player.m_20148_())) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Error: You are not registered in this war."));
                return 0;
            }
            this.sendMessageToTeamFallback(war, true, (Component)msg);
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Peace proposal sent to the opposing side."), false);
        return 1;
    }

    public int acceptPeace(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        boolean isPlayerDefenderSide;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You are not currently in a war."));
            return 0;
        }
        PeaceProposal proposal = war.getActiveProposal();
        if (proposal == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active peace proposal to accept."));
            return 0;
        }
        UUID owner = war.getColony().getPermissions().getOwner();
        boolean isPlayerAttackerSide = war.getAttackerLives().containsKey(player.m_20148_()) || WarSystem.FTB_TEAMS_INSTALLED && WarSystem.FTB_TEAM_MANAGER.getTeamForPlayerID(player.m_20148_()).map(t -> t.getId().equals(war.getAttackerTeamID())).orElse(false) != false;
        boolean bl = isPlayerDefenderSide = war.getDefenderLives().containsKey(player.m_20148_()) || WarSystem.FTB_TEAMS_INSTALLED && WarSystem.FTB_TEAM_MANAGER.getTeamForPlayerID(player.m_20148_()).map(t -> t.getId().equals(war.getDefenderTeamID())).orElse(false) != false;
        if (!this.isAuthorizedToRespondToPeace(player, war)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Only an authorized player from the opposing side can accept/decline the peace proposal!"));
            return 0;
        }
        this.finalizePeaceProposal(war, true, player);
        return 1;
    }

    public int declinePeace(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        WarData war = WarSystem.getActiveWarForPlayer(player);
        if (war == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"You are not currently in a war."));
            return 0;
        }
        PeaceProposal proposal = war.getActiveProposal();
        if (proposal == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active peace proposal to decline."));
            return 0;
        }
        if (!this.isAuthorizedToRespondToPeace(player, war)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Only an authorized player from the opposing side can accept/decline the peace proposal!"));
            return 0;
        }
        boolean wasPlayerOnAttackerSideWhenProposed = war.getAttackerLives().containsKey(proposal.getProposer());
        ServerPlayer proposer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(proposal.getProposer());
        if (proposer != null) {
            proposer.m_213846_((Component)Component.m_237113_((String)("Your peace proposal was declined by " + player.m_7755_().getString())).m_130940_(ChatFormatting.RED));
        }
        player.m_213846_((Component)Component.m_237113_((String)"You have declined the peace proposal.").m_130940_(ChatFormatting.YELLOW));
        war.setActiveProposal(null);
        return 1;
    }

    private boolean isAuthorizedToRespondToPeace(ServerPlayer responder, WarData war) {
        PeaceProposal proposal = war.getActiveProposal();
        if (proposal == null || proposal.getProposer() == null) {
            return false;
        }
        UUID responderId = responder.m_20148_();
        UUID proposerId = proposal.getProposer();
        boolean responderIsAttacker = war.getAttackerLives().containsKey(responderId);
        boolean responderIsDefender = war.getDefenderLives().containsKey(responderId);
        boolean proposerIsAttacker = war.getAttackerLives().containsKey(proposerId);
        boolean proposerIsDefender = war.getDefenderLives().containsKey(proposerId);
        if (responderIsAttacker && proposerIsAttacker || responderIsDefender && proposerIsDefender) {
            return false;
        }
        if (responderIsAttacker && war.getAttackerColony() != null && war.getAttackerColony().getPermissions().getOwner().equals(responderId)) {
            return true;
        }
        return responderIsDefender && war.getColony() != null && war.getColony().getPermissions().getOwner().equals(responderId);
    }

    private void finalizePeaceProposal(WarData war, boolean accepted, ServerPlayer responder) {
        PeaceProposal proposal = war.getActiveProposal();
        if (proposal == null) {
            return;
        }
        ServerPlayer proposer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(proposal.getProposer());
        if (!accepted) {
            if (proposer != null) {
                proposer.m_213846_((Component)Component.m_237113_((String)("Your peace proposal was declined by " + responder.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            }
            responder.m_213846_((Component)Component.m_237113_((String)"You have declined the peace proposal.").m_130940_(ChatFormatting.YELLOW));
            war.setActiveProposal(null);
            return;
        }
        String acceptedMessageToProposer = "Your peace proposal was accepted by " + responder.m_7755_().getString() + "! ";
        String acceptedMessageToResponder = "You have accepted the peace proposal! ";
        switch (proposal.getType()) {
            case WHITEPEACE: {
                MutableComponent whitePeaceMsg = Component.m_237113_((String)"White Peace agreed! War ends now, no reparations needed.").m_130940_(ChatFormatting.GREEN);
                if (proposer != null) {
                    proposer.m_213846_((Component)Component.m_237113_((String)acceptedMessageToProposer).m_7220_((Component)whitePeaceMsg));
                }
                responder.m_213846_((Component)Component.m_237113_((String)acceptedMessageToResponder).m_7220_((Component)whitePeaceMsg));
                this.sendMessageToTeamFallback(war, true, (Component)whitePeaceMsg);
                this.sendMessageToTeamFallback(war, false, (Component)whitePeaceMsg);
                WarSystem.endWar(war.getColony());
                break;
            }
            case REPARATIONS: {
                UUID winningPlayerId;
                UUID losingTeamId;
                boolean proposerWasAttacker = war.getAttackerLives().containsKey(proposal.getProposer());
                if (proposerWasAttacker) {
                    losingTeamId = war.getAttackerTeamID();
                    winningPlayerId = war.getColony().getPermissions().getOwner();
                } else {
                    losingTeamId = war.getDefenderTeamID();
                    winningPlayerId = war.getAttackerColony().getPermissions().getOwner();
                }
                long demandedAmount = proposal.getAmount();
                long teamTotal = WarEconomyHandler.getTeamTotalBalance(losingTeamId);
                if (teamTotal < demandedAmount) {
                    MutableComponent notEnoughFundsMsg = Component.m_237113_((String)("Reparations proposal failed: Not enough funds to pay " + demandedAmount)).m_130940_(ChatFormatting.RED);
                    if (proposer != null) {
                        proposer.m_213846_((Component)notEnoughFundsMsg);
                    }
                    responder.m_213846_((Component)notEnoughFundsMsg);
                    war.setActiveProposal(null);
                    return;
                }
                boolean success = WarEconomyHandler.payReparationsProportionally(losingTeamId, winningPlayerId, demandedAmount);
                if (!success) {
                    MutableComponent unexpectedErrorMsg = Component.m_237113_((String)"Reparations payment failed unexpectedly.").m_130940_(ChatFormatting.RED);
                    if (proposer != null) {
                        proposer.m_213846_((Component)unexpectedErrorMsg);
                    }
                    responder.m_213846_((Component)unexpectedErrorMsg);
                    war.setActiveProposal(null);
                    return;
                }
                MutableComponent reparationsPaidMsg = Component.m_237113_((String)("Reparations paid! " + demandedAmount + " coins transferred. War is ended.")).m_130940_(ChatFormatting.GREEN);
                if (proposer != null) {
                    proposer.m_213846_((Component)Component.m_237113_((String)acceptedMessageToProposer).m_7220_((Component)reparationsPaidMsg));
                }
                responder.m_213846_((Component)Component.m_237113_((String)acceptedMessageToResponder).m_7220_((Component)reparationsPaidMsg));
                MutableComponent losingTeamMsg = Component.m_237113_((String)("Reparations accepted! " + demandedAmount + " coins were paid by your side. War is ended.")).m_130940_(ChatFormatting.GREEN);
                MutableComponent winningTeamMsg = Component.m_237113_((String)("Reparations accepted! " + demandedAmount + " coins were received by your side. War is ended.")).m_130940_(ChatFormatting.GREEN);
                if (proposerWasAttacker) {
                    this.sendMessageToTeamFallback(war, true, (Component)losingTeamMsg);
                    this.sendMessageToTeamFallback(war, false, (Component)winningTeamMsg);
                } else {
                    this.sendMessageToTeamFallback(war, false, (Component)losingTeamMsg);
                    this.sendMessageToTeamFallback(war, true, (Component)winningTeamMsg);
                }
                WarSystem.endWar(war.getColony());
            }
        }
        war.setActiveProposal(null);
    }

    private void sendMessageToTeamFallback(WarData war, boolean sendToAttacker, Component msg) {
        if (WarSystem.FTB_TEAMS_INSTALLED) {
            Team team;
            TeamManager manager = WarSystem.FTB_TEAM_MANAGER;
            if (manager == null) {
                return;
            }
            Team team2 = team = sendToAttacker ? (Team)manager.getTeamByID(war.getAttackerTeamID()).orElse(null) : (Team)manager.getTeamByID(war.getDefenderTeamID()).orElse(null);
            if (team != null) {
                for (UUID member : team.getMembers()) {
                    ServerPlayer sp = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(member);
                    if (sp == null) continue;
                    sp.m_213846_(msg);
                }
                return;
            }
        }
        Map<UUID, Integer> livesMap = sendToAttacker ? war.getAttackerLives() : war.getDefenderLives();
        livesMap.forEach((uuid, lives) -> {
            ServerPlayer sp = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
            if (sp != null) {
                sp.m_213846_(msg);
            }
        });
    }
}

