/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.permissions;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GeneralColonyPermissionsManager {
    private static final Logger LOGGER = LogManager.getLogger(GeneralColonyPermissionsManager.class);
    private static final Map<Integer, Map<Action, Boolean>> originalNeutralPermissions = new HashMap<Integer, Map<Action, Boolean>>();
    private static final Map<Integer, Map<Action, Boolean>> originalHostilePermissions = new HashMap<Integer, Map<Action, Boolean>>();
    private static final Map<Integer, Boolean> coloniesWithGeneralPermissions = new HashMap<Integer, Boolean>();
    private static int scanTicker = 0;

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (TaxConfig.isGeneralItemInteractionsEnabled()) {
            LOGGER.info("Applying general colony permissions to all colonies...");
            GeneralColonyPermissionsManager.applyGeneralPermissionsToAllColonies();
        } else {
            LOGGER.info("General colony permissions are disabled in configuration");
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++scanTicker < 200) {
            return;
        }
        scanTicker = 0;
        if (!TaxConfig.isGeneralItemInteractionsEnabled()) {
            return;
        }
        try {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                if (coloniesWithGeneralPermissions.getOrDefault(colony.getID(), false).booleanValue()) continue;
                GeneralColonyPermissionsManager.applyGeneralPermissions(colony);
                LOGGER.debug("Auto-applied general permissions during periodic scan to colony '{}' (ID: {})", (Object)colony.getName(), (Object)colony.getID());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during periodic general permissions scan", (Throwable)e);
        }
    }

    public static void applyGeneralPermissionsToAllColonies() {
        if (!TaxConfig.isGeneralItemInteractionsEnabled()) {
            return;
        }
        try {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                GeneralColonyPermissionsManager.applyGeneralPermissions(colony);
            }
            LOGGER.info("General colony permissions applied to {} colonies", (Object)IColonyManager.getInstance().getAllColonies().size());
        }
        catch (Exception e) {
            LOGGER.error("Error applying general permissions to all colonies", (Throwable)e);
        }
    }

    public static void applyGeneralPermissions(IColony colony) {
        if (!TaxConfig.isGeneralItemInteractionsEnabled() || colony == null) {
            return;
        }
        try {
            int colonyId = colony.getID();
            if (coloniesWithGeneralPermissions.getOrDefault(colonyId, false).booleanValue()) {
                return;
            }
            IPermissions permissions = colony.getPermissions();
            Set<Action> allowedActions = TaxConfig.getGeneralColonyActionSet();
            if (allowedActions.isEmpty()) {
                LOGGER.warn("No valid general colony actions configured");
                return;
            }
            GeneralColonyPermissionsManager.storeOriginalPermissions(colony, allowedActions);
            Rank neutralRank = permissions.getRankNeutral();
            for (Action action : allowedActions) {
                permissions.setPermission(neutralRank, action, true);
            }
            Rank hostileRank = permissions.getRankHostile();
            for (Action action : allowedActions) {
                permissions.setPermission(hostileRank, action, true);
            }
            coloniesWithGeneralPermissions.put(colonyId, true);
            LOGGER.debug("Applied general permissions to colony '{}' (ID: {}): {}", (Object)colony.getName(), (Object)colonyId, allowedActions);
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply general permissions to colony '{}' (ID: {})", (Object)colony.getName(), (Object)colony.getID(), (Object)e);
        }
    }

    public static void removeGeneralPermissions(IColony colony) {
        if (colony == null) {
            return;
        }
        try {
            Map<Action, Boolean> originalHostile;
            int colonyId = colony.getID();
            if (!coloniesWithGeneralPermissions.getOrDefault(colonyId, false).booleanValue()) {
                return;
            }
            IPermissions permissions = colony.getPermissions();
            Map<Action, Boolean> originalNeutral = originalNeutralPermissions.get(colonyId);
            if (originalNeutral != null) {
                Rank neutralRank = permissions.getRankNeutral();
                for (Map.Entry<Action, Boolean> entry : originalNeutral.entrySet()) {
                    permissions.setPermission(neutralRank, entry.getKey(), entry.getValue().booleanValue());
                }
            }
            if ((originalHostile = originalHostilePermissions.get(colonyId)) != null) {
                Rank hostileRank = permissions.getRankHostile();
                for (Map.Entry<Action, Boolean> entry : originalHostile.entrySet()) {
                    permissions.setPermission(hostileRank, entry.getKey(), entry.getValue().booleanValue());
                }
            }
            coloniesWithGeneralPermissions.remove(colonyId);
            originalNeutralPermissions.remove(colonyId);
            originalHostilePermissions.remove(colonyId);
            LOGGER.debug("Removed general permissions from colony '{}' (ID: {})", (Object)colony.getName(), (Object)colonyId);
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove general permissions from colony '{}' (ID: {})", (Object)colony.getName(), (Object)colony.getID(), (Object)e);
        }
    }

    public static void removeGeneralPermissionsFromAllColonies() {
        try {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                GeneralColonyPermissionsManager.removeGeneralPermissions(colony);
            }
            LOGGER.info("General colony permissions removed from all colonies");
        }
        catch (Exception e) {
            LOGGER.error("Error removing general permissions from all colonies", (Throwable)e);
        }
    }

    public static void reapplyGeneralPermissions() {
        LOGGER.info("Reapplying general colony permissions...");
        GeneralColonyPermissionsManager.removeGeneralPermissionsFromAllColonies();
        if (TaxConfig.isGeneralItemInteractionsEnabled()) {
            GeneralColonyPermissionsManager.applyGeneralPermissionsToAllColonies();
        }
    }

    private static void storeOriginalPermissions(IColony colony, Set<Action> actions) {
        int colonyId = colony.getID();
        IPermissions permissions = colony.getPermissions();
        HashMap<Action, Boolean> neutralPermissions = new HashMap<Action, Boolean>();
        Rank neutralRank = permissions.getRankNeutral();
        for (Action action : actions) {
            neutralPermissions.put(action, permissions.hasPermission(neutralRank, action));
        }
        originalNeutralPermissions.put(colonyId, neutralPermissions);
        HashMap<Action, Boolean> hostilePermissions = new HashMap<Action, Boolean>();
        Rank hostileRank = permissions.getRankHostile();
        for (Action action : actions) {
            hostilePermissions.put(action, permissions.hasPermission(hostileRank, action));
        }
        originalHostilePermissions.put(colonyId, hostilePermissions);
    }

    public static void onColonyCreated(IColony colony) {
        if (TaxConfig.isGeneralItemInteractionsEnabled()) {
            LOGGER.debug("Applying general permissions to newly created colony: {}", (Object)colony.getName());
            GeneralColonyPermissionsManager.applyGeneralPermissions(colony);
        }
    }

    public static void onColonyDeleted(int colonyId) {
        coloniesWithGeneralPermissions.remove(colonyId);
        originalNeutralPermissions.remove(colonyId);
        originalHostilePermissions.remove(colonyId);
        LOGGER.debug("Cleaned up general permissions tracking for deleted colony ID: {}", (Object)colonyId);
    }

    public static boolean hasGeneralPermissions(IColony colony) {
        return colony != null && coloniesWithGeneralPermissions.getOrDefault(colony.getID(), false) != false;
    }

    public static Map<Integer, Boolean> getGeneralPermissionsStatus() {
        return new HashMap<Integer, Boolean>(coloniesWithGeneralPermissions);
    }
}

