/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.permissions;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaxPermissionManager {
    private static final Logger LOGGER = LogManager.getLogger(TaxPermissionManager.class);
    private static final Map<Integer, Boolean> OFFICER_CLAIM_PERMISSIONS = new ConcurrentHashMap<Integer, Boolean>();
    private static final Map<Integer, Map<UUID, Boolean>> INDIVIDUAL_CLAIM_PERMISSIONS = new ConcurrentHashMap<Integer, Map<UUID, Boolean>>();

    public static boolean canPlayerClaimTax(int colonyId, UUID playerId, boolean isOwner, boolean isOfficer) {
        if (isOwner) {
            return true;
        }
        if (isOfficer) {
            Map<UUID, Boolean> colonyIndividualPerms = INDIVIDUAL_CLAIM_PERMISSIONS.get(colonyId);
            if (colonyIndividualPerms != null && colonyIndividualPerms.containsKey(playerId)) {
                return colonyIndividualPerms.get(playerId);
            }
            return TaxPermissionManager.canOfficersClaim(colonyId);
        }
        return false;
    }

    public static boolean canOfficersClaim(int colonyId) {
        return OFFICER_CLAIM_PERMISSIONS.getOrDefault(colonyId, true);
    }

    public static void setPlayerClaimPermission(int colonyId, UUID playerId, boolean allowed) {
        INDIVIDUAL_CLAIM_PERMISSIONS.computeIfAbsent(colonyId, k -> new ConcurrentHashMap()).put(playerId, allowed);
        LOGGER.info("Colony {} player {} tax claim permission set to: {}", (Object)colonyId, (Object)playerId, (Object)allowed);
    }

    public static boolean togglePlayerClaimPermission(int colonyId, UUID playerId, boolean isOfficer) {
        Map<UUID, Boolean> colonyIndividualPerms = INDIVIDUAL_CLAIM_PERMISSIONS.get(colonyId);
        boolean currentPermission = colonyIndividualPerms != null && colonyIndividualPerms.containsKey(playerId) ? colonyIndividualPerms.get(playerId) : (isOfficer ? TaxPermissionManager.canOfficersClaim(colonyId) : false);
        boolean newState = !currentPermission;
        TaxPermissionManager.setPlayerClaimPermission(colonyId, playerId, newState);
        return newState;
    }

    public static void setOfficerClaimPermission(int colonyId, boolean allowed) {
        OFFICER_CLAIM_PERMISSIONS.put(colonyId, allowed);
        LOGGER.info("Colony {} officer tax claim permission set to: {}", (Object)colonyId, (Object)allowed);
    }

    public static boolean toggleOfficerClaimPermission(int colonyId) {
        boolean newState = !TaxPermissionManager.canOfficersClaim(colonyId);
        TaxPermissionManager.setOfficerClaimPermission(colonyId, newState);
        return newState;
    }

    public static void removePlayerPermission(int colonyId, UUID playerId) {
        Map<UUID, Boolean> colonyIndividualPerms = INDIVIDUAL_CLAIM_PERMISSIONS.get(colonyId);
        if (colonyIndividualPerms != null) {
            colonyIndividualPerms.remove(playerId);
            if (colonyIndividualPerms.isEmpty()) {
                INDIVIDUAL_CLAIM_PERMISSIONS.remove(colonyId);
            }
            LOGGER.info("Removed individual tax permission for player {} in colony {}", (Object)playerId, (Object)colonyId);
        }
    }

    public static void clearAllPermissions() {
        OFFICER_CLAIM_PERMISSIONS.clear();
        INDIVIDUAL_CLAIM_PERMISSIONS.clear();
        LOGGER.info("All tax permissions cleared");
    }

    public static Map<Integer, Boolean> getAllPermissions() {
        return new ConcurrentHashMap<Integer, Boolean>(OFFICER_CLAIM_PERMISSIONS);
    }

    public static Map<Integer, Map<UUID, Boolean>> getAllIndividualPermissions() {
        return new ConcurrentHashMap<Integer, Map<UUID, Boolean>>(INDIVIDUAL_CLAIM_PERMISSIONS);
    }

    public static void loadPermissions(Map<Integer, Boolean> permissions) {
        OFFICER_CLAIM_PERMISSIONS.clear();
        OFFICER_CLAIM_PERMISSIONS.putAll(permissions);
        LOGGER.info("Loaded {} tax permission entries", (Object)permissions.size());
    }

    public static void loadIndividualPermissions(Map<Integer, Map<UUID, Boolean>> permissions) {
        INDIVIDUAL_CLAIM_PERMISSIONS.clear();
        INDIVIDUAL_CLAIM_PERMISSIONS.putAll(permissions);
        LOGGER.info("Loaded {} individual tax permission entries", (Object)permissions.size());
    }
}

