/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.pvp.PvPManager;
import net.machiavelli.minecolonytax.pvp.model.ActiveBattle;
import net.machiavelli.minecolonytax.pvp.model.BattleRequest;
import net.machiavelli.minecolonytax.pvp.model.PlayerPvPStats;
import net.machiavelli.minecolonytax.pvp.model.PvPMap;
import net.machiavelli.minecolonytax.pvp.model.SpectatorData;
import net.machiavelli.minecolonytax.pvp.model.TeamBattle;
import net.machiavelli.minecolonytax.pvp.model.TeamBattleState;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PvPBattleManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PvPManager pvpManager = PvPManager.INSTANCE;

    public void handlePlayerDefeat(ServerPlayer player, ActiveBattle battle, DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)entity;
            if (battle.getEnemies(player.m_20148_()).contains(killer.m_20148_())) {
                this.updatePlayerKill(killer.m_20148_());
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)"You have been eliminated from the battle!").m_130940_(ChatFormatting.RED));
        boolean isDuel = battle.getTeams().size() == 2 && battle.getTeams().get(0).size() == 1 && battle.getTeams().get(1).size() == 1;
        this.updatePlayerStats(player.m_20148_(), false, true, !isDuel);
        this.checkForBattleEnd(battle);
    }

    public void startTeamBattle(TeamBattle teamBattle) {
        if (!teamBattle.canStart()) {
            return;
        }
        String mapName = teamBattle.getMapName();
        PvPMap map = this.pvpManager.arenaMapsByName.get(mapName);
        if (map == null) {
            this.notifyTeamBattlePlayers(teamBattle, (Component)Component.m_237113_((String)"Map not found! Battle cancelled.").m_130940_(ChatFormatting.RED));
            this.pvpManager.pendingTeamBattles.remove(teamBattle.getBattleId());
            return;
        }
        if (map.getSpawnPoints().size() < teamBattle.getTotalPlayers()) {
            this.notifyTeamBattlePlayers(teamBattle, (Component)Component.m_237113_((String)("Not enough spawn points on map for " + teamBattle.getTotalPlayers() + " players! Battle cancelled.")).m_130940_(ChatFormatting.RED));
            this.pvpManager.pendingTeamBattles.remove(teamBattle.getBattleId());
            return;
        }
        List<GlobalPos> validSpawnPoints = map.getSpawnPoints().stream().filter(pos -> pos != null).toList();
        if (validSpawnPoints.size() < teamBattle.getTotalPlayers()) {
            this.notifyTeamBattlePlayers(teamBattle, (Component)Component.m_237113_((String)("Not enough valid spawn points on map for " + teamBattle.getTotalPlayers() + " players! Battle cancelled.")).m_130940_(ChatFormatting.RED));
            this.pvpManager.pendingTeamBattles.remove(teamBattle.getBattleId());
            return;
        }
        if (this.pvpManager.lockedMaps.contains(mapName)) {
            this.notifyTeamBattlePlayers(teamBattle, (Component)Component.m_237113_((String)"Map is currently in use! Battle cancelled.").m_130940_(ChatFormatting.RED));
            this.pvpManager.pendingTeamBattles.remove(teamBattle.getBattleId());
            return;
        }
        this.lockMap(mapName);
        teamBattle.setState(TeamBattleState.IN_PROGRESS);
        List<List<UUID>> teams = List.of(new ArrayList<UUID>(teamBattle.getTeam1()), new ArrayList<UUID>(teamBattle.getTeam2()));
        String battleId = "ab_" + System.currentTimeMillis();
        ActiveBattle activeBattle = new ActiveBattle(battleId, teams, validSpawnPoints, mapName);
        this.pvpManager.activeBattles.put(battleId, activeBattle);
        this.pvpManager.pendingTeamBattles.remove(teamBattle.getBattleId());
        this.startBattle(activeBattle);
    }

    public void handleBattleTimerExpiry(String battleId) {
        ActiveBattle battle = this.pvpManager.activeBattles.get(battleId);
        if (battle == null) {
            return;
        }
        HashMap<Integer, Integer> teamPlayerCounts = new HashMap<Integer, Integer>();
        for (int teamIndex = 0; teamIndex < battle.getTeams().size(); ++teamIndex) {
            int aliveCount = 0;
            for (UUID playerId : battle.getTeams().get(teamIndex)) {
                ServerPlayer player = this.getPlayerByUUID(playerId);
                if (player == null || player.f_8941_.m_9290_() == GameType.SPECTATOR) continue;
                ++aliveCount;
            }
            teamPlayerCounts.put(teamIndex, aliveCount);
        }
        int maxPlayers = teamPlayerCounts.values().stream().mapToInt(Integer::intValue).max().orElse(0);
        List<Integer> teamsWithMaxPlayers = teamPlayerCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() == maxPlayers).map(Map.Entry::getKey).toList();
        if (maxPlayers == 0) {
            this.endBattleAsDraw(battle, "Time expired - all players eliminated!");
        } else if (teamsWithMaxPlayers.size() == 1) {
            this.endBattleWithWinner(battle, teamsWithMaxPlayers.get(0), "Time expired - victory by player count!");
        } else {
            this.endBattleAsDraw(battle, "Time expired - tie!");
        }
    }

    public void sendBattleTimerNotifications(String battleId, int remainingTicks) {
        ActiveBattle battle = this.pvpManager.activeBattles.get(battleId);
        if (battle == null) {
            return;
        }
        int secondsRemaining = remainingTicks / 20;
        int lastNotified = this.pvpManager.lastNotificationTime.getOrDefault(battleId, -1);
        if (secondsRemaining != lastNotified && (secondsRemaining % 60 == 0 || secondsRemaining <= 10)) {
            int minutes;
            MutableComponent message = secondsRemaining > 60 ? Component.m_237113_((String)("Battle time remaining: " + minutes + " minute" + ((minutes = secondsRemaining / 60) > 1 ? "s" : ""))).m_130940_(ChatFormatting.YELLOW) : (secondsRemaining > 10 ? Component.m_237113_((String)("Battle time remaining: " + secondsRemaining + " seconds")).m_130940_(ChatFormatting.YELLOW) : Component.m_237113_((String)("Battle time remaining: " + secondsRemaining + "!")).m_130940_(ChatFormatting.GOLD));
            for (UUID playerId : battle.getAllPlayers()) {
                ServerPlayer player = this.getPlayerByUUID(playerId);
                if (player == null) continue;
                player.m_213846_((Component)message);
            }
            this.pvpManager.lastNotificationTime.put(battleId, secondsRemaining);
        }
    }

    public void handlePlayerDisconnect(ServerPlayer player) {
        this.pvpManager.pendingRequests.values().removeIf(request -> request.getChallengerId().equals(player.m_20148_()) || request.getTargetPlayers().contains(player.m_20148_()));
        ActiveBattle battle = this.pvpManager.getActiveBattle(player);
        if (battle != null) {
            this.cancelBattleDueToDisconnect(battle, player);
            return;
        }
        SpectatorData specData = this.pvpManager.spectatorData.get(player.m_20148_());
        if (specData != null) {
            player.m_143403_(specData.originalGameMode());
            this.pvpManager.spectatorData.remove(player.m_20148_());
            LOGGER.info("Player {} disconnected as a spectator, resetting gamemode to {}.", (Object)player.m_7755_().getString(), (Object)specData.originalGameMode());
        }
    }

    public int handleAccept(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        BattleRequest request = this.pvpManager.pendingRequests.remove(player.m_20148_());
        if (request == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No active battle requests!"));
            return 0;
        }
        ArrayList<UUID> allTargets = new ArrayList<UUID>(request.getTargetPlayers());
        boolean allAccepted = allTargets.stream().noneMatch(this.pvpManager.pendingRequests::containsKey);
        if (allAccepted) {
            this.startChallengedBattle(request);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Waiting for other players to accept...").m_130940_(ChatFormatting.YELLOW));
        }
        return 1;
    }

    public int handleDecline(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        BattleRequest request = this.pvpManager.pendingRequests.remove(player.m_20148_());
        if (request == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No active battle requests!"));
            return 0;
        }
        for (UUID targetId : request.getTargetPlayers()) {
            this.pvpManager.pendingRequests.remove(targetId);
        }
        ServerPlayer challenger = this.getPlayerByUUID(request.getChallengerId());
        if (challenger != null) {
            challenger.m_213846_((Component)Component.m_237113_((String)(player.m_7755_().getString() + " declined the battle! Challenge cancelled.")).m_130940_(ChatFormatting.RED));
        }
        return 1;
    }

    public int handleSpectateStart(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer spectator = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"player");
        ActiveBattle battle = this.pvpManager.getActiveBattle(target);
        if (battle == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Player is not in a battle!"));
            return 0;
        }
        PvPMap map = this.pvpManager.arenaMapsByName.get(battle.getMapName());
        if (map == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Battle map not found!"));
            return 0;
        }
        GlobalPos originalPos = GlobalPos.m_122643_((ResourceKey)spectator.m_9236_().m_46472_(), (BlockPos)spectator.m_20183_());
        this.pvpManager.spectatorData.put(spectator.m_20148_(), new SpectatorData(originalPos, spectator.f_8941_.m_9290_()));
        if (!map.getSpawnPoints().isEmpty()) {
            BlockPos centerPos = this.calculateMapCenter(map);
            GlobalPos spectatorPos = GlobalPos.m_122643_(map.getDimension(), (BlockPos)centerPos.m_7918_(0, 10, 0));
            spectator.m_143403_(GameType.SPECTATOR);
            this.teleportTo(spectator, spectatorPos);
            this.pvpManager.activeSpectators.computeIfAbsent(battle.getBattleId(), k -> new ArrayList()).add(spectator.m_20148_());
            spectator.m_213846_((Component)Component.m_237113_((String)("Now spectating battle on " + battle.getMapName())).m_130940_(ChatFormatting.GREEN).m_130946_("\n").m_7220_((Component)this.createStopButton()));
        }
        return 1;
    }

    public int handleSpectateStop(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer spectator = ((CommandSourceStack)context.getSource()).m_81375_();
        this.stopSpectating(spectator, true);
        return 1;
    }

    public int handleDuel(CommandContext<CommandSourceStack> context, boolean hasAmount, boolean hasMap) throws CommandSyntaxException {
        String mapName;
        int amount;
        ServerPlayer challenger = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"targetPlayer");
        int n = amount = hasAmount ? IntegerArgumentType.getInteger(context, (String)"wager") : 0;
        if (hasMap) {
            mapName = StringArgumentType.getString(context, (String)"mapName");
            if (!this.pvpManager.arenaMapsByName.containsKey(mapName)) {
                challenger.m_213846_((Component)Component.m_237113_((String)("Arena map '" + mapName + "' does not exist!")).m_130940_(ChatFormatting.RED));
                return 0;
            }
        } else if (this.pvpManager.defaultMapName != null && this.pvpManager.arenaMapsByName.containsKey(this.pvpManager.defaultMapName)) {
            mapName = this.pvpManager.defaultMapName;
        } else if (!this.pvpManager.arenaMapsByName.isEmpty()) {
            mapName = this.pvpManager.arenaMapsByName.keySet().iterator().next();
        } else {
            challenger.m_213846_((Component)Component.m_237113_((String)"No arena map available! Contact an admin.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (challenger.m_20148_().equals(target.m_20148_())) {
            challenger.m_213846_((Component)Component.m_237113_((String)"You can't challenge yourself!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (this.pvpManager.isPlayerBusy(challenger.m_20148_()) || this.pvpManager.isPlayerBusy(target.m_20148_())) {
            challenger.m_213846_((Component)Component.m_237113_((String)"One of the players is already in a battle or has a pending request!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        BattleRequest request = new BattleRequest(challenger.m_20148_(), List.of(target.m_20148_()), amount, mapName);
        this.pvpManager.pendingRequests.put(target.m_20148_(), request);
        challenger.m_213846_((Component)Component.m_237113_((String)("Duel request sent to " + target.m_7755_().getString() + (String)(amount > 0 ? " for " + amount + " coins" : ""))).m_130940_(ChatFormatting.GREEN));
        MutableComponent targetMessage = Component.m_237113_((String)(challenger.m_7755_().getString() + " has challenged you to a duel" + (String)(amount > 0 ? " for " + amount + " coins" : "") + "! "));
        targetMessage.m_7220_((Component)Component.m_237113_((String)"[ACCEPT]").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pvp accept")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to accept the duel")))));
        targetMessage.m_130946_(" ");
        targetMessage.m_7220_((Component)Component.m_237113_((String)"[DECLINE]").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pvp decline")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to decline the duel")))));
        target.m_213846_((Component)targetMessage);
        return 1;
    }

    public int createTeamBattle(CommandContext<CommandSourceStack> context, String mapName) throws CommandSyntaxException {
        ServerPlayer organizer = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID organizerId = organizer.m_20148_();
        if (this.pvpManager.isPlayerBusy(organizerId)) {
            organizer.m_213846_((Component)Component.m_237113_((String)"You are currently busy and cannot start a battle.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        Long lastBattleTime = this.pvpManager.teamBattleCooldown.get(organizerId);
        long cooldownMillis = (long)((Integer)TaxConfig.TEAM_BATTLE_COOLDOWN_SECONDS.get()).intValue() * 1000L;
        if (lastBattleTime != null && System.currentTimeMillis() - lastBattleTime < cooldownMillis) {
            long remaining = lastBattleTime + cooldownMillis - System.currentTimeMillis();
            organizer.m_213846_((Component)Component.m_237113_((String)("You must wait " + remaining / 1000L + " seconds before starting another team battle.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        PvPMap map = this.pvpManager.arenaMapsByName.get(mapName);
        if (map == null) {
            organizer.m_213846_((Component)Component.m_237113_((String)("The map '" + mapName + "' does not exist.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (map.getMaxPlayers() < 2) {
            organizer.m_213846_((Component)Component.m_237113_((String)"This map is not large enough for a team battle.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!this.isMapAvailable(mapName)) {
            organizer.m_213846_((Component)Component.m_237113_((String)("The map '" + mapName + "' is currently in use.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        String battleId = "team_battle_" + UUID.randomUUID().toString().substring(0, 8);
        int maxTeamSize = map.getMaxPlayers() / 2;
        TeamBattle teamBattle = new TeamBattle(battleId, mapName, organizer.m_20148_(), maxTeamSize);
        this.pvpManager.pendingTeamBattles.put(battleId, teamBattle);
        this.pvpManager.teamBattleCooldown.put(organizerId, System.currentTimeMillis());
        teamBattle.addPlayerToTeam(organizerId, 1);
        MutableComponent message = Component.m_237113_((String)(organizer.m_7755_().getString() + " has started a team battle on map " + mapName + "!")).m_130940_(ChatFormatting.GOLD);
        message.m_7220_((Component)Component.m_237113_((String)"\n[Join Team 1]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/teampvp join " + battleId + " 1"))));
        message.m_7220_((Component)Component.m_237113_((String)" - "));
        message.m_7220_((Component)Component.m_237113_((String)"[Join Team 2]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/teampvp join " + battleId + " 2"))));
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)message, false);
        MutableComponent startMessage = Component.m_237113_((String)"You have created a team battle! You can start it early with: ").m_130940_(ChatFormatting.GREEN);
        startMessage.m_7220_((Component)Component.m_237113_((String)"[START EARLY]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/teampvp start " + battleId))));
        organizer.m_213846_((Component)startMessage);
        this.displayTeamRosters(teamBattle);
        return 1;
    }

    public int joinTeamBattle(CommandContext<CommandSourceStack> context, String battleId, int teamNumber) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        TeamBattle teamBattle = this.pvpManager.pendingTeamBattles.get(battleId);
        if (teamBattle == null || teamBattle.getState() == TeamBattleState.IN_PROGRESS) {
            player.m_213846_((Component)Component.m_237113_((String)"You can no longer join this battle.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (this.pvpManager.isPlayerBusy(player.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)"You are already in a battle or have a pending request!").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (teamBattle.addPlayerToTeam(player.m_20148_(), teamNumber)) {
            this.displayTeamRosters(teamBattle);
            if (teamBattle.canStart() && teamBattle.getState() == TeamBattleState.RECRUITING) {
                teamBattle.startCountdown();
                int countdownSeconds = (Integer)TaxConfig.TEAM_BATTLE_START_COUNTDOWN_SECONDS.get();
                this.notifyTeamBattlePlayers(teamBattle, (Component)Component.m_237113_((String)("The battle will begin in " + countdownSeconds + " seconds!")).m_130940_(ChatFormatting.YELLOW));
            }
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Failed to join team. It might be full, or you're already on a team.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    public int switchTeam(CommandContext<CommandSourceStack> context, String battleId, int newTeamNumber) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID playerId = player.m_20148_();
        TeamBattle teamBattle = this.pvpManager.pendingTeamBattles.get(battleId);
        if (teamBattle == null || teamBattle.getState() == TeamBattleState.IN_PROGRESS) {
            player.m_213846_((Component)Component.m_237113_((String)"You cannot switch teams at this time.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        int currentTeam = 0;
        if (teamBattle.getTeam1().contains(playerId)) {
            currentTeam = 1;
        } else if (teamBattle.getTeam2().contains(playerId)) {
            currentTeam = 2;
        }
        if (currentTeam == newTeamNumber) {
            player.m_213846_((Component)Component.m_237113_((String)"You are already on that team.").m_130940_(ChatFormatting.YELLOW));
            return 0;
        }
        if (newTeamNumber == 1 && teamBattle.getTeam1().size() >= teamBattle.getMaxTeamSize() || newTeamNumber == 2 && teamBattle.getTeam2().size() >= teamBattle.getMaxTeamSize()) {
            player.m_213846_((Component)Component.m_237113_((String)"The target team is full.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (currentTeam != 0) {
            teamBattle.removePlayer(playerId);
        }
        if (!teamBattle.addPlayerToTeam(playerId, newTeamNumber)) {
            player.m_213846_((Component)Component.m_237113_((String)"Failed to switch teams.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        this.displayTeamRosters(teamBattle);
        return 1;
    }

    public int startPendingTeamBattle(CommandContext<CommandSourceStack> context, String battleId) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        TeamBattle teamBattle = this.pvpManager.pendingTeamBattles.get(battleId);
        if (teamBattle == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Team battle not found.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!teamBattle.getOrganizer().equals(player.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)"Only the organizer can start the battle.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (teamBattle.getState() == TeamBattleState.IN_PROGRESS) {
            player.m_213846_((Component)Component.m_237113_((String)"This battle is already in progress.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!teamBattle.canStart()) {
            player.m_213846_((Component)Component.m_237113_((String)"Both teams must have at least one player to start.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        teamBattle.setState(TeamBattleState.IN_PROGRESS);
        this.startTeamBattle(teamBattle);
        return 1;
    }

    private void startChallengedBattle(BattleRequest request) {
        ArrayList<UUID> allPlayers = new ArrayList<UUID>();
        allPlayers.add(request.getChallengerId());
        allPlayers.addAll(request.getTargetPlayers());
        PvPMap map = this.pvpManager.arenaMapsByName.get(request.getMapName());
        if (map == null || map.getSpawnPoints().size() < allPlayers.size()) {
            allPlayers.forEach(id -> {
                ServerPlayer p = this.getPlayerByUUID((UUID)id);
                if (p != null) {
                    p.m_213846_((Component)Component.m_237113_((String)("Not enough spawn points available on map '" + request.getMapName() + "'! Battle cancelled.")).m_130940_(ChatFormatting.RED));
                }
            });
            return;
        }
        ArrayList<List<UUID>> teams = new ArrayList<List<UUID>>();
        if (allPlayers.size() == 2) {
            teams.add(Arrays.asList((UUID)allPlayers.get(0)));
            teams.add(Arrays.asList((UUID)allPlayers.get(1)));
        } else {
            for (UUID uUID : allPlayers) {
                teams.add(Arrays.asList(uUID));
            }
        }
        HashMap<UUID, GlobalPos> originalPositions = new HashMap<UUID, GlobalPos>();
        for (UUID playerId : allPlayers) {
            ServerPlayer player = this.getPlayerByUUID(playerId);
            if (player == null) continue;
            originalPositions.put(playerId, GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_()));
        }
        String string = "challenge_" + System.currentTimeMillis();
        ActiveBattle battle = new ActiveBattle(string, teams, map.getSpawnPoints(), request.getMapName());
        this.pvpManager.activeBattles.put(string, battle);
        for (Map.Entry entry : originalPositions.entrySet()) {
            battle.getOriginalPositions().put((UUID)entry.getKey(), (GlobalPos)entry.getValue());
        }
        this.startBattle(battle);
    }

    private void checkForBattleEnd(ActiveBattle battle) {
        HashMap<Integer, Integer> teamPlayerCounts = new HashMap<Integer, Integer>();
        for (int teamIndex = 0; teamIndex < battle.getTeams().size(); ++teamIndex) {
            int aliveCount = 0;
            for (UUID playerId : battle.getTeams().get(teamIndex)) {
                ServerPlayer player = this.getPlayerByUUID(playerId);
                if (player == null || player.f_8941_.m_9290_() == GameType.SPECTATOR) continue;
                ++aliveCount;
            }
            teamPlayerCounts.put(teamIndex, aliveCount);
        }
        boolean anyTeamEliminated = teamPlayerCounts.values().stream().anyMatch(count -> count == 0);
        if (anyTeamEliminated) {
            int winningTeam = teamPlayerCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(Map.Entry::getKey).findFirst().orElse(-1);
            if (winningTeam >= 0) {
                this.endBattleWithWinner(battle, winningTeam, "Victory - enemy team eliminated!");
            } else {
                this.endBattleAsDraw(battle, "All combatants were eliminated!");
            }
        }
    }

    private void endBattleWithWinner(ActiveBattle battle, int winningTeam, String reason) {
        List<UUID> winners = battle.getTeams().get(winningTeam);
        boolean isDuel = battle.getTeams().size() == 2 && battle.getTeams().get(0).size() == 1 && battle.getTeams().get(1).size() == 1;
        for (int i = 0; i < battle.getTeams().size(); ++i) {
            boolean isWinningTeam = i == winningTeam;
            for (UUID playerId : battle.getTeams().get(i)) {
                this.updatePlayerStats(playerId, isWinningTeam, false, !isDuel);
                ServerPlayer player = this.getPlayerByUUID(playerId);
                if (player == null) continue;
                MutableComponent message = isWinningTeam ? Component.m_237113_((String)"\u2727 Victory! \u2727").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}) : Component.m_237113_((String)"\u2727 Defeat! \u2727").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                player.m_213846_((Component)message);
            }
        }
        this.processBattleRewards(battle, winners);
        this.scheduleBattleEnd(battle.getBattleId());
    }

    private void endBattleAsDraw(ActiveBattle battle, String reason) {
        boolean isDuel = battle.getTeams().size() == 2 && battle.getTeams().get(0).size() == 1 && battle.getTeams().get(1).size() == 1;
        for (List<UUID> team : battle.getTeams()) {
            for (UUID playerId : team) {
                this.updatePlayerStats(playerId, false, false, !isDuel);
            }
        }
        String resultTitle = isDuel ? "\u2727 Duel Result \u2727" : "\u2727 Battle Result \u2727";
        MutableComponent announcement = Component.m_237113_((String)(resultTitle + "\n")).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)(reason + " - DRAW!")).m_130940_(ChatFormatting.YELLOW));
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_240416_((Component)announcement, false);
        this.scheduleBattleEnd(battle.getBattleId());
    }

    private void scheduleBattleEnd(String battleId) {
        ActiveBattle battle = this.pvpManager.activeBattles.get(battleId);
        if (battle == null) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        int countdownSeconds = (Integer)TaxConfig.BATTLE_END_COUNTDOWN_SECONDS.get();
        server.m_6846_().m_240416_((Component)Component.m_237113_((String)("Returning to original positions in " + countdownSeconds + " seconds...")).m_130940_(ChatFormatting.YELLOW), false);
        PvPManager.BATTLE_END_SCHEDULER.schedule(() -> server.execute(() -> this.endBattle(battleId)), (long)countdownSeconds, TimeUnit.SECONDS);
    }

    private void endBattle(String battleId) {
        ActiveBattle battle = this.pvpManager.activeBattles.remove(battleId);
        if (battle == null) {
            return;
        }
        this.unlockMap(battle.getMapName());
        this.pvpManager.battleTimers.remove(battleId);
        this.pvpManager.lastNotificationTime.remove(battleId);
        this.pvpManager.battleDamage.remove(battleId);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (UUID playerId : battle.getAllPlayers()) {
            server.execute(() -> {
                ServerPlayer player = server.m_6846_().m_11259_(playerId);
                if (player != null) {
                    GlobalPos originalPos = battle.getOriginalPositions().get(playerId);
                    GameType originalGameMode = this.pvpManager.playerOriginalGameModes.getOrDefault(playerId, GameType.SURVIVAL);
                    this.restorePlayer(player, originalPos, originalGameMode);
                    this.pvpManager.playerOriginalGameModes.remove(playerId);
                }
            });
        }
    }

    private void startBattle(ActiveBattle battle) {
        this.pvpManager.activeBattles.put(battle.getBattleId(), battle);
        this.lockMap(battle.getMapName());
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        int numTeams = battle.getTeams().size();
        for (int teamIndex = 0; teamIndex < numTeams; ++teamIndex) {
            List<UUID> team = battle.getTeams().get(teamIndex);
            for (int playerIndex = 0; playerIndex < team.size(); ++playerIndex) {
                UUID playerId = team.get(playerIndex);
                ServerPlayer player = server.m_6846_().m_11259_(playerId);
                if (player == null) continue;
                int spawnIndex = teamIndex + playerIndex * numTeams;
                if (spawnIndex >= battle.getSpawnPositions().size()) {
                    LOGGER.error("Not enough spawn points for battle {}. This should have been checked earlier.", (Object)battle.getBattleId());
                    return;
                }
                GlobalPos spawnPos = battle.getSpawnPositions().get(spawnIndex);
                if (spawnPos == null) {
                    LOGGER.error("Spawn position at index {} is null for battle {}. Skipping player {}.", (Object)spawnIndex, (Object)battle.getBattleId(), (Object)player.m_7755_().getString());
                    continue;
                }
                battle.getOriginalPositions().put(playerId, GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_()));
                this.pvpManager.playerOriginalGameModes.put(playerId, player.f_8941_.m_9290_());
                this.saveInventory(player);
                this.teleportTo(player, spawnPos);
                this.applyFreezeEffects(player);
            }
        }
        int battleDurationTicks = (Integer)TaxConfig.BATTLE_DURATION_SECONDS.get() * 20;
        this.pvpManager.battleTimers.put(battle.getBattleId(), battleDurationTicks);
        LOGGER.info("Battle {} started with {} seconds duration ({} ticks)", (Object)battle.getBattleId(), TaxConfig.BATTLE_DURATION_SECONDS.get(), (Object)battleDurationTicks);
        this.startBattleCountdown(battle);
    }

    private void startBattleCountdown(ActiveBattle battle) {
        new Thread(() -> {
            try {
                int i = 5;
                while (i > 0) {
                    int finalI = i--;
                    ServerLifecycleHooks.getCurrentServer().execute(() -> {
                        MutableComponent countdown = Component.m_237113_((String)"Battle starts in: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(finalI)).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                        for (UUID playerId : battle.getAllPlayers()) {
                            ServerPlayer player = this.getPlayerByUUID(playerId);
                            if (player == null) continue;
                            player.m_213846_((Component)countdown);
                        }
                    });
                    Thread.sleep(1000L);
                }
                ServerLifecycleHooks.getCurrentServer().execute(() -> {
                    MutableComponent fightMessage = Component.m_237113_((String)"FIGHT!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                    for (UUID playerId : battle.getAllPlayers()) {
                        ServerPlayer player = this.getPlayerByUUID(playerId);
                        if (player == null) continue;
                        player.m_213846_((Component)fightMessage);
                        this.removeFreezeEffects(player);
                    }
                });
            }
            catch (InterruptedException e) {
                LOGGER.error("Countdown error", (Throwable)e);
            }
        }).start();
    }

    private void cancelBattleDueToDisconnect(ActiveBattle battle, ServerPlayer disconnectedPlayer) {
        String battleId = battle.getBattleId();
        for (UUID playerId : battle.getAllPlayers()) {
            ServerPlayer player;
            if (playerId.equals(disconnectedPlayer.m_20148_()) || (player = this.getPlayerByUUID(playerId)) == null) continue;
            player.m_213846_((Component)Component.m_237113_((String)(disconnectedPlayer.m_7755_().getString() + " disconnected. Battle cancelled - no penalties.")).m_130940_(ChatFormatting.YELLOW));
        }
        this.endBattle(battleId);
    }

    private void updatePlayerStats(UUID playerId, boolean won, boolean died, boolean isTeamBattle) {
        PlayerPvPStats stats = this.pvpManager.playerStats.computeIfAbsent(playerId, k -> new PlayerPvPStats());
        if (won) {
            stats.addWin(isTeamBattle);
        } else {
            stats.addLoss(isTeamBattle);
        }
        if (died) {
            stats.addDeath();
        }
    }

    private void displayTeamRosters(TeamBattle teamBattle) {
        MutableComponent roster = Component.m_237113_((String)"--- Team Battle Rosters ---\n").m_130940_(ChatFormatting.GOLD);
        roster.m_7220_((Component)Component.m_237113_((String)"Team 1: ").m_130940_(ChatFormatting.AQUA));
        this.appendTeamMembers(roster, teamBattle.getTeam1());
        roster.m_7220_((Component)Component.m_237113_((String)"\nTeam 2: ").m_130940_(ChatFormatting.RED));
        this.appendTeamMembers(roster, teamBattle.getTeam2());
        this.notifyTeamBattlePlayers(teamBattle, (Component)roster);
    }

    private void appendTeamMembers(MutableComponent component, List<UUID> team) {
        if (team.isEmpty()) {
            component.m_7220_((Component)Component.m_237113_((String)"(empty)").m_130940_(ChatFormatting.GRAY));
            return;
        }
        for (int i = 0; i < team.size(); ++i) {
            UUID memberId = team.get(i);
            ServerPlayer member = this.getPlayerByUUID(memberId);
            String name = member != null ? member.m_7755_().getString() : "Offline Player";
            component.m_7220_((Component)Component.m_237113_((String)name).m_130940_(ChatFormatting.WHITE));
            if (i >= team.size() - 1) continue;
            component.m_130946_(", ");
        }
    }

    public void notifyTeamBattlePlayers(TeamBattle teamBattle, Component message) {
        ArrayList<UUID> allPlayers = new ArrayList<UUID>();
        allPlayers.addAll(teamBattle.getTeam1());
        allPlayers.addAll(teamBattle.getTeam2());
        for (UUID playerId : allPlayers) {
            ServerPlayer player = this.getPlayerByUUID(playerId);
            if (player == null) continue;
            player.m_213846_(message);
        }
    }

    private ServerPlayer getPlayerByUUID(UUID uuid) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server == null ? null : server.m_6846_().m_11259_(uuid);
    }

    private BlockPos calculateMapCenter(PvPMap map) {
        if (map.getSpawnPoints().isEmpty()) {
            return BlockPos.f_121853_;
        }
        int totalX = 0;
        int totalY = 0;
        int totalZ = 0;
        int count = 0;
        for (GlobalPos pos : map.getSpawnPoints()) {
            if (pos == null) continue;
            totalX += pos.m_122646_().m_123341_();
            totalY += pos.m_122646_().m_123342_();
            totalZ += pos.m_122646_().m_123343_();
            ++count;
        }
        return count == 0 ? BlockPos.f_121853_ : new BlockPos(totalX / count, totalY / count, totalZ / count);
    }

    private void teleportTo(ServerPlayer player, GlobalPos pos) {
        if (player == null || pos == null) {
            LOGGER.error("Cannot teleport: player or position is null. Player: {}, Pos: {}", (Object)player, (Object)pos);
            return;
        }
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        try {
            ServerLevel level = server.m_129880_(pos.m_122640_());
            if (level == null) {
                return;
            }
            BlockPos blockPos = pos.m_122646_();
            player.m_8999_(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        }
        catch (Exception e) {
            LOGGER.error("Error teleporting player {} to position {}: {}", (Object)player.m_7755_().getString(), (Object)pos, (Object)e.getMessage());
        }
    }

    private MutableComponent createStopButton() {
        return Component.m_237113_((String)"[Stop Spectating]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pvp spectate stop")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to stop spectating"))));
    }

    private void stopSpectating(ServerPlayer spectator, boolean sendMessage) {
        SpectatorData data = this.pvpManager.spectatorData.remove(spectator.m_20148_());
        if (data != null) {
            spectator.m_143403_(data.originalGameMode());
            this.teleportTo(spectator, data.originalPos());
            this.pvpManager.activeSpectators.values().forEach(list -> list.remove(spectator.m_20148_()));
            if (sendMessage) {
                spectator.m_213846_((Component)Component.m_237113_((String)"Stopped spectating").m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    private void restorePlayer(ServerPlayer player, GlobalPos originalPos, GameType originalGameMode) {
        if (player == null) {
            return;
        }
        if (originalPos != null) {
            this.teleportTo(player, originalPos);
        }
        this.restoreInventory(player);
        player.m_21153_(player.m_21233_());
        player.m_36324_().m_38705_(20);
        player.m_20095_();
        player.m_143403_(originalGameMode);
        this.removeFreezeEffects(player);
        player.m_21195_(MobEffects.f_19619_);
    }

    private void saveInventory(ServerPlayer player) {
        ItemStack[] mainInventory = new ItemStack[player.m_150109_().m_6643_()];
        for (int i = 0; i < mainInventory.length; ++i) {
            mainInventory[i] = player.m_150109_().m_8020_(i).m_41777_();
        }
        this.pvpManager.playerInventories.put(player.m_20148_(), mainInventory);
        ItemStack[] armorInventory = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            armorInventory[i] = ((ItemStack)player.m_150109_().f_35975_.get(i)).m_41777_();
        }
        this.pvpManager.playerArmor.put(player.m_20148_(), armorInventory);
    }

    private void restoreInventory(ServerPlayer player) {
        ItemStack[] armorInventory;
        UUID uuid = player.m_20148_();
        ItemStack[] mainInventory = this.pvpManager.playerInventories.remove(uuid);
        if (mainInventory != null) {
            for (int i = 0; i < mainInventory.length; ++i) {
                player.m_150109_().m_6836_(i, mainInventory[i]);
            }
        }
        if ((armorInventory = this.pvpManager.playerArmor.remove(uuid)) != null) {
            for (int i = 0; i < 4; ++i) {
                player.m_150109_().f_35975_.set(i, (Object)armorInventory[i]);
            }
        }
        player.f_36096_.m_38946_();
    }

    private void applyFreezeEffects(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 6000, 255, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 6000, 250, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 6000, 0, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 6000, 0, false, false, false));
    }

    private void removeFreezeEffects(ServerPlayer player) {
        player.m_21195_(MobEffects.f_19597_);
        player.m_21195_(MobEffects.f_19603_);
        player.m_21195_(MobEffects.f_19610_);
        player.m_21195_(MobEffects.f_19604_);
    }

    private void lockMap(String mapName) {
        this.pvpManager.lockedMaps.add(mapName);
        LOGGER.info("Locked map: " + mapName);
    }

    private void unlockMap(String mapName) {
        this.pvpManager.lockedMaps.remove(mapName);
        LOGGER.info("Unlocked map: " + mapName);
    }

    private boolean isMapAvailable(String mapName) {
        return !this.pvpManager.lockedMaps.contains(mapName);
    }

    private void updatePlayerKill(UUID killerId) {
        PlayerPvPStats stats = this.pvpManager.playerStats.computeIfAbsent(killerId, k -> new PlayerPvPStats());
        stats.addKill();
    }

    private void processBattleRewards(ActiveBattle battle, List<UUID> winners) {
    }
}

