/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.abandon.ColonyAbandonmentManager;
import net.machiavelli.minecolonytax.abandon.ColonyClaimingRaidManager;
import net.machiavelli.minecolonytax.commands.AdminTaxGenCommand;
import net.machiavelli.minecolonytax.commands.CheckTaxRevenueCommand;
import net.machiavelli.minecolonytax.commands.ClaimTaxCommand;
import net.machiavelli.minecolonytax.commands.ColonyActivityCommand;
import net.machiavelli.minecolonytax.commands.EntityRaidCommands;
import net.machiavelli.minecolonytax.commands.GeneralPermissionsCommands;
import net.machiavelli.minecolonytax.commands.TaxDebtCommand;
import net.machiavelli.minecolonytax.commands.TaxGUICommand;
import net.machiavelli.minecolonytax.commands.WarHistoryCommand;
import net.machiavelli.minecolonytax.commands.WarStatsCommand;
import net.machiavelli.minecolonytax.commands.WntCommands;
import net.machiavelli.minecolonytax.pvp.PvPArenaCommand;
import net.machiavelli.minecolonytax.pvp.PvPBattleManager;
import net.machiavelli.minecolonytax.pvp.PvPManager;
import net.machiavelli.minecolonytax.pvp.PvPMapManager;
import net.machiavelli.minecolonytax.pvp.model.ActiveBattle;
import net.machiavelli.minecolonytax.pvp.model.BattleRequest;
import net.machiavelli.minecolonytax.pvp.model.TeamBattle;
import net.machiavelli.minecolonytax.pvp.model.TeamBattleState;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PvPEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final PvPManager pvpManager = PvPManager.INSTANCE;
    private static final PvPMapManager mapManager = new PvPMapManager();
    private static final PvPBattleManager battleManager = new PvPBattleManager();
    private static final Map<UUID, Long> lastCommandBlockMessage = new HashMap<UUID, Long>();
    private static final long COMMAND_BLOCK_MESSAGE_COOLDOWN = 5000L;
    private static final Map<UUID, Set<Integer>> notifiedAbandonedColonies = new ConcurrentHashMap<UUID, Set<Integer>>();
    private static final long COLONY_NOTIFICATION_COOLDOWN = 60000L;
    private static final Map<String, Long> lastColonyNotifications = new ConcurrentHashMap<String, Long>();

    @SubscribeEvent
    public static void onServerStart(ServerAboutToStartEvent event) {
        mapManager.loadArenaData();
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        new PvPArenaCommand().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), battleManager, mapManager);
        ColonyActivityCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        WntCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        GeneralPermissionsCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        EntityRaidCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ClaimTaxCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        CheckTaxRevenueCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TaxDebtCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AdminTaxGenCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        WarStatsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        WarHistoryCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        if (FMLEnvironment.dist.isClient()) {
            TaxGUICommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PvPEventHandler.pvpManager.pendingRequests.entrySet().removeIf(entry -> ((BattleRequest)entry.getValue()).isExpired());
            ArrayList battlesToStart = new ArrayList();
            PvPEventHandler.pvpManager.pendingTeamBattles.values().forEach(battle -> {
                if (battle.getState() == TeamBattleState.COUNTDOWN) {
                    int lastNotified;
                    long elapsedMillis = System.currentTimeMillis() - battle.countdownStartTime;
                    int countdownSeconds = (Integer)TaxConfig.TEAM_BATTLE_START_COUNTDOWN_SECONDS.get();
                    int secondsRemaining = countdownSeconds - (int)(elapsedMillis / 1000L);
                    if (secondsRemaining != (lastNotified = PvPEventHandler.pvpManager.teamBattleCountdownNotifiers.getOrDefault(battle.getBattleId(), -1).intValue()) && secondsRemaining >= 0) {
                        boolean shouldNotify;
                        boolean bl = shouldNotify = secondsRemaining <= 5 || secondsRemaining % 10 == 0;
                        if (shouldNotify) {
                            MutableComponent countdownMessage = Component.m_237113_((String)"Battle starts in: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(secondsRemaining)).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                            if (secondsRemaining == 0) {
                                countdownMessage = Component.m_237113_((String)"Battle starting now!").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
                            }
                            battleManager.notifyTeamBattlePlayers((TeamBattle)battle, (Component)countdownMessage);
                            LOGGER.info("Team battle {} starting in {} seconds...", (Object)battle.getBattleId(), (Object)secondsRemaining);
                        }
                        PvPEventHandler.pvpManager.teamBattleCountdownNotifiers.put(battle.getBattleId(), secondsRemaining);
                    }
                    if (elapsedMillis >= (long)countdownSeconds * 1000L) {
                        battlesToStart.add(battle);
                    }
                }
            });
            battlesToStart.forEach(battle -> {
                battleManager.startTeamBattle((TeamBattle)battle);
                PvPEventHandler.pvpManager.teamBattleCountdownNotifiers.remove(battle.getBattleId());
            });
            Iterator<Map.Entry<String, Integer>> iterator = PvPEventHandler.pvpManager.battleTimers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry2 = iterator.next();
                String battleId = entry2.getKey();
                int remaining = entry2.getValue() - 1;
                if (remaining % 60 == 0) {
                    LOGGER.info("Battle {} timer: {} seconds remaining", (Object)battleId, (Object)(remaining / 20));
                }
                if (remaining <= 0) {
                    LOGGER.info("Battle {} timer expired, ending battle", (Object)battleId);
                    battleManager.handleBattleTimerExpiry(battleId);
                    iterator.remove();
                    continue;
                }
                PvPEventHandler.pvpManager.battleTimers.put(battleId, remaining);
                battleManager.sendBattleTimerNotifications(battleId, remaining);
            }
        }
    }

    @SubscribeEvent
    public static void onCommandExecution(CommandEvent event) {
        ParseResults parseResults = event.getParseResults();
        CommandSourceStack source = (CommandSourceStack)parseResults.getContext().getSource();
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!((Boolean)TaxConfig.PVP_COMMANDS_IN_BATTLE_ENABLED.get()).booleanValue() && pvpManager.getActiveBattle(player) != null) {
            if (source.m_6761_(2)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            Long lastMessageTime = lastCommandBlockMessage.get(player.m_20148_());
            if (lastMessageTime == null || currentTime - lastMessageTime >= 5000L) {
                event.setCanceled(true);
                player.m_213846_((Component)Component.m_237113_((String)"You cannot execute commands while in a PvP battle!").m_130940_(ChatFormatting.RED));
                lastCommandBlockMessage.put(player.m_20148_(), currentTime);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            battleManager.handlePlayerDisconnect(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ColonyAbandonmentManager.sendPendingNotifications(player2);
            notifiedAbandonedColonies.remove(player2.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_19797_ % 20 == 0) {
                PvPEventHandler.checkForAbandonedColonyEntry(player2);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Entity entity;
        String battleId;
        TeamBattle teamBattle;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ActiveBattle battle = pvpManager.getActiveBattle(player);
        if (battle == null) {
            return;
        }
        if (((Boolean)TaxConfig.PVP_DISABLE_FRIENDLY_FIRE.get()).booleanValue() && (teamBattle = PvPEventHandler.pvpManager.pendingTeamBattles.get(battleId = battle.getBattleId())) != null && (entity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer attacker = (ServerPlayer)entity;
            if (teamBattle.arePlayersOnSameTeam(player.m_20148_(), attacker.m_20148_())) {
                event.setCanceled(true);
                long currentTime = System.currentTimeMillis();
                UUID attackerUUID = attacker.m_20148_();
                Long lastNotifyTime = PvPEventHandler.pvpManager.lastFriendlyFireNotifications.getOrDefault(attackerUUID, 0L);
                if (currentTime - lastNotifyTime > 2000L) {
                    attacker.m_213846_((Component)Component.m_237113_((String)"Cannot damage teammates when friendly fire is disabled!").m_130940_(ChatFormatting.RED));
                    PvPEventHandler.pvpManager.lastFriendlyFireNotifications.put(attackerUUID, currentTime);
                }
                return;
            }
        }
        if (event.getAmount() >= player.m_21223_()) {
            event.setCanceled(true);
            player.m_21153_(player.m_21233_());
            player.m_36324_().m_38705_(20);
            player.m_20095_();
            player.m_143403_(GameType.SPECTATOR);
            battleManager.handlePlayerDefeat(player, battle, event.getSource());
            return;
        }
        PvPEventHandler.pvpManager.battleDamage.computeIfAbsent(battle.getBattleId(), k -> new ConcurrentHashMap()).merge(player.m_20148_(), Float.valueOf(event.getAmount()), Float::sum);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        ActiveBattle battle;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (battle = pvpManager.getActiveBattle(player = (ServerPlayer)livingEntity)) != null) {
            battleManager.handlePlayerDefeat(player, battle, event.getSource());
        }
    }

    private static void checkForAbandonedColonyEntry(ServerPlayer player) {
        try {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            BlockPos playerPos = player.m_20183_();
            IColony nearbyColony = colonyManager.getColonyByPosFromWorld(player.m_9236_(), playerPos);
            if (nearbyColony == null) {
                return;
            }
            if (!ColonyAbandonmentManager.isColonyAbandoned(nearbyColony)) {
                return;
            }
            UUID playerId = player.m_20148_();
            int colonyId = nearbyColony.getID();
            Set playerNotifiedColonies = notifiedAbandonedColonies.computeIfAbsent(playerId, k -> new HashSet());
            String notificationKey = playerId + ":" + colonyId;
            long currentTime = System.currentTimeMillis();
            Long lastNotification = lastColonyNotifications.get(notificationKey);
            if (lastNotification != null && currentTime - lastNotification < 60000L) {
                return;
            }
            if (playerNotifiedColonies.contains(colonyId)) {
                return;
            }
            playerNotifiedColonies.add(colonyId);
            lastColonyNotifications.put(notificationKey, currentTime);
            ColonyClaimingRaidManager.ClaimingRequirementResult requirements = ColonyClaimingRaidManager.checkClaimingRequirements(player);
            MutableComponent titleMessage = Component.m_237113_((String)"\ud83c\udff0 ABANDONED COLONY DETECTED \ud83c\udff0").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
            MutableComponent colonyInfo = Component.m_237113_((String)"Colony: ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)nearbyColony.getName()).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)(" (ID: " + nearbyColony.getID() + ")")).m_130940_(ChatFormatting.GRAY));
            MutableComponent citizenInfo = Component.m_237113_((String)("Citizens: " + nearbyColony.getCitizenManager().getCurrentCitizenCount() + ", Guards: " + WarSystem.countGuards(nearbyColony))).m_130940_(ChatFormatting.WHITE);
            player.m_213846_((Component)titleMessage);
            player.m_213846_((Component)colonyInfo);
            player.m_213846_((Component)citizenInfo);
            if (requirements.canClaim) {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 You can claim this colony!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
                player.m_213846_((Component)Component.m_237113_((String)("Use '/wnt claimcolony " + nearbyColony.getName() + "' to start a claiming raid!")).m_130940_(ChatFormatting.GREEN));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)("\u2717 You cannot claim this colony: " + requirements.message)).m_130940_(ChatFormatting.RED));
                player.m_213846_((Component)Component.m_237113_((String)"Meet the requirements first to claim abandoned colonies.").m_130940_(ChatFormatting.YELLOW));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

