/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import net.machiavelli.minecolonytax.pvp.model.ActiveBattle;
import net.machiavelli.minecolonytax.pvp.model.BattleRequest;
import net.machiavelli.minecolonytax.pvp.model.PlayerPvPStats;
import net.machiavelli.minecolonytax.pvp.model.PvPMap;
import net.machiavelli.minecolonytax.pvp.model.SpectatorData;
import net.machiavelli.minecolonytax.pvp.model.TeamBattle;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;

public class PvPManager {
    public static final PvPManager INSTANCE = new PvPManager();
    public final Map<String, PvPMap> arenaMapsByName = new HashMap<String, PvPMap>();
    public String defaultMapName = null;
    public final Set<String> lockedMaps = new HashSet<String>();
    public final Map<String, ActiveBattle> activeBattles = new HashMap<String, ActiveBattle>();
    public final Map<String, TeamBattle> pendingTeamBattles = new HashMap<String, TeamBattle>();
    public final Map<UUID, BattleRequest> pendingRequests = new HashMap<UUID, BattleRequest>();
    public final Map<UUID, ItemStack[]> playerInventories = new HashMap<UUID, ItemStack[]>();
    public final Map<UUID, ItemStack[]> playerArmor = new HashMap<UUID, ItemStack[]>();
    public final Map<UUID, SpectatorData> spectatorData = new HashMap<UUID, SpectatorData>();
    public final Map<UUID, GameType> playerOriginalGameModes = new HashMap<UUID, GameType>();
    public final Map<String, List<UUID>> activeSpectators = new HashMap<String, List<UUID>>();
    public final Map<UUID, PlayerPvPStats> playerStats = new HashMap<UUID, PlayerPvPStats>();
    public final Map<String, Integer> battleTimers = new ConcurrentHashMap<String, Integer>();
    public final Map<String, Map<UUID, Float>> battleDamage = new ConcurrentHashMap<String, Map<UUID, Float>>();
    public final Map<String, Integer> lastNotificationTime = new ConcurrentHashMap<String, Integer>();
    public final Map<UUID, Long> challengeCooldown = new HashMap<UUID, Long>();
    public final Map<UUID, Long> teamBattleCooldown = new HashMap<UUID, Long>();
    public final Map<String, Integer> teamBattleCountdownNotifiers = new ConcurrentHashMap<String, Integer>();
    public final Map<UUID, Long> lastFriendlyFireNotifications = new HashMap<UUID, Long>();
    public static final ScheduledExecutorService BATTLE_END_SCHEDULER = Executors.newScheduledThreadPool(1);
    public static final File ARENA_DATA_FILE = new File("config/warntax/pvp_arena_data.json");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private PvPManager() {
    }

    @Nullable
    public ActiveBattle getActiveBattle(ServerPlayer player) {
        return this.activeBattles.values().stream().filter(battle -> battle.getAllPlayers().contains(player.m_20148_())).findFirst().orElse(null);
    }

    public boolean isPlayerBusy(UUID playerId) {
        for (ActiveBattle battle : this.activeBattles.values()) {
            if (!battle.getAllPlayers().contains(playerId)) continue;
            return true;
        }
        return this.pendingRequests.containsKey(playerId) || this.pendingRequests.values().stream().anyMatch(req -> req.getTargetPlayers().contains(playerId));
    }
}

