/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.machiavelli.minecolonytax.pvp.PvPManager;
import net.machiavelli.minecolonytax.pvp.model.PvPMap;
import net.machiavelli.minecolonytax.pvp.persistence.ArenaDataCollection;
import net.machiavelli.minecolonytax.pvp.persistence.ArenaMapData;
import net.machiavelli.minecolonytax.pvp.persistence.SpawnPointData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PvPMapManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PvPManager pvpManager = PvPManager.INSTANCE;

    public int createMap(CommandContext<CommandSourceStack> context, String mapName) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (this.pvpManager.arenaMapsByName.containsKey(mapName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Map '" + mapName + "' already exists!")));
            return 0;
        }
        PvPMap newMap = new PvPMap(mapName, (ResourceKey<Level>)player.m_9236_().m_46472_());
        this.pvpManager.arenaMapsByName.put(mapName, newMap);
        if (this.pvpManager.defaultMapName == null) {
            this.pvpManager.defaultMapName = mapName;
        }
        this.saveArenaData();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Created PvP map: " + mapName)).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    public int deleteMap(CommandContext<CommandSourceStack> context, String mapName) {
        if (!this.pvpManager.arenaMapsByName.containsKey(mapName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Map '" + mapName + "' does not exist!")));
            return 0;
        }
        boolean inUse = this.pvpManager.activeBattles.values().stream().anyMatch(battle -> battle.getMapName().equals(mapName));
        if (inUse) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Cannot delete map '" + mapName + "' - it's currently in use!")));
            return 0;
        }
        this.pvpManager.arenaMapsByName.remove(mapName);
        if (mapName.equals(this.pvpManager.defaultMapName)) {
            this.pvpManager.defaultMapName = this.pvpManager.arenaMapsByName.isEmpty() ? null : this.pvpManager.arenaMapsByName.keySet().iterator().next();
        }
        this.saveArenaData();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Deleted PvP map: " + mapName)).m_130940_(ChatFormatting.RED), false);
        return 1;
    }

    public int addSpawnPoint(CommandContext<CommandSourceStack> context, String mapName, int spawnIndex) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        PvPMap map = this.pvpManager.arenaMapsByName.get(mapName);
        if (map == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Map '" + mapName + "' does not exist!")));
            return 0;
        }
        GlobalPos playerPos = GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)player.m_20183_());
        if (!map.getDimension().equals((Object)player.m_9236_().m_46472_())) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You must be in the same dimension as the map!"));
            return 0;
        }
        while (map.getSpawnPoints().size() < spawnIndex) {
            map.getSpawnPoints().add(GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)BlockPos.f_121853_));
        }
        if (spawnIndex <= map.getSpawnPoints().size()) {
            map.getSpawnPoints().set(spawnIndex - 1, playerPos);
        } else {
            map.addSpawnPoint(playerPos);
        }
        this.saveArenaData();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Set spawn point " + spawnIndex + " for map '" + mapName + "'")).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    public int setDefaultMap(CommandContext<CommandSourceStack> context, String mapName) {
        if (!this.pvpManager.arenaMapsByName.containsKey(mapName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Map '" + mapName + "' does not exist!")));
            return 0;
        }
        this.pvpManager.defaultMapName = mapName;
        this.saveArenaData();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Set default map to: " + mapName)).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    public int listMaps(CommandContext<CommandSourceStack> context) {
        if (this.pvpManager.arenaMapsByName.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No PvP maps configured"), false);
            return 0;
        }
        MutableComponent message = Component.m_237113_((String)"PvP Maps:\n").m_130940_(ChatFormatting.GOLD);
        for (PvPMap map : this.pvpManager.arenaMapsByName.values()) {
            String defaultMarker = map.getName().equals(this.pvpManager.defaultMapName) ? " [DEFAULT]" : "";
            message.m_7220_((Component)Component.m_237113_((String)("- " + map.getName() + defaultMarker + " (Spawns: " + map.getSpawnPoints().size() + "/" + map.getMaxPlayers() + ")\n")).m_130940_(ChatFormatting.WHITE));
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> message, false);
        return 1;
    }

    public int showMapInfo(CommandContext<CommandSourceStack> context, String mapName) {
        PvPMap map = this.pvpManager.arenaMapsByName.get(mapName);
        if (map == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Map '" + mapName + "' does not exist!")));
            return 0;
        }
        MutableComponent info = Component.m_237113_((String)("Map: " + mapName + "\n")).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)("Dimension: " + map.getDimension().m_135782_() + "\n")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)("Spawn Points: " + map.getSpawnPoints().size() + "/" + map.getMaxPlayers() + "\n")).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)("Max Teams: " + map.getSpawnPoints().size() / 2 + "v" + map.getSpawnPoints().size() / 2)).m_130940_(ChatFormatting.GREEN));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> info, false);
        return 1;
    }

    public void saveArenaData() {
        try {
            if (!PvPManager.ARENA_DATA_FILE.getParentFile().exists()) {
                PvPManager.ARENA_DATA_FILE.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(PvPManager.ARENA_DATA_FILE);){
                ArenaDataCollection data = new ArenaDataCollection();
                for (PvPMap map : this.pvpManager.arenaMapsByName.values()) {
                    ArenaMapData mapData = new ArenaMapData();
                    mapData.name = map.getName();
                    mapData.dimension = map.getDimension().m_135782_().toString();
                    mapData.maxPlayers = map.getMaxPlayers();
                    mapData.spawnPoints = new ArrayList<SpawnPointData>();
                    for (GlobalPos pos : map.getSpawnPoints()) {
                        SpawnPointData spawnData = new SpawnPointData();
                        spawnData.x = pos.m_122646_().m_123341_();
                        spawnData.y = pos.m_122646_().m_123342_();
                        spawnData.z = pos.m_122646_().m_123343_();
                        mapData.spawnPoints.add(spawnData);
                    }
                    data.maps.add(mapData);
                }
                data.defaultMapName = this.pvpManager.defaultMapName;
                PvPManager.GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save arena data", (Throwable)e);
        }
    }

    public void loadArenaData() {
        if (!PvPManager.ARENA_DATA_FILE.exists()) {
            LOGGER.info("No PvP arena data file found. Skipping load.");
            return;
        }
        try (FileReader reader = new FileReader(PvPManager.ARENA_DATA_FILE);){
            ArenaDataCollection data = (ArenaDataCollection)PvPManager.GSON.fromJson((Reader)reader, ArenaDataCollection.class);
            if (data == null) {
                LOGGER.warn("PvP arena data file is empty or malformed. No arenas loaded.");
                return;
            }
            this.pvpManager.arenaMapsByName.clear();
            for (ArenaMapData mapData : data.maps) {
                ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(mapData.dimension));
                PvPMap map = new PvPMap(mapData.name, (ResourceKey<Level>)dimension);
                map.setMaxPlayers(mapData.maxPlayers);
                for (SpawnPointData spawnData : mapData.spawnPoints) {
                    GlobalPos pos = GlobalPos.m_122643_((ResourceKey)dimension, (BlockPos)new BlockPos(spawnData.x, spawnData.y, spawnData.z));
                    map.getSpawnPoints().add(pos);
                }
                this.pvpManager.arenaMapsByName.put(map.getName(), map);
            }
            this.pvpManager.defaultMapName = data.defaultMapName;
            LOGGER.info("Successfully loaded {} PvP arenas.", (Object)this.pvpManager.arenaMapsByName.size());
        }
        catch (Exception e) {
            LOGGER.error("FATAL: Failed to load or parse PvP arena data. Arenas will not be available.", (Throwable)e);
        }
    }
}

