/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.GlobalPos;

public class ActiveBattle {
    private final String battleId;
    private final List<List<UUID>> teams;
    private final List<GlobalPos> spawnPositions;
    private final String mapName;
    private final long startTime;
    private final Map<UUID, Integer> originalScores;
    private final Map<UUID, GlobalPos> originalPositions;

    public ActiveBattle(String battleId, List<List<UUID>> teams, List<GlobalPos> spawnPositions, String mapName) {
        this.battleId = battleId;
        this.teams = teams;
        this.spawnPositions = spawnPositions;
        this.mapName = mapName;
        this.startTime = System.currentTimeMillis();
        this.originalScores = new HashMap<UUID, Integer>();
        this.originalPositions = new HashMap<UUID, GlobalPos>();
    }

    public String getBattleId() {
        return this.battleId;
    }

    public List<List<UUID>> getTeams() {
        return this.teams;
    }

    public List<GlobalPos> getSpawnPositions() {
        return this.spawnPositions;
    }

    public String getMapName() {
        return this.mapName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Map<UUID, Integer> getOriginalScores() {
        return this.originalScores;
    }

    public Map<UUID, GlobalPos> getOriginalPositions() {
        return this.originalPositions;
    }

    public List<UUID> getAllPlayers() {
        ArrayList<UUID> allPlayers = new ArrayList<UUID>();
        for (List<UUID> team : this.teams) {
            allPlayers.addAll(team);
        }
        return allPlayers;
    }

    public int getTeamIndex(UUID playerId) {
        for (int i = 0; i < this.teams.size(); ++i) {
            if (!this.teams.get(i).contains(playerId)) continue;
            return i;
        }
        return -1;
    }

    public List<UUID> getTeammates(UUID playerId) {
        int teamIndex = this.getTeamIndex(playerId);
        return teamIndex >= 0 ? new ArrayList(this.teams.get(teamIndex)) : new ArrayList();
    }

    public List<UUID> getEnemies(UUID playerId) {
        ArrayList<UUID> enemies = new ArrayList<UUID>();
        int playerTeam = this.getTeamIndex(playerId);
        for (int i = 0; i < this.teams.size(); ++i) {
            if (i == playerTeam) continue;
            enemies.addAll((Collection<UUID>)this.teams.get(i));
        }
        return enemies;
    }

    public boolean isTeamEliminated(int teamIndex) {
        if (teamIndex < 0 || teamIndex >= this.teams.size()) {
            return true;
        }
        return this.teams.get(teamIndex).stream().allMatch(playerId -> this.originalScores.getOrDefault(playerId, 0) <= 0);
    }

    public List<Integer> getRemainingTeams() {
        ArrayList<Integer> remaining = new ArrayList<Integer>();
        for (int i = 0; i < this.teams.size(); ++i) {
            if (this.isTeamEliminated(i)) continue;
            remaining.add(i);
        }
        return remaining;
    }
}

