/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BattleRequest {
    private final UUID challengerId;
    private final List<UUID> targetPlayers;
    private final int amount;
    private final String mapName;
    private final long expiryTime;

    public BattleRequest(UUID challengerId, List<UUID> targetPlayers, int amount, String mapName) {
        this.challengerId = challengerId;
        this.targetPlayers = new ArrayList<UUID>(targetPlayers);
        this.amount = amount;
        this.mapName = mapName;
        this.expiryTime = System.currentTimeMillis() + 60000L;
    }

    public UUID getChallengerId() {
        return this.challengerId;
    }

    public List<UUID> getTargetPlayers() {
        return this.targetPlayers;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getMapName() {
        return this.mapName;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiryTime;
    }
}

