/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp.model;

public class PlayerPvPStats {
    private int duelsWon = 0;
    private int duelsLost = 0;
    private int teamBattlesWon = 0;
    private int teamBattlesLost = 0;
    private int arenaKills = 0;
    private int arenaDeaths = 0;

    public int getDuelsWon() {
        return this.duelsWon;
    }

    public int getDuelsLost() {
        return this.duelsLost;
    }

    public int getTeamBattlesWon() {
        return this.teamBattlesWon;
    }

    public int getTeamBattlesLost() {
        return this.teamBattlesLost;
    }

    public int getArenaKills() {
        return this.arenaKills;
    }

    public int getArenaDeaths() {
        return this.arenaDeaths;
    }

    public double getWinLossRatio() {
        int totalLosses = this.duelsLost + this.teamBattlesLost;
        if (totalLosses == 0) {
            return this.duelsWon + this.teamBattlesWon;
        }
        return (double)(this.duelsWon + this.teamBattlesWon) / (double)totalLosses;
    }

    public double getKillDeathRatio() {
        if (this.arenaDeaths == 0) {
            return this.arenaKills;
        }
        return (double)this.arenaKills / (double)this.arenaDeaths;
    }

    public void addWin(boolean isTeamBattle) {
        if (isTeamBattle) {
            ++this.teamBattlesWon;
        } else {
            ++this.duelsWon;
        }
    }

    public void addLoss(boolean isTeamBattle) {
        if (isTeamBattle) {
            ++this.teamBattlesLost;
        } else {
            ++this.duelsLost;
        }
    }

    public void addKill() {
        ++this.arenaKills;
    }

    public void addDeath() {
        ++this.arenaDeaths;
    }
}

