/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class PvPMap {
    private final String name;
    private final List<GlobalPos> spawnPoints;
    private final ResourceKey<Level> dimension;
    private int maxPlayers;

    public PvPMap(String name, ResourceKey<Level> dimension) {
        this.name = name;
        this.dimension = dimension;
        this.spawnPoints = new ArrayList<GlobalPos>();
        this.maxPlayers = 16;
    }

    public String getName() {
        return this.name;
    }

    public List<GlobalPos> getSpawnPoints() {
        return this.spawnPoints;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void addSpawnPoint(GlobalPos pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Cannot add null spawn point");
        }
        if (this.spawnPoints.size() >= this.maxPlayers) {
            throw new IllegalStateException("Cannot add more spawn points than max players");
        }
        this.spawnPoints.add(pos);
    }

    public boolean hasEnoughSpawnsForTeams(int teamSize, int teamCount) {
        return this.spawnPoints.size() >= teamSize * teamCount;
    }
}

