/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.pvp.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.machiavelli.minecolonytax.pvp.model.TeamBattleState;

public class TeamBattle {
    private final String battleId;
    private final String mapName;
    private final UUID organizer;
    private final List<UUID> team1 = new ArrayList<UUID>();
    private final List<UUID> team2 = new ArrayList<UUID>();
    private final long createdTime;
    private TeamBattleState state = TeamBattleState.RECRUITING;
    private final int maxTeamSize;
    public long countdownStartTime;

    public TeamBattle(String battleId, String mapName, UUID organizer, int maxTeamSize) {
        this.battleId = battleId;
        this.mapName = mapName;
        this.organizer = organizer;
        this.createdTime = System.currentTimeMillis();
        this.maxTeamSize = maxTeamSize;
    }

    public String getBattleId() {
        return this.battleId;
    }

    public String getMapName() {
        return this.mapName;
    }

    public UUID getOrganizer() {
        return this.organizer;
    }

    public List<UUID> getTeam1() {
        return this.team1;
    }

    public List<UUID> getTeam2() {
        return this.team2;
    }

    public TeamBattleState getState() {
        return this.state;
    }

    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    public void setState(TeamBattleState state) {
        this.state = state;
    }

    public void startCountdown() {
        if (this.state == TeamBattleState.RECRUITING) {
            this.state = TeamBattleState.COUNTDOWN;
            this.countdownStartTime = System.currentTimeMillis();
        }
    }

    public boolean addPlayerToTeam(UUID playerId, int teamNumber) {
        if (this.state == TeamBattleState.IN_PROGRESS || this.team1.contains(playerId) || this.team2.contains(playerId)) {
            return false;
        }
        if (teamNumber == 1 && this.team1.size() < this.maxTeamSize) {
            return this.team1.add(playerId);
        }
        if (teamNumber == 2 && this.team2.size() < this.maxTeamSize) {
            return this.team2.add(playerId);
        }
        return false;
    }

    public void removePlayer(UUID playerId) {
        this.team1.remove(playerId);
        this.team2.remove(playerId);
    }

    public boolean canStart() {
        return !this.team1.isEmpty() && !this.team2.isEmpty();
    }

    public int getTotalPlayers() {
        return this.team1.size() + this.team2.size();
    }

    public String getTeamForPlayer(UUID playerId) {
        if (this.team1.contains(playerId)) {
            return "team1";
        }
        if (this.team2.contains(playerId)) {
            return "team2";
        }
        return null;
    }

    public boolean arePlayersOnSameTeam(UUID player1, UUID player2) {
        String team1Name = this.getTeamForPlayer(player1);
        String team2Name = this.getTeamForPlayer(player2);
        return team1Name != null && team1Name.equals(team2Name);
    }
}

