/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.raid;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class ActiveRaidData {
    final UUID raider;
    final IColony colony;
    private IColony raiderColony;
    final ServerBossEvent bossEvent;
    int elapsedSeconds;
    TimerTask timerTask;
    boolean isActive;
    boolean warningSent;
    long totalTransferred;
    int totalGuards;
    int guardsKilled;
    boolean guardsInitialized;
    private final Set<Integer> originalGuardIds = new HashSet<Integer>();
    private final Set<Integer> killedGuardIds = new HashSet<Integer>();
    private boolean hasLeftBoundaries = false;
    private long timeLeftBoundaries = 0L;
    private int potentialStolenAmount = 0;

    public ActiveRaidData(UUID raider, IColony colony, ServerBossEvent bossEvent, TimerTask timerTask) {
        this.raider = raider;
        this.colony = colony;
        this.bossEvent = bossEvent;
        this.timerTask = timerTask;
        this.totalTransferred = 0L;
        this.guardsKilled = 0;
        this.guardsInitialized = false;
    }

    public ActiveRaidData(UUID raider, IColony colony) {
        this.raider = raider;
        this.colony = colony;
        this.bossEvent = new ServerBossEvent((Component)Component.m_237113_((String)("Raid in Progress: " + colony.getName())), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.bossEvent.m_142711_(0.0f);
        this.bossEvent.m_8321_(true);
        this.elapsedSeconds = 0;
        this.isActive = true;
        this.warningSent = false;
        this.totalTransferred = 0L;
        this.guardsKilled = 0;
        this.guardsInitialized = false;
        if (colony != null && colony.getPermissions() != null && colony.getWorld() != null && colony.getWorld().m_7654_() != null) {
            colony.getPermissions().getPlayers().keySet().forEach(uuid -> {
                ServerPlayer player = colony.getWorld().m_7654_().m_6846_().m_11259_(uuid);
                if (player != null) {
                    this.bossEvent.m_6543_(player);
                }
            });
        }
    }

    public long getTotalTransferred() {
        return this.totalTransferred;
    }

    public void addToTotalTransferred(long amt) {
        this.totalTransferred += amt;
    }

    public UUID getRaider() {
        return this.raider;
    }

    public IColony getColony() {
        return this.colony;
    }

    public ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    public int getElapsedSeconds() {
        return this.elapsedSeconds;
    }

    public void setElapsedSeconds(int elapsedSeconds) {
        this.elapsedSeconds = elapsedSeconds;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isWarningSent() {
        return this.warningSent;
    }

    public void setWarningSent(boolean warningSent) {
        this.warningSent = warningSent;
    }

    public IColony getRaiderColony() {
        return this.raiderColony;
    }

    public void setRaiderColony(IColony raiderColony) {
        this.raiderColony = raiderColony;
    }

    public int getTotalGuards() {
        return this.totalGuards;
    }

    public int getGuardsKilled() {
        return this.guardsKilled;
    }

    public boolean areGuardsInitialized() {
        return this.guardsInitialized;
    }

    public void initializeGuardCount(int totalGuards) {
        this.totalGuards = totalGuards;
        this.guardsInitialized = true;
    }

    public void incrementGuardsKilled() {
        ++this.guardsKilled;
    }

    public double getGuardKillPercentage() {
        if (this.totalGuards <= 0) {
            return 0.0;
        }
        return (double)this.guardsKilled / (double)this.totalGuards;
    }

    public boolean hasKilledAnyGuards() {
        return this.guardsKilled > 0;
    }

    public void snapshotOriginalGuardIds() {
        if (this.colony == null || this.colony.getCitizenManager() == null) {
            return;
        }
        this.originalGuardIds.clear();
        this.colony.getCitizenManager().getCitizens().forEach(c -> {
            String name;
            boolean isGuard = false;
            IJob job = c.getJob();
            if (job != null && job.isGuard()) {
                isGuard = true;
            } else if (c.getWorkBuilding() != null && ((name = c.getWorkBuilding().getBuildingDisplayName().toLowerCase()).contains("guard") || name.contains("barracks") || name.contains("archery") || name.contains("combat"))) {
                isGuard = true;
            }
            if (isGuard) {
                this.originalGuardIds.add(c.getId());
            }
        });
    }

    public boolean isOriginalGuard(int citizenId) {
        return this.originalGuardIds.contains(citizenId);
    }

    public boolean markGuardKilled(int citizenId) {
        if (!this.isOriginalGuard(citizenId)) {
            return false;
        }
        if (this.killedGuardIds.add(citizenId)) {
            this.incrementGuardsKilled();
            return true;
        }
        return false;
    }

    public int getOriginalGuardCount() {
        return this.originalGuardIds.size();
    }

    public int getKilledGuardCount() {
        return this.killedGuardIds.size();
    }

    public Set<Integer> getOriginalGuardIds() {
        return this.originalGuardIds;
    }

    public Set<Integer> getKilledGuardIds() {
        return this.killedGuardIds;
    }

    public boolean hasLeftBoundaries() {
        return this.hasLeftBoundaries;
    }

    public void markLeftBoundaries() {
        if (!this.hasLeftBoundaries) {
            this.hasLeftBoundaries = true;
            this.timeLeftBoundaries = System.currentTimeMillis();
        }
    }

    public long getTimeLeftBoundaries() {
        return this.timeLeftBoundaries;
    }

    public boolean isEligibleForRewards() {
        return !this.hasLeftBoundaries && this.hasKilledAnyGuards();
    }

    public void setPotentialStolenAmount(int amount) {
        this.potentialStolenAmount = amount;
    }

    public int getPotentialStolenAmount() {
        return this.potentialStolenAmount;
    }
}

