/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.raid;

import com.minecolonies.api.colony.IColony;
import java.util.List;
import java.util.UUID;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRaidDebugLogger {
    private static final Logger LOGGER = LogManager.getLogger(EntityRaidDebugLogger.class);
    public static final int LEVEL_BASIC = 1;
    public static final int LEVEL_DETAILED = 2;
    public static final int LEVEL_VERBOSE = 3;

    public static void logEntityDetection(IColony colony, List<Entity> entities) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        if (colony == null || entities == null) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 1) {
            LOGGER.info("[EntityRaid-DETECTION] Colony: {} | Entities Found: {} | Owner: {}", (Object)colony.getName(), (Object)entities.size(), (Object)EntityRaidDebugLogger.getOwnerName(colony));
        }
        if (debugLevel >= 2) {
            for (Entity entity : entities) {
                LOGGER.info("[EntityRaid-DETECTION] Colony: {} | Entity: {} | Position: {} | UUID: {}", (Object)colony.getName(), (Object)entity.m_6095_().m_20675_(), (Object)entity.m_20183_(), (Object)entity.m_20148_());
            }
        }
    }

    public static void logFilterStep(Entity entity, IColony colony, String filterName, boolean passed, String reason) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        if (entity == null || colony == null) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 2) {
            String result = passed ? "PASS" : "FAIL";
            LOGGER.info("[EntityRaid-FILTER] Colony: {} | Entity: {} | Filter: {} | Result: {} | Reason: {}", (Object)colony.getName(), (Object)entity.m_6095_().m_20675_(), (Object)filterName, (Object)result, (Object)reason);
        }
    }

    public static void logAllianceCheck(Entity entity, IColony colony, boolean isAllied, String method) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        if (entity == null || colony == null) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 2) {
            LOGGER.info("[EntityRaid-ALLIANCE] Colony: {} | Entity: {} | Allied: {} | Method: {}", (Object)colony.getName(), (Object)entity.m_6095_().m_20675_(), (Object)isAllied, (Object)method);
        }
    }

    public static void logPrerequisiteCheck(IColony colony, String requirement, boolean met, String details) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        if (colony == null) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 1) {
            String result = met ? "MET" : "NOT MET";
            LOGGER.info("[EntityRaid-PREREQUISITE] Colony: {} | Requirement: {} | Status: {} | Details: {}", (Object)colony.getName(), (Object)requirement, (Object)result, (Object)details);
        }
    }

    public static void logEntityTypeDetection(Entity entity, boolean isRecruit, String detectionMethod) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 3) {
            LOGGER.info("[EntityRaid-TYPE] Entity: {} | IsRecruit: {} | Method: {} | Class: {}", (Object)entity.m_6095_().m_20675_(), (Object)isRecruit, (Object)detectionMethod, (Object)entity.getClass().getSimpleName());
        }
    }

    public static void logOwnershipCheck(Entity entity, UUID entityOwner, UUID colonyOwner, boolean isOwned) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 2) {
            LOGGER.info("[EntityRaid-OWNERSHIP] Entity: {} | EntityOwner: {} | ColonyOwner: {} | IsOwned: {}", (Object)entity.m_6095_().m_20675_(), entityOwner != null ? entityOwner.toString().substring(0, 8) + "..." : "null", colonyOwner != null ? colonyOwner.toString().substring(0, 8) + "..." : "null", (Object)isOwned);
        }
    }

    public static void logGracePeriodCheck(Entity entity, long entityAge, boolean isRecent) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 2) {
            LOGGER.info("[EntityRaid-GRACE] Entity: {} | Age: {}ms | IsRecent: {} | Threshold: 10000ms", (Object)entity.m_6095_().m_20675_(), (Object)entityAge, (Object)isRecent);
        }
    }

    public static void logBoundaryCheck(Entity entity, IColony colony, boolean insideBoundary) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 3) {
            LOGGER.info("[EntityRaid-BOUNDARY] Colony: {} | Entity: {} | Position: {} | InsideBoundary: {}", (Object)colony.getName(), (Object)entity.m_6095_().m_20675_(), (Object)entity.m_20183_(), (Object)insideBoundary);
        }
    }

    public static void logRaidTrigger(IColony colony, int entityCount, int threshold) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 1) {
            LOGGER.info("[EntityRaid-TRIGGER] Colony: {} | EntityCount: {} | Threshold: {} | Owner: {} | RAID TRIGGERED", (Object)colony.getName(), (Object)entityCount, (Object)threshold, (Object)EntityRaidDebugLogger.getOwnerName(colony));
        }
    }

    public static void logPerformanceMetrics(String operation, long durationMs, int entitiesProcessed) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 3) {
            LOGGER.info("[EntityRaid-PERFORMANCE] Operation: {} | Duration: {}ms | EntitiesProcessed: {} | AvgPerEntity: {}ms", (Object)operation, (Object)durationMs, (Object)entitiesProcessed, (Object)(entitiesProcessed > 0 ? durationMs / (long)entitiesProcessed : 0L));
        }
    }

    public static void logReflectionCall(String methodName, String className, boolean success, String result) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 3) {
            LOGGER.info("[EntityRaid-REFLECTION] Method: {} | Class: {} | Success: {} | Result: {}", (Object)methodName, (Object)className, (Object)success, (Object)result);
        }
    }

    public static void logError(String operation, String error, Exception exception) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        if (exception != null) {
            LOGGER.error("[EntityRaid-ERROR] Operation: {} | Error: {} | Exception: {}", (Object)operation, (Object)error, (Object)exception.getMessage());
        } else {
            LOGGER.error("[EntityRaid-ERROR] Operation: {} | Error: {}", (Object)operation, (Object)error);
        }
    }

    public static void logCooldownCheck(IColony colony, long cooldownEnd, boolean onCooldown) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 2) {
            long currentTime = System.currentTimeMillis();
            long remainingMs = Math.max(0L, cooldownEnd - currentTime);
            LOGGER.info("[EntityRaid-COOLDOWN] Colony: {} | OnCooldown: {} | RemainingMs: {} | CooldownEnd: {}", (Object)colony.getName(), (Object)onCooldown, (Object)remainingMs, (Object)cooldownEnd);
        }
    }

    public static void logFilteringSummary(IColony colony, int totalEntities, int passedFiltering, int threshold) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 1) {
            boolean wouldTrigger = passedFiltering >= threshold;
            LOGGER.info("[EntityRaid-SUMMARY] Colony: {} | TotalEntities: {} | PassedFiltering: {} | Threshold: {} | WouldTrigger: {}", (Object)colony.getName(), (Object)totalEntities, (Object)passedFiltering, (Object)threshold, (Object)wouldTrigger);
        }
    }

    private static String getOwnerName(IColony colony) {
        ServerPlayer owner;
        UUID ownerUUID = colony.getPermissions().getOwner();
        if (ownerUUID == null) {
            return "NO_OWNER";
        }
        if (colony.getWorld() != null && colony.getWorld().m_7654_() != null && (owner = colony.getWorld().m_7654_().m_6846_().m_11259_(ownerUUID)) != null) {
            return owner.m_7755_().getString();
        }
        return ownerUUID.toString().substring(0, 8) + "...";
    }

    public static void logDebugSessionStart() {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        LOGGER.info("[EntityRaid-DEBUG] ========== EntityRaid Debug Session Started ==========");
        LOGGER.info("[EntityRaid-DEBUG] Debug Level: {} | Enabled Features: Detection, Filtering, Alliance, Performance", (Object)TaxConfig.getEntityRaidDebugLevel());
    }

    public static void logDebugSessionEnd() {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        LOGGER.info("[EntityRaid-DEBUG] ========== EntityRaid Debug Session Ended ==========");
    }

    public static void logFilterPipelineStats(IColony colony, int totalEntities, int passedWhitelist, int passedRecruitFilter, int finalAccepted) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 2) {
            LOGGER.info("[EntityRaid-PIPELINE] Colony: {} | Total: {} | Whitelist: {} | RecruitFilter: {} | Final: {} | Owner: {}", (Object)colony.getName(), (Object)totalEntities, (Object)passedWhitelist, (Object)passedRecruitFilter, (Object)finalAccepted, (Object)EntityRaidDebugLogger.getOwnerName(colony));
        }
    }

    public static void logFilterStepTimed(Entity entity, IColony colony, String filterName, boolean passed, String reason, long durationMs) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 3) {
            String result = passed ? "PASS" : "FAIL";
            LOGGER.info("[EntityRaid-FILTER-TIMED] Colony: {} | Entity: {} | Filter: {} | Result: {} | Duration: {}ms | Reason: {}", (Object)(colony != null ? colony.getName() : "N/A"), (Object)entity.m_6095_().m_20675_(), (Object)filterName, (Object)result, (Object)durationMs, (Object)reason);
        }
    }

    public static void logEntityAnalysis(Entity entity, IColony colony, String analysis) {
        if (!TaxConfig.isEntityRaidDebugEnabled()) {
            return;
        }
        int debugLevel = TaxConfig.getEntityRaidDebugLevel();
        if (debugLevel >= 3) {
            LOGGER.info("[EntityRaid-ANALYSIS] Colony: {} | Entity: {} | UUID: {} | Analysis: {}", (Object)(colony != null ? colony.getName() : "N/A"), (Object)entity.m_6095_().m_20675_(), (Object)(entity.m_20148_().toString().substring(0, 8) + "..."), (Object)analysis);
        }
    }
}

