/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.raid;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.network.EntityGlowPacket;
import net.machiavelli.minecolonytax.network.NetworkHandler;
import net.machiavelli.minecolonytax.raid.EntityRaidDebugLogger;
import net.machiavelli.minecolonytax.raid.ReflectionCache;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRaidManager {
    private static final Logger LOGGER = LogManager.getLogger(EntityRaidManager.class);
    private static final Map<Integer, ActiveEntityRaid> activeEntityRaids = new ConcurrentHashMap<Integer, ActiveEntityRaid>();
    private static final Map<UUID, Long> recentlyRecruitedEntities = new ConcurrentHashMap<UUID, Long>();
    private static final Map<Integer, Map<UUID, Boolean>> entityInsideByColony = new ConcurrentHashMap<Integer, Map<UUID, Boolean>>();
    private static final Map<Integer, Long> lastRaidTimeByColony = new ConcurrentHashMap<Integer, Long>();
    private static final Map<EntityType<?>, Boolean> whitelistCache = new ConcurrentHashMap();
    private static long lastWhitelistCacheUpdate = 0L;
    private static final long WHITELIST_CACHE_DURATION = 30000L;
    private static final int RAID_DURATION_SECONDS = 300;
    private static final int RECRUITMENT_COOLDOWN_MS = 30000;

    public static boolean shouldTriggerEntityRaid(Entity entity, IColony colony) {
        if (entity == null || colony == null) {
            if (TaxConfig.isEntityRaidDebugEnabled()) {
                LOGGER.warn("[EntityRaid] \u26a0\ufe0f NULL CHECK FAILED: entity={}, colony={}", (Object)(entity != null ? entity.m_6095_().m_20675_() : "null"), (Object)(colony != null ? colony.getName() : "null"));
            }
            return false;
        }
        EntityRaidDebugLogger.logFilterStep(entity, colony, "RAID_TRIGGER_CHECK", true, "Checking raid trigger for entity: " + entity.m_6095_().m_20675_());
        if (!EntityRaidManager.isRecruitEntity(entity)) {
            EntityRaidDebugLogger.logFilterStep(entity, colony, "RECRUIT_CHECK", false, "Entity is not a recruit, no raid triggered");
            return false;
        }
        if (EntityRaidManager.isRecentlyRecruited(entity)) {
            EntityRaidDebugLogger.logGracePeriodCheck(entity, System.currentTimeMillis() - recentlyRecruitedEntities.getOrDefault(entity.m_20148_(), 0L), true);
            return false;
        }
        if (!TaxConfig.shouldBypassAllianceChecks() && EntityRaidManager.isRecruitAlliedToColony(entity, colony, entity.m_9236_())) {
            EntityRaidDebugLogger.logAllianceCheck(entity, colony, true, "ALLIANCE_CHECK_PASSED - Entity is allied, no raid");
            return false;
        }
        if (TaxConfig.shouldBypassAllianceChecks()) {
            EntityRaidDebugLogger.logAllianceCheck(entity, colony, false, "ALLIANCE_CHECK_BYPASSED - Testing mode allows allied entities to trigger raids");
        }
        EntityRaidDebugLogger.logFilterStep(entity, colony, "FINAL_TRIGGER_CHECK", true, "All conditions met, triggering entity raid");
        return true;
    }

    public static void startEntityRaid(IColony colony, Entity triggerEntity) {
        if (colony == null || triggerEntity == null) {
            EntityRaidDebugLogger.logError("startEntityRaid", "Colony or trigger entity is null", null);
            return;
        }
        int colonyId = colony.getID();
        if (activeEntityRaids.containsKey(colonyId)) {
            EntityRaidDebugLogger.logPrerequisiteCheck(colony, "RAID_NOT_ACTIVE", false, "Entity raid already active for colony: " + colony.getName());
            return;
        }
        EntityRaidDebugLogger.logEntityDetection(colony, Arrays.asList(triggerEntity));
        ActiveEntityRaid raid = new ActiveEntityRaid(colony, triggerEntity);
        activeEntityRaids.put(colonyId, raid);
        EntityRaidManager.markRaidTriggered(colonyId);
        EntityRaidManager.applyGlowEffectToEntities(colony, triggerEntity.m_9236_());
        EntityRaidManager.logFilterCompletion(colony, "RAID_STARTED", 1);
    }

    public static long getLastRaidTime(int colonyId) {
        return lastRaidTimeByColony.getOrDefault(colonyId, 0L);
    }

    public static void markRaidTriggered(int colonyId) {
        lastRaidTimeByColony.put(colonyId, System.currentTimeMillis());
    }

    public static boolean isOnCooldown(int colonyId, long cooldownMs) {
        if (cooldownMs <= 0L) {
            return false;
        }
        long last = EntityRaidManager.getLastRaidTime(colonyId);
        return System.currentTimeMillis() - last < cooldownMs;
    }

    public static void endEntityRaid(int colonyId, String reason) {
        ActiveEntityRaid raid = activeEntityRaids.remove(colonyId);
        if (raid != null) {
            block5: {
                EntityRaidDebugLogger.logPrerequisiteCheck(raid.getColony(), "RAID_END", true, "Ending entity raid - Reason: " + reason);
                raid.cleanup();
                EntityRaidManager.removeGlowEffectFromEntities(raid.getColony());
                if (!"Expired".equals(reason)) {
                    try {
                        double pct = (Double)TaxConfig.RAID_PENALTY_PERCENTAGE.get() / 100.0;
                        if (pct > 0.0) {
                            pct = Math.min(pct, 0.2);
                            TaxManager.deductColonyTax(raid.getColony(), pct);
                        }
                    }
                    catch (Exception ex) {
                        if (!TaxConfig.isEntityRaidDebugEnabled()) break block5;
                        LOGGER.warn("[EntityRaid] Failed to apply penalty on raid end: {}", (Object)ex.toString());
                    }
                }
            }
            EntityRaidManager.notifyRaidEnded(raid.getColony(), reason);
            entityInsideByColony.remove(colonyId);
            EntityRaidManager.logFilterCompletion(raid.getColony(), "RAID_ENDED", 0);
        }
    }

    private static void notifyRaidEnded(IColony colony, String reason) {
        block6: {
            try {
                ServerPlayer owner;
                if (colony.getWorld() == null || colony.getWorld().m_7654_() == null) {
                    return;
                }
                MinecraftServer server = colony.getWorld().m_7654_();
                if (server == null) {
                    return;
                }
                MutableComponent message = Component.m_237113_((String)("The ambush on your colony has ended! (" + reason + ")")).m_130940_(ChatFormatting.GREEN);
                UUID ownerUUID = colony.getPermissions().getOwner();
                if (ownerUUID != null && (owner = server.m_6846_().m_11259_(ownerUUID)) != null) {
                    owner.m_213846_((Component)message);
                }
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    if (!colony.getPermissions().hasPermission((Player)player, Action.ACCESS_HUTS)) continue;
                    player.m_213846_((Component)message);
                }
            }
            catch (Exception e) {
                if (!TaxConfig.isEntityRaidDebugEnabled()) break block6;
                LOGGER.warn("[EntityRaid] Failed to notify raid ended: {}", (Object)e.toString());
            }
        }
    }

    public static void tick() {
        ArrayList<Integer> toEnd = new ArrayList<Integer>();
        ArrayList<String> reasons = new ArrayList<String>();
        for (Map.Entry<Integer, ActiveEntityRaid> entry : activeEntityRaids.entrySet()) {
            ActiveEntityRaid raid = entry.getValue();
            ActiveEntityRaid.EndReason reason = raid.tick();
            if (reason == ActiveEntityRaid.EndReason.NONE) continue;
            toEnd.add(entry.getKey());
            String r = reason == ActiveEntityRaid.EndReason.EXPIRED ? "Expired" : "Boundary timeout";
            reasons.add(r);
        }
        for (int i = 0; i < toEnd.size(); ++i) {
            EntityRaidManager.endEntityRaid((Integer)toEnd.get(i), (String)reasons.get(i));
        }
        EntityRaidManager.cleanupRecruitmentCooldowns();
    }

    private static boolean isRecruitEntity(Entity entity) {
        Boolean cachedResult;
        if (entity == null) {
            return false;
        }
        EntityType entityType = entity.m_6095_();
        long now = System.currentTimeMillis();
        if (now - lastWhitelistCacheUpdate > 30000L) {
            whitelistCache.clear();
            lastWhitelistCacheUpdate = now;
        }
        if ((cachedResult = whitelistCache.get(entityType)) != null) {
            return cachedResult;
        }
        boolean match = EntityRaidManager.computeWhitelistMatch(entity, entityType);
        whitelistCache.put(entityType, match);
        if (TaxConfig.isEntityRaidDebugEnabled() && match) {
            ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
            String registryId = rl != null ? rl.toString() : "";
            LOGGER.info("[EntityRaid] \u2705 WHITELIST MATCH: {} matches pattern in whitelist. registryId={}", (Object)entityType.m_20675_(), (Object)registryId);
        }
        return match;
    }

    private static boolean computeWhitelistMatch(Entity entity, EntityType<?> entityType) {
        List<? extends String> whitelist = TaxConfig.getEntityRaidWhitelist();
        ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        String registryId = rl != null ? rl.toString() : "";
        String namespace = rl != null ? rl.m_135827_() : "";
        String descId = entityType.m_20675_();
        for (String string : whitelist) {
            String ns;
            String string2;
            if (string == null || (string2 = string.trim()).isEmpty()) continue;
            if (string2.equals("*")) {
                return true;
            }
            if (string2.endsWith(":*") && (ns = string2.substring(0, string2.length() - 2)).equalsIgnoreCase(namespace)) {
                return true;
            }
            if (!string2.equalsIgnoreCase(registryId) && !string2.equalsIgnoreCase(descId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRecentlyRecruited(Entity entity) {
        Long recruitTime = recentlyRecruitedEntities.get(entity.m_20148_());
        if (recruitTime == null) {
            return false;
        }
        return System.currentTimeMillis() - recruitTime < 30000L;
    }

    public static void markEntityAsRecruited(Entity entity) {
        if (entity != null) {
            recentlyRecruitedEntities.put(entity.m_20148_(), System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRecruitAlliedToColony(Entity entity, IColony colony, Level level) {
        long startTime = System.currentTimeMillis();
        try {
            if (colony.getWorld() == null || colony.getWorld().m_7654_() == null) {
                EntityRaidDebugLogger.logError("isRecruitAlliedToColony", "PREREQUISITE_FAIL: World or Server is null for colony: " + colony.getName(), null);
                boolean bl = false;
                return bl;
            }
            MinecraftServer server = colony.getWorld().m_7654_();
            if (server == null) {
                EntityRaidDebugLogger.logAllianceCheck(entity, colony, false, "PREREQUISITE_FAIL: Server is null");
                boolean elapsed = false;
                return elapsed;
            }
            UUID colonyOwnerUUID = colony.getPermissions().getOwner();
            if (colonyOwnerUUID == null) {
                EntityRaidDebugLogger.logAllianceCheck(entity, colony, false, "PREREQUISITE_FAIL: Colony has no owner");
                boolean elapsed = false;
                return elapsed;
            }
            ServerPlayer colonyOwner = server.m_6846_().m_11259_(colonyOwnerUUID);
            if (colonyOwner == null) {
                EntityRaidDebugLogger.logAllianceCheck(entity, colony, false, "PREREQUISITE_FAIL: Colony owner is offline");
                boolean elapsed = false;
                return elapsed;
            }
            Boolean recruitsDiplomacy = EntityRaidManager.checkRecruitsDiplomacy(entity, colonyOwner, colony);
            if (recruitsDiplomacy != null) {
                boolean elapsed = recruitsDiplomacy;
                return elapsed;
            }
            Boolean teamAlliance = EntityRaidManager.checkTeamBasedAlliance(entity, colonyOwner, colony);
            if (teamAlliance != null) {
                boolean elapsed = teamAlliance;
                return elapsed;
            }
            Boolean ownershipAlliance = EntityRaidManager.checkOwnershipBasedAlliance(entity, colonyOwnerUUID, colony, server);
            if (ownershipAlliance != null) {
                boolean bl = ownershipAlliance;
                return bl;
            }
            EntityRaidDebugLogger.logAllianceCheck(entity, colony, false, "ALL_METHODS_FAILED: No definitive alliance found.");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("isRecruitAlliedToColony", "CRITICAL_ERROR: Unexpected error during alliance check for " + entity.m_6095_().m_20675_(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            long elapsed = System.currentTimeMillis() - startTime;
            if (TaxConfig.isEntityRaidDebugEnabled() && TaxConfig.getEntityRaidDebugLevel() >= 2) {
                LOGGER.info("[EntityRaid-PERF] Alliance check took {}ms for entity {} vs colony {}", (Object)elapsed, (Object)entity.m_6095_().m_20675_(), (Object)colony.getName());
            }
        }
    }

    private static Boolean checkRecruitsDiplomacy(Entity entity, ServerPlayer colonyOwner, IColony colony) {
        try {
            String colonyTeamName;
            if (!EntityRaidManager.isRecruitsModLoaded()) {
                if (TaxConfig.isEntityRaidDebugEnabled()) {
                    LOGGER.info("[EntityRaid-RECRUITS] Recruits mod not detected, skipping diplomacy check");
                }
                return null;
            }
            Team entityTeam = entity.m_5647_();
            Team colonyOwnerTeam = colonyOwner.m_5647_();
            if (entityTeam == null || colonyOwnerTeam == null) {
                if (TaxConfig.isEntityRaidDebugEnabled() && TaxConfig.getEntityRaidDebugLevel() >= 3) {
                    LOGGER.debug("[EntityRaid-RECRUITS] Entity or colony owner not in teams (entity: {}, owner: {})", (Object)(entityTeam != null ? entityTeam.m_5758_() : "null"), (Object)(colonyOwnerTeam != null ? colonyOwnerTeam.m_5758_() : "null"));
                }
                return null;
            }
            String entityTeamName = entityTeam.m_5758_();
            Object diplomacyStatus = EntityRaidManager.getRecruitsDiplomaticRelation(entityTeamName, colonyTeamName = colonyOwnerTeam.m_5758_());
            if (diplomacyStatus != null) {
                String statusName = diplomacyStatus.toString();
                boolean isAlly = "ALLY".equals(statusName);
                if (TaxConfig.isEntityRaidDebugEnabled()) {
                    LOGGER.info("[EntityRaid-RECRUITS] Diplomatic relation: {} -> {} = {} (isAlly: {})", (Object)entityTeamName, (Object)colonyTeamName, (Object)statusName, (Object)isAlly);
                }
                return isAlly;
            }
            return null;
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("checkRecruitsDiplomacy", "Failed to check Recruits diplomacy for " + entity.m_6095_().m_20675_(), e);
            return null;
        }
    }

    private static Boolean checkTeamBasedAlliance(Entity entity, ServerPlayer colonyOwner, IColony colony) {
        try {
            Team entityTeam = entity.m_5647_();
            Team ownerTeam = colonyOwner.m_5647_();
            if (entityTeam != null && ownerTeam != null) {
                boolean sameTeam = entityTeam.m_5758_().equals(ownerTeam.m_5758_());
                if (TaxConfig.isEntityRaidDebugEnabled()) {
                    LOGGER.info("[EntityRaid-ALLIANCE] Entity team: '{}', Owner team: '{}', Same: {}", (Object)entityTeam.m_5758_(), (Object)ownerTeam.m_5758_(), (Object)sameTeam);
                }
                return sameTeam;
            }
            return null;
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("checkTeamBasedAlliance", "Failed to check team alliance for " + entity.m_6095_().m_20675_(), e);
            return null;
        }
    }

    private static Boolean checkOwnershipBasedAlliance(Entity entity, UUID colonyOwnerUUID, IColony colony, MinecraftServer server) {
        try {
            UUID entityOwnerUUID = ReflectionCache.getRecruitOwnerUUID(entity);
            if (entityOwnerUUID != null) {
                boolean isAllied = entityOwnerUUID.equals(colonyOwnerUUID);
                EntityRaidDebugLogger.logAllianceCheck(entity, colony, isAllied, "OWNERSHIP_ALLIANCE: Entity owner=" + entityOwnerUUID + ", Colony owner=" + colonyOwnerUUID);
                return isAllied;
            }
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("checkOwnershipBasedAlliance", "Error checking ownership alliance", e);
        }
        return null;
    }

    private static void applyGlowEffectToEntities(IColony colony, Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        UUID colonyOwnerUUID = colony.getPermissions().getOwner();
        if (colonyOwnerUUID == null) {
            return;
        }
        MinecraftServer server = serverLevel.m_7654_();
        ServerPlayer colonyOwner = server.m_6846_().m_11259_(colonyOwnerUUID);
        if (colonyOwner == null) {
            return;
        }
        ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
        for (Entity entity : serverLevel.m_142646_().m_142273_()) {
            double distanceSq = entity.m_20275_((double)colony.getCenter().m_123341_(), (double)colony.getCenter().m_123342_(), (double)colony.getCenter().m_123343_());
            if (!(distanceSq < 10000.0) || !EntityRaidManager.isRecruitEntity(entity)) continue;
            nearbyEntities.add(entity);
        }
        for (Entity entity : nearbyEntities) {
            EntityGlowPacket packet = new EntityGlowPacket(entity.m_19879_(), true, 6000);
            NetworkHandler.CHANNEL.sendTo((Object)packet, colonyOwner.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        if (TaxConfig.isEntityRaidDebugEnabled()) {
            LOGGER.info("[EntityRaid-GLOW] Applied glow effect to {} entities for colony: {}", (Object)nearbyEntities.size(), (Object)colony.getName());
        }
    }

    private static void removeGlowEffectFromEntities(IColony colony) {
        Level level = colony.getWorld();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        UUID colonyOwnerUUID = colony.getPermissions().getOwner();
        if (colonyOwnerUUID == null) {
            return;
        }
        MinecraftServer server = serverLevel.m_7654_();
        ServerPlayer colonyOwner = server.m_6846_().m_11259_(colonyOwnerUUID);
        if (colonyOwner == null) {
            return;
        }
        ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
        for (Entity entity : serverLevel.m_142646_().m_142273_()) {
            double distanceSq = entity.m_20275_((double)colony.getCenter().m_123341_(), (double)colony.getCenter().m_123342_(), (double)colony.getCenter().m_123343_());
            if (!(distanceSq < 10000.0) || !EntityRaidManager.isRecruitEntity(entity)) continue;
            nearbyEntities.add(entity);
        }
        for (Entity entity : nearbyEntities) {
            EntityGlowPacket packet = new EntityGlowPacket(entity.m_19879_(), false, 0);
            NetworkHandler.CHANNEL.sendTo((Object)packet, colonyOwner.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        if (TaxConfig.isEntityRaidDebugEnabled()) {
            LOGGER.info("[EntityRaid-GLOW] Removed glow effect from {} entities for colony: {}", (Object)nearbyEntities.size(), (Object)colony.getName());
        }
    }

    private static void cleanupRecruitmentCooldowns() {
        long currentTime = System.currentTimeMillis();
        recentlyRecruitedEntities.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 30000L);
    }

    public static BoundaryEvent checkAndUpdateBoundary(IColony colony, Entity entity) {
        if (colony == null || entity == null || colony.getWorld() == null) {
            return BoundaryEvent.NONE;
        }
        Map map = entityInsideByColony.computeIfAbsent(colony.getID(), k -> new ConcurrentHashMap());
        boolean currentInside = false;
        try {
            currentInside = colony.isCoordInColony(colony.getWorld(), entity.m_20183_());
        }
        catch (Throwable t) {
            return BoundaryEvent.NONE;
        }
        UUID id = entity.m_20148_();
        Boolean prev = map.put(id, currentInside);
        if (prev == null) {
            return BoundaryEvent.NONE;
        }
        if (!prev.booleanValue() && currentInside) {
            return BoundaryEvent.ENTERED;
        }
        if (prev.booleanValue() && !currentInside) {
            return BoundaryEvent.EXITED;
        }
        return BoundaryEvent.NONE;
    }

    private static boolean isRecruitsModLoaded() {
        try {
            Class.forName("com.talhanation.recruits.TeamEvents");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Object getRecruitsDiplomaticRelation(String team1, String team2) {
        block3: {
            try {
                Class<?> teamEventsClass = Class.forName("com.talhanation.recruits.TeamEvents");
                Field diplomacyManagerField = teamEventsClass.getDeclaredField("recruitsDiplomacyManager");
                diplomacyManagerField.setAccessible(true);
                Object diplomacyManager = diplomacyManagerField.get(null);
                if (diplomacyManager != null) {
                    Method getRelationMethod = diplomacyManager.getClass().getMethod("getRelation", String.class, String.class);
                    return getRelationMethod.invoke(diplomacyManager, team1, team2);
                }
            }
            catch (Exception e) {
                if (!TaxConfig.isEntityRaidDebugEnabled()) break block3;
                LOGGER.warn("[EntityRaid-RECRUITS] Failed to access Recruits diplomacy: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    private static void logFilterCompletion(IColony colony, String stage, int count) {
        if (TaxConfig.isEntityRaidDebugEnabled()) {
            LOGGER.info("[EntityRaid-FILTER] Colony: {} - Stage: {} - Count: {}", (Object)colony.getName(), (Object)stage, (Object)count);
        }
    }

    public static ActiveEntityRaid getActiveEntityRaid(int colonyId) {
        return activeEntityRaids.get(colonyId);
    }

    public static boolean hasActiveEntityRaid(int colonyId) {
        return activeEntityRaids.containsKey(colonyId);
    }

    public static Map<Integer, ActiveEntityRaid> getActiveEntityRaids() {
        return new HashMap<Integer, ActiveEntityRaid>(activeEntityRaids);
    }

    public static class ActiveEntityRaid {
        private final IColony colony;
        private final Entity triggerEntity;
        private final long startTime;
        private final int colonyId;
        private boolean isActive;
        private boolean hasLeftBoundary;
        private ServerBossEvent bossBar;
        private long lastRevenueDeduction = 0L;
        private int lastEntityCount = 0;
        private long graceRemainingMs = -1L;
        private long graceActiveStartMs = -1L;
        private int cachedEntityCount = 0;
        private long lastEntityCountUpdate = 0L;
        private static final long ENTITY_COUNT_CACHE_MS = 2000L;

        public ActiveEntityRaid(IColony colony, Entity triggerEntity) {
            this.colony = colony;
            this.triggerEntity = triggerEntity;
            this.startTime = System.currentTimeMillis();
            this.colonyId = colony.getID();
            this.isActive = true;
            this.hasLeftBoundary = false;
            this.lastRevenueDeduction = this.startTime;
            this.createBossBar();
            this.notifyColonyMembers();
        }

        public EndReason tick() {
            long now = System.currentTimeMillis();
            long elapsed = now - this.startTime;
            if (elapsed > 300000L) {
                this.isActive = false;
                return EndReason.EXPIRED;
            }
            if (now - this.lastRevenueDeduction >= 60000L) {
                this.deductRevenue();
                this.lastRevenueDeduction = now;
            }
            int currentCount = this.getCachedEntityCount(now);
            int threshold = Math.max(1, TaxConfig.getEntityRaidThreshold());
            if (currentCount == 0) {
                long graceElapsed;
                if (this.graceRemainingMs < 0L) {
                    this.graceRemainingMs = 5000L;
                    if (TaxConfig.isEntityRaidDebugEnabled()) {
                        LOGGER.info("[EntityRaid] All entities left boundary, starting 5s grace for colony '{}'", (Object)this.colony.getName());
                    }
                }
                if (this.graceActiveStartMs < 0L) {
                    this.graceActiveStartMs = now;
                }
                if ((graceElapsed = now - this.graceActiveStartMs) >= this.graceRemainingMs) {
                    if (TaxConfig.isEntityRaidDebugEnabled()) {
                        LOGGER.info("[EntityRaid] Grace expired (no entities returned); ending raid for colony '{}'", (Object)this.colony.getName());
                    }
                    this.isActive = false;
                    return EndReason.BOUNDARY_TIMEOUT;
                }
            } else if (this.graceRemainingMs >= 0L && this.graceActiveStartMs >= 0L) {
                long graceElapsed = now - this.graceActiveStartMs;
                this.graceRemainingMs = Math.max(0L, this.graceRemainingMs - graceElapsed);
                this.graceActiveStartMs = -1L;
                if (TaxConfig.isEntityRaidDebugEnabled()) {
                    LOGGER.info("[EntityRaid] Entity re-entered; pausing grace (remaining={} ms) for colony '{}'", (Object)this.graceRemainingMs, (Object)this.colony.getName());
                }
            }
            this.updateBossBar(currentCount, threshold, now);
            return EndReason.NONE;
        }

        private void createBossBar() {
            if (this.bossBar != null) {
                return;
            }
            MutableComponent title = Component.m_237113_((String)"Ambush!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            this.bossBar = new ServerBossEvent((Component)title, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
            this.bossBar.m_142711_(1.0f);
            this.addColonyMembersToBossBar();
            if (TaxConfig.isEntityRaidDebugEnabled()) {
                LOGGER.info("[EntityRaid] Bossbar created for colony '{}'", (Object)this.colony.getName());
            }
        }

        private void updateBossBar(int currentCount, int threshold, long now) {
            if (this.bossBar == null) {
                return;
            }
            long raidElapsed = now - this.startTime;
            long raidTimeLeftMs = Math.max(0L, 300000L - raidElapsed);
            int totalSecondsLeft = (int)Math.ceil((double)raidTimeLeftMs / 1000.0);
            int minutesLeft = totalSecondsLeft / 60;
            int secondsLeft = totalSecondsLeft % 60;
            String timeLeftStr = minutesLeft > 0 ? minutesLeft + "m " + secondsLeft + "s" : secondsLeft + "s";
            float progress = Math.max(0.0f, Math.min(1.0f, (float)raidTimeLeftMs / 300000.0f));
            this.bossBar.m_142711_(progress);
            if (this.graceRemainingMs >= 0L && this.graceActiveStartMs >= 0L) {
                long graceElapsed = now - this.graceActiveStartMs;
                long graceMillisLeft = Math.max(0L, this.graceRemainingMs - graceElapsed);
                int graceSecsLeft = (int)Math.ceil((double)graceMillisLeft / 1000.0);
                this.bossBar.m_6451_(BossEvent.BossBarColor.YELLOW);
                MutableComponent title = Component.m_237113_((String)("Ambush! 0 remaining \u2014 Return in " + graceSecsLeft + "s (" + timeLeftStr + " left)")).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
                this.bossBar.m_6456_((Component)title);
            } else {
                this.bossBar.m_6451_(BossEvent.BossBarColor.RED);
                MutableComponent title = Component.m_237113_((String)("Ambush! " + currentCount + " remaining \u2014 " + timeLeftStr + " left")).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                this.bossBar.m_6456_((Component)title);
            }
            this.lastEntityCount = currentCount;
        }

        private int getCachedEntityCount(long currentTime) {
            if (currentTime - this.lastEntityCountUpdate > 2000L) {
                this.cachedEntityCount = this.countWhitelistedEntitiesInside();
                this.lastEntityCountUpdate = currentTime;
            }
            return this.cachedEntityCount;
        }

        private int countWhitelistedEntitiesInside() {
            Level level;
            if (this.colony.getWorld() == null || !((level = this.colony.getWorld()) instanceof ServerLevel)) {
                return 0;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            int count = 0;
            try {
                for (Entity entity : serverLevel.m_142646_().m_142273_()) {
                    if (!EntityRaidManager.isRecruitEntity(entity) || !this.colony.isCoordInColony(this.colony.getWorld(), entity.m_20183_())) continue;
                    ++count;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return count;
        }

        private void deductRevenue() {
            try {
                double pct = (Double)TaxConfig.RAID_PENALTY_PERCENTAGE.get();
                if (pct > 0.0) {
                    TaxManager.deductColonyTax(this.colony, pct);
                    LOGGER.info("[EntityRaid] \u26a0\ufe0f TAX DEDUCTED: {}% revenue from colony '{}' during raid", (Object)(pct * 100.0), (Object)this.colony.getName());
                    this.notifyTaxDeduction(pct * 100.0);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("[EntityRaid] \u274c FAILED to deduct revenue during raid from '{}': {}", (Object)this.colony.getName(), (Object)ex.toString());
            }
        }

        private void notifyTaxDeduction(double percentage) {
            try {
                ServerPlayer owner;
                if (this.colony.getWorld() == null || this.colony.getWorld().m_7654_() == null) {
                    return;
                }
                MinecraftServer server = this.colony.getWorld().m_7654_();
                MutableComponent message = Component.m_237113_((String)("\u26a0\ufe0f Raid tax deduction: " + String.format("%.1f", percentage) + "% of colony revenue lost!")).m_130940_(ChatFormatting.RED);
                HashSet<UUID> notifiedPlayers = new HashSet<UUID>();
                UUID ownerUUID = this.colony.getPermissions().getOwner();
                if (ownerUUID != null && (owner = server.m_6846_().m_11259_(ownerUUID)) != null) {
                    owner.m_213846_((Component)message);
                    notifiedPlayers.add(ownerUUID);
                }
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    UUID playerUUID = player.m_20148_();
                    if (notifiedPlayers.contains(playerUUID) || !this.colony.getPermissions().hasPermission((Player)player, Action.ACCESS_HUTS)) continue;
                    player.m_213846_((Component)message);
                    notifiedPlayers.add(playerUUID);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void notifyColonyMembers() {
            block7: {
                try {
                    ServerPlayer owner;
                    if (this.colony.getWorld() == null || this.colony.getWorld().m_7654_() == null) {
                        return;
                    }
                    MinecraftServer server = this.colony.getWorld().m_7654_();
                    if (server == null) {
                        return;
                    }
                    MutableComponent message = Component.m_237113_((String)"Your colony is under attack! Defend against the ambush!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                    HashSet<UUID> notifiedPlayers = new HashSet<UUID>();
                    UUID ownerUUID = this.colony.getPermissions().getOwner();
                    if (ownerUUID != null && (owner = server.m_6846_().m_11259_(ownerUUID)) != null) {
                        owner.m_213846_((Component)message);
                        owner.m_5661_((Component)Component.m_237113_((String)"Ambush!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                        notifiedPlayers.add(ownerUUID);
                        if (TaxConfig.isEntityRaidDebugEnabled()) {
                            LOGGER.info("[EntityRaid] Notified owner {} for colony '{}'", (Object)owner.m_36316_().getName(), (Object)this.colony.getName());
                        }
                    }
                    for (ServerPlayer player : server.m_6846_().m_11314_()) {
                        UUID playerUUID = player.m_20148_();
                        if (notifiedPlayers.contains(playerUUID) || !this.colony.getPermissions().hasPermission((Player)player, Action.ACCESS_HUTS)) continue;
                        player.m_213846_((Component)message);
                        player.m_5661_((Component)Component.m_237113_((String)"Ambush!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                        notifiedPlayers.add(playerUUID);
                        if (!TaxConfig.isEntityRaidDebugEnabled()) continue;
                        LOGGER.info("[EntityRaid] Notified player {} (ACCESS_HUTS) for colony '{}'", (Object)player.m_36316_().getName(), (Object)this.colony.getName());
                    }
                }
                catch (Exception e) {
                    if (!TaxConfig.isEntityRaidDebugEnabled()) break block7;
                    LOGGER.warn("[EntityRaid] Failed to notify colony members: {}", (Object)e.toString());
                }
            }
        }

        private void addColonyMembersToBossBar() {
            block7: {
                if (this.bossBar == null) {
                    return;
                }
                try {
                    ServerPlayer owner;
                    if (this.colony.getWorld() == null || this.colony.getWorld().m_7654_() == null) {
                        return;
                    }
                    MinecraftServer server = this.colony.getWorld().m_7654_();
                    UUID ownerUUID = this.colony.getPermissions().getOwner();
                    if (ownerUUID != null && (owner = server.m_6846_().m_11259_(ownerUUID)) != null) {
                        this.bossBar.m_6543_(owner);
                        if (TaxConfig.isEntityRaidDebugEnabled()) {
                            LOGGER.info("[EntityRaid] Added owner {} to bossbar for colony '{}'", (Object)owner.m_36316_().getName(), (Object)this.colony.getName());
                        }
                    }
                    for (ServerPlayer player : server.m_6846_().m_11314_()) {
                        if (!this.colony.getPermissions().hasPermission((Player)player, Action.ACCESS_HUTS)) continue;
                        this.bossBar.m_6543_(player);
                        if (!TaxConfig.isEntityRaidDebugEnabled()) continue;
                        LOGGER.info("[EntityRaid] Added player {} to bossbar for colony '{}'", (Object)player.m_36316_().getName(), (Object)this.colony.getName());
                    }
                }
                catch (Exception e) {
                    if (!TaxConfig.isEntityRaidDebugEnabled()) break block7;
                    LOGGER.warn("[EntityRaid] Failed to add players to bossbar: {}", (Object)e.toString());
                }
            }
        }

        public void attachEligiblePlayer(ServerPlayer player) {
            block5: {
                if (this.bossBar == null || player == null) {
                    return;
                }
                try {
                    UUID ownerUUID = this.colony.getPermissions().getOwner();
                    boolean isOwner = ownerUUID != null && ownerUUID.equals(player.m_20148_());
                    boolean hasAccess = this.colony.getPermissions().hasPermission((Player)player, Action.ACCESS_HUTS);
                    if (isOwner || hasAccess) {
                        this.bossBar.m_6543_(player);
                        if (TaxConfig.isEntityRaidDebugEnabled()) {
                            LOGGER.info("[EntityRaid] Attached player {} to bossbar for colony '{}'", (Object)player.m_36316_().getName(), (Object)this.colony.getName());
                        }
                    }
                }
                catch (Exception e) {
                    if (!TaxConfig.isEntityRaidDebugEnabled()) break block5;
                    LOGGER.warn("[EntityRaid] Failed to attach player to bossbar: {}", (Object)e.toString());
                }
            }
        }

        public void cleanup() {
            if (this.bossBar != null) {
                this.bossBar.m_7706_();
                this.bossBar = null;
            }
        }

        public IColony getColony() {
            return this.colony;
        }

        public Entity getTriggerEntity() {
            return this.triggerEntity;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getColonyId() {
            return this.colonyId;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean hasLeftBoundary() {
            return this.hasLeftBoundary;
        }

        public void setLeftBoundary(boolean leftBoundary) {
            this.hasLeftBoundary = leftBoundary;
        }

        public List<Entity> getTriggeringEntities() {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            if (this.triggerEntity != null && this.triggerEntity.m_9236_() != null) {
                entities.add(this.triggerEntity);
            }
            return entities;
        }

        public static enum EndReason {
            NONE,
            EXPIRED,
            BOUNDARY_TIMEOUT;

        }
    }

    public static enum BoundaryEvent {
        NONE,
        ENTERED,
        EXITED;

    }
}

