/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.raid;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuardResistanceHandler {
    private static final Logger LOGGER = LogManager.getLogger(GuardResistanceHandler.class);
    private static final Map<Integer, Set<UUID>> colonyGuardEffects = new HashMap<Integer, Set<UUID>>();
    private static final Map<Integer, Set<UUID>> colonyWarGuardEffects = new HashMap<Integer, Set<UUID>>();

    @Deprecated
    public static void applyResistanceToGuards(IColony colony) {
        if (!TaxConfig.isGuardResistanceDuringRaidsEnabled()) {
            return;
        }
        int resistanceLevel = TaxConfig.getGuardResistanceLevel();
        if (resistanceLevel <= 0) {
            return;
        }
        Integer colonyId = colony.getID();
        HashSet affectedGuards = new HashSet();
        try {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!GuardResistanceHandler.isGuardBuilding(building)) continue;
                building.getAllAssignedCitizen().forEach(citizenData -> {
                    AbstractEntityCitizen guard;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (guard = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && guard.m_6084_()) {
                        GuardResistanceHandler.applyResistanceEffect(guard, resistanceLevel);
                        affectedGuards.add(guard.m_20148_());
                    }
                });
            }
            if (((Boolean)TaxConfig.APPLY_RESISTANCE_TO_CITIZENS.get()).booleanValue()) {
                colony.getCitizenManager().getCitizens().forEach(citizenData -> {
                    AbstractEntityCitizen citizen;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (citizen = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && citizen.m_6084_() && !affectedGuards.contains(citizen.m_20148_())) {
                        GuardResistanceHandler.applyResistanceEffect(citizen, resistanceLevel);
                        affectedGuards.add(citizen.m_20148_());
                    }
                });
            }
            colonyGuardEffects.put(colonyId, affectedGuards);
            if (!affectedGuards.isEmpty()) {
                String entityType = (Boolean)TaxConfig.APPLY_RESISTANCE_TO_CITIZENS.get() != false ? "guards and citizens" : "guards";
                LOGGER.info("Applied Resistance {} effect to {} {} in colony '{}' during raid", (Object)resistanceLevel, (Object)affectedGuards.size(), (Object)entityType, (Object)colony.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply resistance effects to guards in colony '{}': {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    @Deprecated
    public static void removeResistanceFromGuards(IColony colony) {
        if (!TaxConfig.isGuardResistanceDuringRaidsEnabled()) {
            return;
        }
        Integer colonyId = colony.getID();
        Set<UUID> affectedGuards = colonyGuardEffects.get(colonyId);
        if (affectedGuards == null || affectedGuards.isEmpty()) {
            return;
        }
        int removedCount = 0;
        try {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!GuardResistanceHandler.isGuardBuilding(building)) continue;
                building.getAllAssignedCitizen().forEach(citizenData -> {
                    AbstractEntityCitizen guard;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (guard = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && affectedGuards.contains(guard.m_20148_())) {
                        GuardResistanceHandler.removeResistanceEffect(guard);
                    }
                });
            }
            removedCount = affectedGuards.size();
            colonyGuardEffects.remove(colonyId);
            if (removedCount > 0) {
                LOGGER.info("Removed Resistance effects from {} guards in colony '{}' after raid", (Object)removedCount, (Object)colony.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove resistance effects from guards in colony '{}': {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    private static void applyResistanceEffect(AbstractEntityCitizen guard, int level) {
        try {
            int durationTicks = 144000;
            MobEffectInstance resistanceEffect = new MobEffectInstance(MobEffects.f_19606_, durationTicks, level - 1, false, true, true);
            guard.m_7292_(resistanceEffect);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to apply resistance effect to guard {}: {}", (Object)guard.m_20148_(), (Object)e.getMessage());
        }
    }

    private static void removeResistanceEffect(AbstractEntityCitizen guard) {
        try {
            guard.m_21195_(MobEffects.f_19606_);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to remove resistance effect from guard {}: {}", (Object)guard.m_20148_(), (Object)e.getMessage());
        }
    }

    private static boolean isGuardBuilding(IBuilding building) {
        String lowerName;
        if (building == null) {
            return false;
        }
        String displayName = building.getBuildingDisplayName();
        if (displayName != null && ((lowerName = displayName.toLowerCase()).contains("guard") || lowerName.contains("barracks") || lowerName.contains("combat") || lowerName.contains("archery"))) {
            return true;
        }
        String className = building.getClass().getName().toLowerCase();
        return className.contains("guard") || className.contains("barracks") || className.contains("combat") || className.contains("archery");
    }

    public static void applyResistanceToGuardsForWar(IColony colony) {
        if (!TaxConfig.isGuardResistanceDuringRaidsEnabled()) {
            return;
        }
        int resistanceLevel = TaxConfig.getGuardResistanceLevel();
        if (resistanceLevel <= 0) {
            return;
        }
        Integer colonyId = colony.getID();
        HashSet affectedGuards = new HashSet();
        try {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!GuardResistanceHandler.isGuardBuilding(building)) continue;
                building.getAllAssignedCitizen().forEach(citizenData -> {
                    AbstractEntityCitizen guard;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (guard = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && guard.m_6084_()) {
                        GuardResistanceHandler.applyResistanceEffect(guard, resistanceLevel);
                        affectedGuards.add(guard.m_20148_());
                    }
                });
            }
            if (((Boolean)TaxConfig.APPLY_RESISTANCE_TO_CITIZENS.get()).booleanValue()) {
                colony.getCitizenManager().getCitizens().forEach(citizenData -> {
                    AbstractEntityCitizen citizen;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (citizen = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && citizen.m_6084_() && !affectedGuards.contains(citizen.m_20148_())) {
                        GuardResistanceHandler.applyResistanceEffect(citizen, resistanceLevel);
                        affectedGuards.add(citizen.m_20148_());
                    }
                });
            }
            colonyWarGuardEffects.put(colonyId, affectedGuards);
            if (!affectedGuards.isEmpty()) {
                String entityType = (Boolean)TaxConfig.APPLY_RESISTANCE_TO_CITIZENS.get() != false ? "guards and citizens" : "guards";
                LOGGER.info("Applied Resistance {} effect to {} {} in colony '{}' during war", (Object)resistanceLevel, (Object)affectedGuards.size(), (Object)entityType, (Object)colony.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply resistance effects to guards in colony '{}' during war: {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    public static void removeResistanceFromGuardsForWar(IColony colony) {
        if (!TaxConfig.isGuardResistanceDuringRaidsEnabled()) {
            return;
        }
        Integer colonyId = colony.getID();
        Set<UUID> affectedGuards = colonyWarGuardEffects.get(colonyId);
        if (affectedGuards == null || affectedGuards.isEmpty()) {
            return;
        }
        int removedCount = 0;
        try {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!GuardResistanceHandler.isGuardBuilding(building)) continue;
                building.getAllAssignedCitizen().forEach(citizenData -> {
                    AbstractEntityCitizen guard;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (guard = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && affectedGuards.contains(guard.m_20148_())) {
                        GuardResistanceHandler.removeResistanceEffect(guard);
                    }
                });
            }
            removedCount = affectedGuards.size();
            colonyWarGuardEffects.remove(colonyId);
            if (removedCount > 0) {
                LOGGER.info("Removed Resistance effects from {} guards in colony '{}' after war", (Object)removedCount, (Object)colony.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove resistance effects from guards in colony '{}' after war: {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    public static void applyResistanceToGuardsForRaid(IColony colony) {
        if (!TaxConfig.isGuardResistanceDuringRaidsEnabled()) {
            return;
        }
        int resistanceLevel = TaxConfig.getGuardResistanceLevel();
        if (resistanceLevel <= 0) {
            return;
        }
        Integer colonyId = colony.getID();
        HashSet affectedGuards = new HashSet();
        try {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!GuardResistanceHandler.isGuardBuilding(building)) continue;
                building.getAllAssignedCitizen().forEach(citizenData -> {
                    AbstractEntityCitizen guard;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (guard = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && guard.m_6084_()) {
                        GuardResistanceHandler.applyResistanceEffect(guard, resistanceLevel);
                        affectedGuards.add(guard.m_20148_());
                    }
                });
            }
            if (((Boolean)TaxConfig.APPLY_RESISTANCE_TO_CITIZENS.get()).booleanValue()) {
                colony.getCitizenManager().getCitizens().forEach(citizenData -> {
                    AbstractEntityCitizen citizen;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (citizen = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && citizen.m_6084_() && !affectedGuards.contains(citizen.m_20148_())) {
                        GuardResistanceHandler.applyResistanceEffect(citizen, resistanceLevel);
                        affectedGuards.add(citizen.m_20148_());
                    }
                });
            }
            colonyGuardEffects.put(colonyId, affectedGuards);
            if (!affectedGuards.isEmpty()) {
                String entityType = (Boolean)TaxConfig.APPLY_RESISTANCE_TO_CITIZENS.get() != false ? "guards and citizens" : "guards";
                LOGGER.info("Applied Resistance {} effect to {} {} in colony '{}' during raid", (Object)resistanceLevel, (Object)affectedGuards.size(), (Object)entityType, (Object)colony.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to apply resistance effects to guards in colony '{}' during raid: {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    public static void removeResistanceFromGuardsForRaid(IColony colony) {
        if (!TaxConfig.isGuardResistanceDuringRaidsEnabled()) {
            return;
        }
        Integer colonyId = colony.getID();
        Set<UUID> affectedGuards = colonyGuardEffects.get(colonyId);
        if (affectedGuards == null || affectedGuards.isEmpty()) {
            return;
        }
        int removedCount = 0;
        try {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!GuardResistanceHandler.isGuardBuilding(building)) continue;
                building.getAllAssignedCitizen().forEach(citizenData -> {
                    AbstractEntityCitizen guard;
                    if (citizenData != null && citizenData.getEntity().isPresent() && (guard = (AbstractEntityCitizen)citizenData.getEntity().get()) != null && affectedGuards.contains(guard.m_20148_())) {
                        GuardResistanceHandler.removeResistanceEffect(guard);
                    }
                });
            }
            removedCount = affectedGuards.size();
            colonyGuardEffects.remove(colonyId);
            if (removedCount > 0) {
                LOGGER.info("Removed Resistance effects from {} guards in colony '{}' after raid", (Object)removedCount, (Object)colony.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to remove resistance effects from guards in colony '{}' after raid: {}", (Object)colony.getName(), (Object)e.getMessage());
        }
    }

    public static void emergencyCleanup() {
        colonyGuardEffects.clear();
        colonyWarGuardEffects.clear();
        LOGGER.info("Emergency cleanup of guard resistance effects completed");
    }

    public static int getTrackedColoniesCount() {
        return colonyGuardEffects.size() + colonyWarGuardEffects.size();
    }
}

