/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.raid;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.data.HistoryManager;
import net.machiavelli.minecolonytax.data.PlayerWarDataManager;
import net.machiavelli.minecolonytax.event.RaidLoginNotifier;
import net.machiavelli.minecolonytax.integration.SDMShopIntegration;
import net.machiavelli.minecolonytax.militia.CitizenMilitiaManager;
import net.machiavelli.minecolonytax.raid.ActiveRaidData;
import net.machiavelli.minecolonytax.raid.GuardResistanceHandler;
import net.machiavelli.minecolonytax.requirements.BuildingRequirementsManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RaidManager {
    private static final Logger LOGGER = LogManager.getLogger(RaidManager.class);
    private static final Map<UUID, ActiveRaidData> activeRaids = new HashMap<UUID, ActiveRaidData>();
    private static final Map<UUID, Long> RAID_GRACE_PERIODS = new HashMap<UUID, Long>();
    private static final Map<Integer, Integer> lastLoggedGuardCounts = new HashMap<Integer, Integer>();
    private static final Set<Action> RAID_ACTIONS = EnumSet.of(Action.TOSS_ITEM, new Action[]{Action.PICKUP_ITEM, Action.ATTACK_CITIZEN, Action.GUARDS_ATTACK, Action.FILL_BUCKET, Action.SHOOT_ARROW, Action.RIGHTCLICK_BLOCK, Action.RIGHTCLICK_ENTITY, Action.HURT_CITIZEN, Action.ATTACK_ENTITY, Action.HURT_VISITOR, Action.THROW_POTION});

    public int handleRaid(CommandContext<CommandSourceStack> context) {
        if (!WarSystem.ACTIVE_WARS.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"raid.active.error").m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!activeRaids.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"raid.already.active.error").m_130940_(ChatFormatting.RED));
            return 0;
        }
        try {
            ServerPlayer owner;
            ServerPlayer raider = ((CommandSourceStack)context.getSource()).m_81375_();
            IColony raiderColony = IColonyManager.getInstance().getColonies(raider.m_9236_()).stream().filter(c -> c.getPermissions().getOwner().equals(raider.m_20148_())).findFirst().orElseGet(() -> IColonyManager.getInstance().getColonies(raider.m_9236_()).stream().filter(c -> c.getPermissions().getPlayers().containsKey(raider.m_20148_())).findFirst().orElse(null));
            if (raiderColony == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You must belong to a colony to initiate a raid."));
                return 0;
            }
            boolean buildingRequirementsEnabled = TaxConfig.isRaidBuildingRequirementsEnabled();
            String requirementsConfig = TaxConfig.getRaidBuildingRequirements();
            LOGGER.info("=== RAID REQUIREMENTS DEBUG ===");
            LOGGER.info("Building requirements enabled: {}", (Object)buildingRequirementsEnabled);
            LOGGER.info("Requirements config: '{}'", (Object)requirementsConfig);
            LOGGER.info("Raider Colony ID: {}, Name: '{}'", (Object)raiderColony.getID(), (Object)raiderColony.getName());
            if (buildingRequirementsEnabled) {
                LOGGER.info("Using NEW building requirements system for raids");
                BuildingRequirementsManager.RequirementResult raidRequirements = BuildingRequirementsManager.checkRaidRequirements(raiderColony);
                LOGGER.info("Requirements check result: meets={}, message='{}'", (Object)raidRequirements.meetsRequirements, (Object)raidRequirements.message);
                if (!raidRequirements.meetsRequirements) {
                    LOGGER.warn("RAID BLOCKED: Requirements not met - {}", (Object)raidRequirements.message);
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Cannot initiate raid: " + raidRequirements.message)).m_130940_(ChatFormatting.RED));
                    return 0;
                }
                LOGGER.info("RAID ALLOWED: All building requirements met");
            } else {
                LOGGER.info("Using LEGACY guard count system for raids");
                int raiderGuardCount = WarSystem.countGuards(raiderColony);
                int minGuardsForRaid = TaxConfig.getMinGuardsToRaid();
                LOGGER.info("Guard count check: has={}, needs={}", (Object)raiderGuardCount, (Object)minGuardsForRaid);
                if (raiderGuardCount < minGuardsForRaid) {
                    LOGGER.warn("RAID BLOCKED: Not enough guards - has {} needs {}", (Object)raiderGuardCount, (Object)minGuardsForRaid);
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Your colony must have at least " + minGuardsForRaid + " guards to initiate a raid. (Found: " + raiderGuardCount + ")")));
                    return 0;
                }
                LOGGER.info("RAID ALLOWED: Guard count requirement met");
            }
            UUID raiderUUID = raider.m_20148_();
            String colonyName = StringArgumentType.getString(context, (String)"colony");
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            IColony colony = this.findColonyByName(colonyName, (Level)level);
            if (colony == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Colony not found!"));
                return 0;
            }
            if (!((Boolean)TaxConfig.ALLOW_OFFLINE_RAIDS.get()).booleanValue() && (owner = Objects.requireNonNull(colony.getWorld().m_7654_()).m_6846_().m_11259_(colony.getPermissions().getOwner())) == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Colony owner is offline!"));
                return 0;
            }
            if (!RaidManager.isRaiderInColony(raider, colony)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You must be inside the colony to start a raid."));
                return 0;
            }
            int targetGuards = WarSystem.countGuards(colony);
            if (TaxConfig.isRaidGuardProtectionEnabled()) {
                int targetGuardTowers = WarSystem.countGuardTowers(colony);
                int minGuardsRequired = TaxConfig.getMinGuardsToBeRaided();
                int minGuardTowersRequired = TaxConfig.getMinGuardTowersToBeRaided();
                if (targetGuards < minGuardsRequired) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"raid.protection.guards", (Object[])new Object[]{minGuardsRequired, targetGuards}).m_130940_(ChatFormatting.RED));
                    return 0;
                }
                if (targetGuardTowers < minGuardTowersRequired) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"raid.protection.guard_towers", (Object[])new Object[]{minGuardTowersRequired, targetGuardTowers}).m_130940_(ChatFormatting.RED));
                    return 0;
                }
            }
            int colonyBalance = TaxManager.getStoredTaxForColony(colony);
            int debtLimit = TaxConfig.getDebtLimit();
            if (colonyBalance < 0 && debtLimit == 0) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Cannot raid colony in debt: Debt system is disabled on this server. Colony has no tax to steal!").m_130940_(ChatFormatting.RED));
                LOGGER.info("RAID BLOCKED: Colony {} is in debt ({}) and debt system is disabled", (Object)colony.getName(), (Object)colonyBalance);
                return 0;
            }
            Long graceEnd = RAID_GRACE_PERIODS.get(raiderUUID);
            if (graceEnd != null && System.currentTimeMillis() < graceEnd) {
                long remaining = graceEnd - System.currentTimeMillis();
                String timeLeft = String.format("%d minutes %d seconds", TimeUnit.MILLISECONDS.toMinutes(remaining), TimeUnit.MILLISECONDS.toSeconds(remaining) % 60L);
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("You must wait " + timeLeft + " before raiding again!")));
                return 0;
            }
            this.sendRaidInstructions(raider, colony, targetGuards);
            if (colony.getPermissions().getOwner().equals(raiderUUID)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"You cannot raid your own colony!"));
                return 0;
            }
            colony.getPermissions().setPlayerRank(raiderUUID, colony.getPermissions().getRankHostile(), (Level)level);
            ActiveRaidData raidData = new ActiveRaidData(raiderUUID, colony);
            raidData.initializeGuardCount(targetGuards);
            raidData.snapshotOriginalGuardIds();
            raidData.setRaiderColony(raiderColony);
            activeRaids.put(raiderUUID, raidData);
            RaidManager.applyGlowEffectToRaider(raider);
            RaidManager.setRaidInteractionPermissions(colony, true);
            RaidManager.setRaidInteractionPermissions(raiderColony, true);
            GuardResistanceHandler.applyResistanceToGuardsForRaid(colony);
            CitizenMilitiaManager.getInstance().initializeColonyMilitia(colony.getID());
            if (((Boolean)TaxConfig.ENABLE_CITIZEN_MILITIA.get()).booleanValue()) {
                int militiaActivated = CitizenMilitiaManager.getInstance().activateMilitia(colony);
                this.sendColonyMessage(colony, (Component)Component.m_237113_((String)("\u2694 " + militiaActivated + " citizens have joined the militia to defend the colony!")).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
                LOGGER.info("Activated {} militia members for colony {} during raid", (Object)militiaActivated, (Object)colony.getName());
            } else {
                int existingGuards = (int)colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() != null && c.getJob().isGuard()).count();
                CitizenMilitiaManager.getInstance().setTotalDefenders(colony.getID(), existingGuards);
                CitizenMilitiaManager.getInstance().setTotalGuardsCount(colony.getID(), existingGuards);
                LOGGER.info("Militia disabled - Set total defenders for colony {} to {} guards only", (Object)colony.getName(), (Object)existingGuards);
            }
            int finalTotalDefenders = CitizenMilitiaManager.getInstance().getTotalDefenders(colony.getID());
            raider.m_213846_((Component)Component.m_237113_((String)"\ud83c\udfaf RAID PROGRESS TRACKING INITIALIZED").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)("\nTotal Defenders: " + finalTotalDefenders)).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" (Progress will update as you eliminate defenders)").m_130940_(ChatFormatting.GRAY)));
            this.startRaidCountdown(raidData);
            this.sendColonyMessage(colony, (Component)Component.m_237110_((String)"raid.alert.colony", (Object[])new Object[]{colony.getName(), raider.m_7755_().getString()}).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Raid command failed", (Throwable)e);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Raid failed: " + e.getMessage())));
            return 0;
        }
    }

    public int stopRaidCommand(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ActiveRaidData raidData = activeRaids.get(player.m_20148_());
            if (raidData == null) {
                Optional<ActiveRaidData> anyRaid = activeRaids.values().stream().findFirst();
                if (anyRaid.isPresent()) {
                    raidData = anyRaid.get();
                } else {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No active raid to stop."));
                    return 0;
                }
            }
            this.endRaid(raidData, "Stopped by operator");
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Raid stopped."), false);
            return 1;
        }
        catch (Exception e) {
            LOGGER.error("Stop raid command failed", (Throwable)e);
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to stop raid: " + e.getMessage())));
            return 0;
        }
    }

    public static ActiveRaidData getActiveRaidForPlayer(UUID playerId) {
        return activeRaids.get(playerId);
    }

    public static ActiveRaidData getActiveRaidForColony(int colonyId) {
        for (ActiveRaidData data : activeRaids.values()) {
            if (data == null || data.getColony() == null || data.getColony().getID() != colonyId || !data.isActive()) continue;
            return data;
        }
        return null;
    }

    public static void endActiveRaid(ActiveRaidData raidData, String reason) {
        ServerPlayer raiderPlayer;
        if (!raidData.isActive()) {
            return;
        }
        raidData.setActive(false);
        if (raidData.getColony() != null && raidData.getColony().getWorld() != null && raidData.getColony().getWorld().m_7654_() != null && (raiderPlayer = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider())) != null) {
            RaidManager.removeGlowEffectFromRaider(raiderPlayer);
        }
        if (raidData.getBossEvent() != null) {
            raidData.getBossEvent().m_7706_();
            raidData.getBossEvent().m_8321_(false);
        }
        GuardResistanceHandler.removeResistanceFromGuardsForRaid(raidData.getColony());
        if (((Boolean)TaxConfig.ENABLE_CITIZEN_MILITIA.get()).booleanValue()) {
            CitizenMilitiaManager.getInstance().deactivateMilitia(raidData.getColony());
            LOGGER.info("Deactivated militia for colony {} after raid ended", (Object)raidData.getColony().getName());
        }
        RaidManager.setRaidInteractionPermissions(raidData.getColony(), false);
        if (raidData.getRaiderColony() != null) {
            RaidManager.setRaidInteractionPermissions(raidData.getRaiderColony(), false);
        }
        raiderPlayer = null;
        if (raidData.getColony() != null && raidData.getColony().getWorld() != null && raidData.getColony().getWorld().m_7654_() != null) {
            raiderPlayer = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider());
        }
        if (raiderPlayer != null) {
            LOGGER.info("TAX TRANSFER CHECK - Reason: '{}', Eligible for rewards: {}", (Object)reason, (Object)raidData.isEligibleForRewards());
            LOGGER.info("TAX TRANSFER CHECK - Reason match: {}", (Object)(reason.equals("Raid completed successfully") || reason.contains("All guards eliminated") || reason.contains("All defenders eliminated") ? 1 : 0));
            if (reason.equals("Raid completed successfully") || reason.contains("All guards eliminated") || reason.contains("All defenders eliminated")) {
                if (raidData.isEligibleForRewards()) {
                    LOGGER.info("\u2705 TAX TRANSFER APPROVED - Raider: {}, Colony: {}", (Object)raiderPlayer.m_7755_().getString(), (Object)raidData.getColony().getName());
                    RaidManager.transferTaxRevenue(raidData);
                } else {
                    String denialReason = raidData.hasLeftBoundaries() ? "left colony boundaries" : "failed to kill any guards or militia";
                    MutableComponent denialMessage = Component.m_237113_((String)"\ud83d\udeab RAID FAILED! \ud83d\udeab").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"No rewards earned - you ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)denialReason).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"!").m_130940_(ChatFormatting.YELLOW));
                    raiderPlayer.m_213846_((Component)denialMessage);
                    LOGGER.info("\u274c TAX TRANSFER DENIED - Raider {} ineligible: {}", (Object)raiderPlayer.m_7755_().getString(), (Object)denialReason);
                }
            } else {
                LOGGER.info("\u274c TAX TRANSFER SKIPPED - Raid ended without victory: '{}'", (Object)reason);
            }
        } else {
            LOGGER.warn("\u274c TAX TRANSFER FAILED - Raider player not found online");
        }
        RAID_GRACE_PERIODS.put(raidData.getRaider(), System.currentTimeMillis() + RaidManager.getRaidGraceDurationMs());
        RaidLoginNotifier.recordCompletedRaid(raidData);
        activeRaids.remove(raidData.getRaider());
        LOGGER.info("Raid ended: {}", (Object)reason);
    }

    public static Map<UUID, ActiveRaidData> getActiveRaids() {
        return activeRaids;
    }

    public static void handleRaiderKilled(ActiveRaidData raidData, ServerPlayer killer) {
        IColony raiderColony;
        String currencyName;
        int colonyBalance;
        LOGGER.debug("handleRaiderKilled called for raider {}", (Object)raidData.getRaider());
        ServerPlayer raider = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider());
        if (raider == null) {
            LOGGER.debug("Raider is offline, ending raid");
            RaidManager.endActiveRaid(raidData, "Raider killed while offline");
            return;
        }
        LOGGER.debug("Processing raid kill. Raider: {}, Killer: {}", (Object)raider.m_7755_().getString(), (Object)killer.m_7755_().getString());
        RaidManager.removeGlowEffectFromRaider(raider);
        int stolenAmountToTransfer = 0;
        double currentStealPercentage = CitizenMilitiaManager.getInstance().calculateTaxPercentage(raidData.getColony().getID());
        if (currentStealPercentage > 0.0 && (stolenAmountToTransfer = (int)((double)(colonyBalance = TaxManager.getStoredTaxForColony(raidData.getColony())) * currentStealPercentage)) > 0) {
            TaxManager.incrementTaxRevenue(raidData.getColony(), stolenAmountToTransfer);
            LOGGER.info("Raider {} was killed after earning {}. Amount transferred to colony {} as defense bonus.", (Object)raider.m_7755_().getString(), (Object)stolenAmountToTransfer, (Object)raidData.getColony().getName());
        }
        double penaltyPercentage = (Double)TaxConfig.RAID_PENALTY_PERCENTAGE.get();
        double defenseRewardPercentage = (Double)TaxConfig.RAID_DEFENSE_REWARD_PERCENTAGE.get();
        LOGGER.debug("Raid penalty percentage from config: {}", (Object)penaltyPercentage);
        LOGGER.debug("Raid defense reward percentage from config: {}", (Object)defenseRewardPercentage);
        if (TaxConfig.isSDMShopConversionEnabled()) {
            currencyName = "coins";
        } else {
            String tempCurrencyName = TaxConfig.getCurrencyItemName();
            if (tempCurrencyName.contains(":")) {
                tempCurrencyName = tempCurrencyName.substring(tempCurrencyName.lastIndexOf(":") + 1);
            }
            currencyName = tempCurrencyName;
        }
        int raidPenalty = 0;
        if (TaxConfig.isSDMShopConversionEnabled()) {
            if (SDMShopIntegration.isAvailable()) {
                long raiderBalance = SDMShopIntegration.getMoney(raider);
                LOGGER.debug("Raider SDMShop balance: {}", (Object)raiderBalance);
                int computedPenalty = (int)((double)raiderBalance * penaltyPercentage);
                raidPenalty = Math.max(1, computedPenalty);
                LOGGER.debug("Computed raid penalty (with minimum 1): {}", (Object)raidPenalty);
            } else {
                LOGGER.warn("SDMShop integration is enabled in config but SDMShop mod is not available");
                raidPenalty = 1;
                LOGGER.debug("Using fallback raid penalty: {}", (Object)raidPenalty);
            }
            raidData.addToTotalTransferred(raidPenalty);
            if (raidPenalty > 0) {
                String payCmd = String.format("sdmshop pay %s %d", killer.m_7755_().getString(), raidPenalty);
                LOGGER.debug("Executing command on behalf of raider: {}", (Object)payCmd);
                try {
                    CommandSourceStack raiderSource = raider.m_20203_();
                    raider.m_20194_().m_129892_().m_230957_(raiderSource, payCmd);
                    LOGGER.debug("Successfully transferred {} from {} to {}", (Object)raidPenalty, (Object)raider.m_7755_().getString(), (Object)killer.m_7755_().getString());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to transfer funds from raider to killer", (Throwable)e);
                    try {
                        String removeCmd = String.format("sdmshop remove %s %d", raider.m_7755_().getString(), raidPenalty);
                        String addCmd = String.format("sdmshop add %s %d", killer.m_7755_().getString(), raidPenalty);
                        LOGGER.debug("Falling back to remove/add method. Executing: {}", (Object)removeCmd);
                        raidData.getColony().getWorld().m_7654_().m_129892_().m_230957_(raidData.getColony().getWorld().m_7654_().m_129893_(), removeCmd);
                        LOGGER.debug("Executing: {}", (Object)addCmd);
                        raidData.getColony().getWorld().m_7654_().m_129892_().m_230957_(raidData.getColony().getWorld().m_7654_().m_129893_(), addCmd);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Fallback method also failed", (Throwable)ex);
                    }
                }
            }
        } else {
            int baseTaxAmount = 250;
            if (TaxConfig.BUILDING_TAXES.containsKey("townhall")) {
                baseTaxAmount = (int)((Double)TaxConfig.BUILDING_TAXES.get("townhall").get() * 5.0);
            }
            raidPenalty = (int)((double)baseTaxAmount * penaltyPercentage);
            raidPenalty = Math.max(100, raidPenalty);
            LOGGER.debug("Using direct item. Base amount: {}, Penalty: {}", (Object)baseTaxAmount, (Object)raidPenalty);
            raidData.addToTotalTransferred(raidPenalty);
            raiderColony = raidData.getRaiderColony();
            if (raiderColony != null) {
                LOGGER.debug("Deducting {} from raider's colony tax balance", (Object)raidPenalty);
                TaxManager.adjustTax(raiderColony, -raidPenalty);
            } else {
                LOGGER.error("Could not deduct raid penalty: raider's colony is null");
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
            if (item != null) {
                ItemStack itemStack = new ItemStack((ItemLike)item, raidPenalty);
                boolean added = killer.m_150109_().m_36054_(itemStack);
                if (!added) {
                    killer.m_36176_(itemStack, false);
                    LOGGER.debug("Killer's inventory was full, dropped {} items near them", (Object)raidPenalty);
                } else {
                    LOGGER.debug("Successfully gave {} items to killer", (Object)raidPenalty);
                }
            } else {
                String giveCmd = String.format("give %s %s %d", killer.m_7755_().getString(), TaxConfig.getCurrencyItemName(), raidPenalty);
                LOGGER.debug("Executing command: {}", (Object)giveCmd);
                try {
                    raidData.getColony().getWorld().m_7654_().m_129892_().m_230957_(raidData.getColony().getWorld().m_7654_().m_129893_(), giveCmd);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to execute give command for raid penalty", (Throwable)e);
                }
            }
        }
        int calculatedDefenseReward = 0;
        if (defenseRewardPercentage > 0.0) {
            if (TaxConfig.isSDMShopConversionEnabled()) {
                if (SDMShopIntegration.isAvailable()) {
                    long raiderBalance = SDMShopIntegration.getMoney(raider);
                    calculatedDefenseReward = (int)((double)raiderBalance * defenseRewardPercentage);
                    LOGGER.debug("Calculated defense reward from SDMShop balance {}: {}", (Object)raiderBalance, (Object)calculatedDefenseReward);
                    if (calculatedDefenseReward > 0) {
                        if (SDMShopIntegration.setMoney(raider, raiderBalance - (long)calculatedDefenseReward)) {
                            TaxManager.incrementTaxRevenue(raidData.getColony(), calculatedDefenseReward);
                            LOGGER.info("Transferred {} defense reward from {} to colony {} main tax balance", (Object)calculatedDefenseReward, (Object)raider.m_7755_().getString(), (Object)raidData.getColony().getName());
                        } else {
                            LOGGER.error("Failed to deduct defense reward from raider's balance");
                            calculatedDefenseReward = 0;
                        }
                    }
                } else {
                    LOGGER.warn("SDMShop integration enabled but not available for defense reward calculation");
                }
            } else {
                raiderColony = raidData.getRaiderColony();
                if (raiderColony != null) {
                    int raiderColonyBalance = TaxManager.getStoredTaxForColony(raiderColony);
                    if (raiderColonyBalance > 0) {
                        calculatedDefenseReward = (int)((double)raiderColonyBalance * defenseRewardPercentage);
                        calculatedDefenseReward = Math.max(50, calculatedDefenseReward);
                        TaxManager.adjustTax(raiderColony, -calculatedDefenseReward);
                        TaxManager.incrementTaxRevenue(raidData.getColony(), calculatedDefenseReward);
                        LOGGER.info("Transferred {} defense reward from raider's colony {} to defending colony {} main tax balance", (Object)calculatedDefenseReward, (Object)raiderColony.getName(), (Object)raidData.getColony().getName());
                    } else {
                        calculatedDefenseReward = (int)(250.0 * defenseRewardPercentage);
                        calculatedDefenseReward = Math.max(25, calculatedDefenseReward);
                        TaxManager.adjustTax(raiderColony, -calculatedDefenseReward);
                        TaxManager.incrementTaxRevenue(raidData.getColony(), calculatedDefenseReward);
                        LOGGER.info("Created {} defense reward debt for raider's colony {} and credited defending colony {} main tax balance", (Object)calculatedDefenseReward, (Object)raiderColony.getName(), (Object)raidData.getColony().getName());
                    }
                } else {
                    LOGGER.warn("Could not calculate defense reward: raider's colony is null");
                }
            }
        }
        int defenseReward = calculatedDefenseReward;
        PlayerWarDataManager.incrementPlayersKilledInWar(killer);
        PlayerWarDataManager.addAmountRaided(killer, raidPenalty);
        MutableComponent message = Component.m_237113_((String)"\u2694 RAID DEFENDER VICTORY! \u2694").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true))).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"Raider ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)raider.m_7755_().getString()).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)" was killed by ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)killer.m_7755_().getString()).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)"!\n").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"Raid ended with ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(raidPenalty + " " + currencyName)).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)" transferred to the killer").m_130940_(ChatFormatting.GOLD));
        if (stolenAmountToTransfer > 0) {
            message = message.m_7220_((Component)Component.m_237113_((String)" and ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(stolenAmountToTransfer + " " + currencyName)).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)" stolen tax recovered to colony").m_130940_(ChatFormatting.GOLD));
        }
        if (defenseReward > 0) {
            message = message.m_7220_((Component)Component.m_237113_((String)" and ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(defenseReward + " " + currencyName)).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)" claimable reward added to colony balance").m_130940_(ChatFormatting.GOLD));
        }
        message = message.m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.GOLD));
        LOGGER.debug("Broadcasting raid kill message to server");
        raidData.getColony().getWorld().m_7654_().m_6846_().m_240416_((Component)message, false);
        raidData.getColony().getPermissions().getPlayers().forEach((uuid, data) -> {
            ServerPlayer colonyMember = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(uuid);
            if (colonyMember != null) {
                String titleCmd = String.format("title %s title {\"text\":\"Raid Ended!\",\"color\":\"green\",\"bold\":true}", colonyMember.m_7755_().getString());
                String subtitleCmd = defenseReward > 0 ? String.format("title %s subtitle {\"text\":\"Raider killed! +%d %s reward available\",\"color\":\"gold\"}", colonyMember.m_7755_().getString(), defenseReward, currencyName) : String.format("title %s subtitle {\"text\":\"Raider killed by %s\",\"color\":\"gold\"}", colonyMember.m_7755_().getString(), killer.m_7755_().getString());
                try {
                    raidData.getColony().getWorld().m_7654_().m_129892_().m_230957_(raidData.getColony().getWorld().m_7654_().m_129893_(), titleCmd);
                    raidData.getColony().getWorld().m_7654_().m_129892_().m_230957_(raidData.getColony().getWorld().m_7654_().m_129893_(), subtitleCmd);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to send title to colony member", (Throwable)e);
                }
            }
        });
        PlayerWarDataManager.incrementPlayersKilledInWar(killer);
        LOGGER.debug("Ending raid due to raider being killed");
        RaidManager.endActiveRaid(raidData, "Raider killed by " + killer.m_7755_().getString() + ". Penalty: " + raidPenalty + " " + currencyName);
    }

    private void startRaidCountdown(final ActiveRaidData raidData) {
        raidData.setTimerTask(new TimerTask(){

            @Override
            public void run() {
                if (raidData.getColony().getWorld() == null || raidData.getColony().getWorld().m_7654_() == null) {
                    LOGGER.warn("Raid countdown: Colony world or server is null, cancelling task for raid on colony {}", (Object)raidData.getColony().getID());
                    this.cancel();
                    RaidManager.this.endRaid(raidData, "Colony world/server became unavailable");
                    return;
                }
                raidData.getColony().getWorld().m_7654_().execute(() -> {
                    if (!raidData.isActive()) {
                        this.cancel();
                    }
                });
                if (!raidData.isActive()) {
                    return;
                }
                ServerPlayer raiderPlayer = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider());
                if (raiderPlayer == null) {
                    RaidManager.this.sendColonyMessage(raidData.getColony(), (Component)Component.m_237113_((String)"Raid stopped! Raider disconnected.").m_130940_(ChatFormatting.RED));
                    RaidManager.this.endRaid(raidData, "Raider disconnected");
                    this.cancel();
                    return;
                }
                boolean isInColony = RaidManager.isRaiderInColony(raiderPlayer, raidData.getColony());
                if (!isInColony && !raidData.hasLeftBoundaries()) {
                    raidData.markLeftBoundaries();
                    double currentStealPercentage = CitizenMilitiaManager.getInstance().calculateTaxPercentage(raidData.getColony().getID());
                    int colonyBalance = TaxManager.getStoredTaxForColony(raidData.getColony());
                    int potentialStolen = (int)((double)colonyBalance * currentStealPercentage);
                    raidData.setPotentialStolenAmount(potentialStolen);
                    MutableComponent penaltyMessage = Component.m_237113_((String)"\u26a0 RAID DISQUALIFIED! \u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"You left the colony boundaries!").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"\n").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"Potential earnings forfeited: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)String.valueOf(potentialStolen)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"RAID ENDING - You gain nothing!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                    raiderPlayer.m_213846_((Component)penaltyMessage);
                    MutableComponent defenseMessage = Component.m_237113_((String)"\ud83c\udf89 RAIDER FLED! \ud83c\udf89").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"The raider ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)raiderPlayer.m_7755_().getString()).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" left the colony boundaries and was disqualified!").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\n").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"Raid ended - Colony successfully defended!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
                    RaidManager.this.sendColonyMessage(raidData.getColony(), (Component)defenseMessage);
                    LOGGER.info("Raider {} left colony {} boundaries. Raid ended immediately. Potential earnings of {} forfeited.", (Object)raiderPlayer.m_7755_().getString(), (Object)raidData.getColony().getName(), (Object)potentialStolen);
                    RaidManager.this.endRaid(raidData, "Raider left colony boundaries and was disqualified");
                    this.cancel();
                    return;
                }
                if (raidData.getElapsedSeconds() >= RaidManager.getMaxRaidDurationSeconds()) {
                    RaidManager.this.endRaid(raidData, "Raid completed successfully");
                    this.cancel();
                    return;
                }
                raidData.setElapsedSeconds(raidData.getElapsedSeconds() + 1);
                RaidManager.updateRaidBossBar(raidData);
                if (!raidData.isWarningSent() && RaidManager.isRaiderInColony(raiderPlayer, raidData.getColony())) {
                    raidData.getColony().getPermissions().getPlayers().forEach((uuid, data) -> {
                        ServerPlayer p;
                        if (!uuid.equals(raidData.getRaider()) && (p = (ServerPlayer)raidData.getColony().getWorld().m_46003_(uuid)) != null) {
                            p.m_213846_((Component)Component.m_237113_((String)("Warning: Hostile player " + raiderPlayer.m_7755_().getString() + " has entered the colony!")).m_130940_(ChatFormatting.RED));
                        }
                    });
                    raidData.setWarningSent(true);
                }
                if (raiderPlayer != null) {
                    if (RaidManager.isRaiderInColony(raiderPlayer, raidData.getColony())) {
                        RaidManager.applyGlowEffectToRaider(raiderPlayer);
                    } else {
                        RaidManager.removeGlowEffectFromRaider(raiderPlayer);
                    }
                }
            }
        });
        new Timer().scheduleAtFixedRate(raidData.getTimerTask(), 1000L, 1000L);
    }

    public static void updateRaidBossBar(ActiveRaidData raidData) {
        if (raidData.getColony().getWorld() == null || raidData.getColony().getWorld().m_7654_() == null) {
            return;
        }
        raidData.getColony().getWorld().m_7654_().execute(() -> {
            int expectedGuards;
            if (!raidData.isActive()) {
                return;
            }
            ServerPlayer raiderPlayer = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider());
            String status = raiderPlayer == null ? "OFFLINE" : (raidData.hasLeftBoundaries() ? "DISQUALIFIED" : (!RaidManager.isRaiderInColony(raiderPlayer, raidData.getColony()) ? "LEAVING!" : "ACTIVE"));
            float progress = Math.min((float)raidData.getElapsedSeconds() / (float)RaidManager.getMaxRaidDurationSeconds(), 1.0f);
            int remainingSeconds = Math.max(RaidManager.getMaxRaidDurationSeconds() - raidData.getElapsedSeconds(), 0);
            int guardsKilled = raidData.getKilledGuardCount();
            int originalGuardCount = raidData.getOriginalGuardCount();
            if (originalGuardCount <= 0) {
                guardsKilled = CitizenMilitiaManager.getInstance().getGuardsKilledCount(raidData.getColony().getID());
                originalGuardCount = CitizenMilitiaManager.getInstance().getTotalGuardsCount(raidData.getColony().getID());
            }
            double stealPercentage = CitizenMilitiaManager.getInstance().calculateTaxPercentage(raidData.getColony().getID());
            int actualCurrentGuards = (int)raidData.getColony().getCitizenManager().getCitizens().stream().filter(c -> c.getJob() != null && c.getJob().isGuard()).count();
            if (actualCurrentGuards < (expectedGuards = originalGuardCount - guardsKilled)) {
                int missedGuardDeaths = expectedGuards - actualCurrentGuards;
                LOGGER.warn("GUARD RECONCILIATION: {} guards died without detection! Updating count...", (Object)missedGuardDeaths);
                for (int i = 0; i < missedGuardDeaths; ++i) {
                    CitizenMilitiaManager.getInstance().recordDefenderDeath(raidData.getColony(), true);
                }
                guardsKilled = CitizenMilitiaManager.getInstance().getGuardsKilledCount(raidData.getColony().getID());
                LOGGER.info("RECONCILIATION COMPLETE: Guards killed updated to {}/{}", (Object)guardsKilled, (Object)originalGuardCount);
                if (guardsKilled >= originalGuardCount) {
                    LOGGER.info("RAID VICTORY after reconciliation! All {} guards eliminated", (Object)originalGuardCount);
                    LOGGER.info("TAX TRANSFER DEBUG: Ending raid with reason 'All guards eliminated - Raiders victorious!'");
                    RaidManager.endActiveRaid(raidData, "All guards eliminated - Raiders victorious!");
                    return;
                }
            }
            double victoryProgress = originalGuardCount > 0 ? (double)guardsKilled / (double)originalGuardCount : 0.0;
            MutableComponent name = Component.m_237113_((String)String.format("Raid: %s | Guards Killed: %d/%d | Victory: %.1f%% | Tax: %.1f%% | Time: %02d:%02d", status, guardsKilled, originalGuardCount, victoryProgress * 100.0, stealPercentage * 100.0, remainingSeconds / 60, remainingSeconds % 60));
            int colonyId = raidData.getColony().getID();
            int lastLogged = lastLoggedGuardCounts.getOrDefault(colonyId, 0);
            if (guardsKilled > 0 && (remainingSeconds % 30 == 0 || guardsKilled != lastLogged)) {
                LOGGER.info("RAID PROGRESS: Guards {}/{}, Victory {:.0f}%, Tax {:.0f}%, Time {}:{:02d}", (Object)guardsKilled, (Object)originalGuardCount, (Object)(victoryProgress * 100.0), (Object)(stealPercentage * 100.0), (Object)(remainingSeconds / 60), (Object)(remainingSeconds % 60));
                lastLoggedGuardCounts.put(colonyId, guardsKilled);
            }
            raidData.getBossEvent().m_6456_((Component)name);
            raidData.getBossEvent().m_142711_(progress);
            if (raidData.hasLeftBoundaries()) {
                raidData.getBossEvent().m_6451_(BossEvent.BossBarColor.RED);
            } else if (guardsKilled > 0) {
                raidData.getBossEvent().m_6451_(BossEvent.BossBarColor.YELLOW);
            } else {
                raidData.getBossEvent().m_6451_(BossEvent.BossBarColor.WHITE);
            }
        });
    }

    private static boolean isRaiderInColony(ServerPlayer raider, IColony colony) {
        if (raider == null || colony == null || colony.getWorld() == null) {
            return false;
        }
        BlockPos raiderPos = raider.m_20183_();
        return colony.isCoordInColony(colony.getWorld(), raiderPos);
    }

    private void endRaid(ActiveRaidData raidData, String reason) {
        ServerPlayer offlinePlayer;
        ServerPlayer raiderPlayer;
        if (!raidData.isActive()) {
            return;
        }
        raidData.setActive(false);
        if (raidData.getColony() != null && raidData.getColony().getWorld() != null && raidData.getColony().getWorld().m_7654_() != null && (raiderPlayer = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider())) != null) {
            RaidManager.removeGlowEffectFromRaider(raiderPlayer);
        }
        if (raidData.getBossEvent() != null) {
            raidData.getBossEvent().m_7706_();
            raidData.getBossEvent().m_8321_(false);
        }
        GuardResistanceHandler.removeResistanceFromGuardsForRaid(raidData.getColony());
        if (((Boolean)TaxConfig.ENABLE_CITIZEN_MILITIA.get()).booleanValue()) {
            CitizenMilitiaManager.getInstance().deactivateMilitia(raidData.getColony());
            LOGGER.info("Deactivated militia for colony {} after raid ended", (Object)raidData.getColony().getName());
        }
        RaidManager.setRaidInteractionPermissions(raidData.getColony(), false);
        if (raidData.getRaiderColony() != null) {
            RaidManager.setRaidInteractionPermissions(raidData.getRaiderColony(), false);
        }
        RAID_GRACE_PERIODS.put(raidData.getRaider(), System.currentTimeMillis() + RaidManager.getRaidGraceDurationMs());
        RaidLoginNotifier.recordCompletedRaid(raidData);
        activeRaids.remove(raidData.getRaider());
        MutableComponent raidEndMsgToColony = Component.m_237115_((String)"raid.end.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)"\n").m_7220_((Component)Component.m_237110_((String)"raid.end.colony.body", (Object[])new Object[]{reason}).m_130940_(ChatFormatting.YELLOW))).m_7220_((Component)Component.m_237113_((String)"\n----------------------------------------").m_130940_(ChatFormatting.DARK_GRAY));
        this.sendColonyMessageExcluding(raidData.getColony(), (Component)raidEndMsgToColony, raidData.getRaider());
        ServerPlayer raiderPlayer2 = null;
        if (raidData.getColony() != null && raidData.getColony().getWorld() != null && raidData.getColony().getWorld().m_7654_() != null) {
            raiderPlayer2 = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider());
        }
        if (raiderPlayer2 != null) {
            LOGGER.info("TAX TRANSFER CHECK - Reason: '{}', Eligible for rewards: {}", (Object)reason, (Object)raidData.isEligibleForRewards());
            LOGGER.info("TAX TRANSFER CHECK - Reason match: {}", (Object)(reason.equals("Raid completed successfully") || reason.contains("All guards eliminated") || reason.contains("All defenders eliminated") ? 1 : 0));
            if (reason.equals("Raid completed successfully") || reason.contains("All guards eliminated") || reason.contains("All defenders eliminated")) {
                if (raidData.isEligibleForRewards() || reason.contains("All guards eliminated") || reason.equals("Raid completed successfully")) {
                    LOGGER.info("\u2705 TAX TRANSFER APPROVED - Raider: {}, Colony: {}", (Object)raiderPlayer2.m_7755_().getString(), (Object)raidData.getColony().getName());
                    RaidManager.transferTaxRevenue(raidData);
                } else {
                    String denialReason = raidData.hasLeftBoundaries() ? "left colony boundaries" : "failed to kill any guards or militia";
                    MutableComponent denialMessage = Component.m_237113_((String)"\ud83d\udeab RAID FAILED! \ud83d\udeab").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"No rewards earned - you ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)denialReason).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"!").m_130940_(ChatFormatting.YELLOW));
                    raiderPlayer2.m_213846_((Component)denialMessage);
                    LOGGER.info("Raider {} completed raid timer but received no rewards - {}", (Object)raiderPlayer2.m_7755_().getString(), (Object)denialReason);
                }
            } else {
                LOGGER.info("\u274c TAX TRANSFER SKIPPED - Raid ended without victory: '{}'", (Object)reason);
            }
        } else {
            LOGGER.warn("\u274c TAX TRANSFER FAILED - Raider player not found online");
        }
        UUID raiderUUID = raidData.getRaider();
        String raiderNameFinal = raiderUUID.toString();
        if (raiderPlayer2 != null) {
            raiderNameFinal = raiderPlayer2.m_7755_().getString();
        } else if (raidData.getColony() != null && raidData.getColony().getWorld() != null && raidData.getColony().getWorld().m_7654_() != null && (offlinePlayer = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raiderUUID)) != null) {
            raiderNameFinal = offlinePlayer.m_7755_().getString();
        }
        String eventString = String.format("[RAID] Colony '%s' was raided by '%s'. Outcome: %s. Amount transferred: %d.", raidData.getColony().getName(), raiderNameFinal, reason, raidData.getTotalTransferred());
        HistoryManager.getColonyHistory(raidData.getColony().getID()).addEvent(eventString);
        HistoryManager.saveHistory();
        if (raidData.getTimerTask() != null) {
            raidData.getTimerTask().cancel();
        }
    }

    private IColony findColonyByName(String name, Level level) {
        return IColonyManager.getInstance().getColonies(level).stream().filter(c -> c.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static void setRaidInteractionPermissions(IColony colony, boolean allowed) {
        if (!((Boolean)TaxConfig.ENABLE_WAR_ACTIONS.get()).booleanValue()) {
            return;
        }
        IPermissions perms = colony.getPermissions();
        Rank hostile = perms.getRankHostile();
        for (Action a : RAID_ACTIONS) {
            perms.setPermission(hostile, a, allowed);
        }
    }

    private void sendColonyMessage(IColony colony, Component message) {
        if (colony == null || colony.getWorld() == null) {
            return;
        }
        colony.getPermissions().getPlayers().forEach((uuid, data) -> {
            ServerPlayer p = (ServerPlayer)colony.getWorld().m_46003_(uuid);
            if (p != null) {
                p.m_213846_(message);
            }
        });
    }

    private void sendColonyMessageExcluding(IColony colony, Component message, UUID excludePlayer) {
        if (colony == null || colony.getWorld() == null) {
            return;
        }
        colony.getPermissions().getPlayers().forEach((uuid, data) -> {
            ServerPlayer p;
            if (!uuid.equals(excludePlayer) && (p = (ServerPlayer)colony.getWorld().m_46003_(uuid)) != null) {
                p.m_213846_(message);
            }
        });
    }

    private static int getMaxRaidDurationSeconds() {
        return (Integer)TaxConfig.MAX_RAID_DURATION_MINUTES.get() * 60;
    }

    private int getTaxInterval() {
        return (Integer)TaxConfig.RAID_TAX_INTERVAL_SECONDS.get();
    }

    private double[] getTaxPercentages() {
        return ((List)TaxConfig.RAID_TAX_PERCENTAGES.get()).stream().mapToDouble(Double::doubleValue).toArray();
    }

    private static long getRaidGraceDurationMs() {
        return TimeUnit.MINUTES.toMillis(((Integer)TaxConfig.RAID_GRACE_PERIOD_MINUTES.get()).intValue());
    }

    public static ServerPlayer getServerPlayerById(UUID playerId) {
        if (playerId == null) {
            return null;
        }
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                return server.m_6846_().m_11259_(playerId);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get player by UUID {}: {}", (Object)playerId, (Object)e.getMessage());
        }
        return null;
    }

    public static boolean isColonyUnderRaid(int colonyId) {
        for (ActiveRaidData raidData : activeRaids.values()) {
            if (raidData.getColony().getID() != colonyId || !raidData.isActive()) continue;
            return true;
        }
        return false;
    }

    private static void transferTaxRevenue(ActiveRaidData raidData) {
        double finalPercentage;
        ServerPlayer raiderPlayer = raidData.getColony().getWorld().m_7654_().m_6846_().m_11259_(raidData.getRaider());
        if (raiderPlayer == null) {
            LOGGER.warn("Raider is offline, skipping revenue transfer for raid on {}", (Object)raidData.getColony().getName());
            return;
        }
        LOGGER.info("Starting tax revenue transfer for raider {} on colony {}", (Object)raiderPlayer.m_7755_().getString(), (Object)raidData.getColony().getName());
        LOGGER.info("Tax steal config: TAX_STEAL_PER_GUARD_KILLED = {}", TaxConfig.TAX_STEAL_PER_GUARD_KILLED.get());
        if (((Boolean)TaxConfig.TAX_STEAL_PER_GUARD_KILLED.get()).booleanValue()) {
            finalPercentage = CitizenMilitiaManager.getInstance().calculateTaxPercentage(raidData.getColony().getID());
            LOGGER.info("Calculated tax percentage based on kills: {}%", (Object)(finalPercentage * 100.0));
            if (finalPercentage == 0.0) {
                LOGGER.warn("No guards/militia killed during raid, no tax stolen for raid on {}", (Object)raidData.getColony().getName());
                return;
            }
            int guardsKilled = CitizenMilitiaManager.getInstance().getGuardsKilled(raidData.getColony().getID());
            int totalDefenders = CitizenMilitiaManager.getInstance().getTotalDefenders(raidData.getColony().getID());
            double maxTaxPercentage = (Double)TaxConfig.MAX_RAID_TAX_PERCENTAGE.get();
            LOGGER.info("Balanced tax calculation - Guards/militia killed: {}/{} defenders, Max tax: {}%, Final rate: {}%", (Object)guardsKilled, (Object)totalDefenders, (Object)(maxTaxPercentage * 100.0), (Object)(finalPercentage * 100.0));
        } else {
            if (raidData.getGuardsKilled() == 0) {
                LOGGER.debug("No guards killed during raid, skipping revenue transfer for raid on {}", (Object)raidData.getColony().getName());
                return;
            }
            int raidDuration = raidData.getElapsedSeconds();
            int taxInterval = (Integer)TaxConfig.RAID_TAX_INTERVAL_SECONDS.get();
            double[] taxPercentages = ((List)TaxConfig.RAID_TAX_PERCENTAGES.get()).stream().mapToDouble(Double::doubleValue).toArray();
            int intervalsPassed = Math.min(raidDuration / taxInterval, taxPercentages.length);
            double totalBasePercentage = 0.0;
            for (int i = 0; i < intervalsPassed; ++i) {
                totalBasePercentage += taxPercentages[Math.min(i, taxPercentages.length - 1)];
            }
            double guardKillPercentage = raidData.getGuardKillPercentage();
            finalPercentage = totalBasePercentage * guardKillPercentage;
            LOGGER.info("Time-based tax calculation - Guards killed: {}/{} ({}%), Total base rate: {}%, Final rate: {}%", (Object)raidData.getGuardsKilled(), (Object)raidData.getTotalGuards(), (Object)(guardKillPercentage * 100.0), (Object)(totalBasePercentage * 100.0), (Object)(finalPercentage * 100.0));
        }
        int colonyBalance = TaxManager.getStoredTaxForColony(raidData.getColony());
        LOGGER.info("\ud83d\udcb0 TAX CALCULATION DEBUG: Colony balance={}, Percentage={:.1f}%", (Object)colonyBalance, (Object)(finalPercentage * 100.0));
        int amountToDeduct = 0;
        if (colonyBalance > 0) {
            amountToDeduct = (int)((double)colonyBalance * finalPercentage);
            LOGGER.info("\ud83d\udcb0 POSITIVE BALANCE: Stealing {} from colony {} ({}% of {})", (Object)amountToDeduct, (Object)raidData.getColony().getName(), (Object)(finalPercentage * 100.0), (Object)colonyBalance);
        } else if (colonyBalance <= 0) {
            int debtLimit = TaxConfig.getDebtLimit();
            if (debtLimit > 0) {
                int guardsKilled = CitizenMilitiaManager.getInstance().getGuardsKilled(raidData.getColony().getID());
                int taxStealPerGuard = TaxConfig.getTaxStealPerGuard();
                int baseAmount = guardsKilled * taxStealPerGuard;
                int currentDebt = Math.abs(colonyBalance);
                if (currentDebt < debtLimit) {
                    int availableDebt = debtLimit - currentDebt;
                    amountToDeduct = Math.min(baseAmount, availableDebt);
                    LOGGER.info("\ud83d\udcb0 DEBT COLONY: Guards killed={}, Per-guard steal={}, Base amount={}, Current debt={}, Debt limit={}, Final debt to add={}", (Object)guardsKilled, (Object)taxStealPerGuard, (Object)baseAmount, (Object)currentDebt, (Object)debtLimit, (Object)amountToDeduct);
                } else {
                    LOGGER.info("\ud83d\udcb0 DEBT LIMIT REACHED: Colony {} already at debt limit (debt: {}, limit: {})", (Object)raidData.getColony().getName(), (Object)currentDebt, (Object)debtLimit);
                }
            } else {
                LOGGER.info("\ud83d\udcb0 NO LOOT: Colony {} is in debt ({}) and debt creation is disabled", (Object)raidData.getColony().getName(), (Object)colonyBalance);
            }
        }
        LOGGER.info("\ud83d\udcb0 FINAL CALCULATION: Colony balance={}, Final amount to transfer={}", (Object)colonyBalance, (Object)amountToDeduct);
        if (amountToDeduct > 0) {
            TaxManager.payTaxDebt(raidData.getColony(), -amountToDeduct);
            if (colonyBalance > 0) {
                LOGGER.info("\ud83d\udcb0 STOLEN: Deducted {} from colony {} positive balance", (Object)amountToDeduct, (Object)raidData.getColony().getName());
            } else {
                LOGGER.info("\ud83d\udcb0 DEBT CREATED: Added {} debt to colony {}", (Object)amountToDeduct, (Object)raidData.getColony().getName());
            }
        } else {
            LOGGER.info("\ud83d\udcb0 NO TRANSFER: No tax to steal from colony {} (balance: {})", (Object)raidData.getColony().getName(), (Object)colonyBalance);
            if (colonyBalance <= 0 && TaxConfig.getDebtLimit() == 0) {
                raiderPlayer.m_213846_((Component)Component.m_237113_((String)"\u26a0\ufe0f No loot obtained: Colony is in debt and debt system is disabled on this server!").m_130940_(ChatFormatting.YELLOW));
            } else if (colonyBalance <= 0) {
                int guardsKilled = CitizenMilitiaManager.getInstance().getGuardsKilled(raidData.getColony().getID());
                if (guardsKilled == 0) {
                    raiderPlayer.m_213846_((Component)Component.m_237113_((String)("\u26a0\ufe0f No loot obtained: Colony is in debt - kill guards to earn " + TaxConfig.getTaxStealPerGuard() + " per guard!")).m_130940_(ChatFormatting.YELLOW));
                } else {
                    raiderPlayer.m_213846_((Component)Component.m_237113_((String)"\u26a0\ufe0f No loot obtained: Colony has reached its debt limit!").m_130940_(ChatFormatting.YELLOW));
                }
            } else {
                raiderPlayer.m_213846_((Component)Component.m_237113_((String)"\u26a0\ufe0f No loot obtained: No tax available to steal!").m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (amountToDeduct > 0) {
            try {
                String currencyName;
                if (TaxConfig.isSDMShopConversionEnabled()) {
                    if (SDMShopIntegration.isAvailable()) {
                        long currentBalance = SDMShopIntegration.getMoney(raiderPlayer);
                        if (SDMShopIntegration.setMoney(raiderPlayer, currentBalance + (long)amountToDeduct)) {
                            LOGGER.info("Raid completion: Added {} currency to player {} via SDMShop API (new balance: {})", (Object)amountToDeduct, (Object)raiderPlayer.m_7755_().getString(), (Object)(currentBalance + (long)amountToDeduct));
                        } else {
                            LOGGER.error("Failed to transfer {} currency to player {} via SDMShop API", (Object)amountToDeduct, (Object)raiderPlayer.m_7755_().getString());
                        }
                    } else {
                        LOGGER.warn("SDMShop integration is enabled but SDMShop mod is not available. Currency transfer skipped for player: {}", (Object)raiderPlayer.m_7755_().getString());
                    }
                } else {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(TaxConfig.getCurrencyItemName()));
                    if (item != null) {
                        ItemStack itemStack = new ItemStack((ItemLike)item, amountToDeduct);
                        boolean added = raiderPlayer.m_150109_().m_36054_(itemStack);
                        if (!added) {
                            raiderPlayer.m_36176_(itemStack, false);
                            LOGGER.info("Raid completion: Raider's inventory was full, dropped {} items near them", (Object)amountToDeduct);
                        } else {
                            LOGGER.info("Raid completion: Gave {} {} items to player {}", (Object)amountToDeduct, (Object)TaxConfig.getCurrencyItemName(), (Object)raiderPlayer.m_7755_().getString());
                        }
                    } else {
                        String itemName = TaxConfig.getCurrencyItemName();
                        String command = String.format("give %s %s %d", raiderPlayer.m_7755_().getString(), itemName, amountToDeduct);
                        raidData.getColony().getWorld().m_7654_().m_129892_().m_230957_(raidData.getColony().getWorld().m_7654_().m_129893_(), command);
                        LOGGER.info("Raid completion: Gave {} {} items to player {} (via command)", (Object)amountToDeduct, (Object)itemName, (Object)raiderPlayer.m_7755_().getString());
                    }
                }
                raidData.addToTotalTransferred(amountToDeduct);
                if (TaxConfig.isSDMShopConversionEnabled()) {
                    currencyName = "Coins";
                } else {
                    currencyName = TaxConfig.getCurrencyItemName();
                    if (currencyName.contains(":")) {
                        currencyName = currencyName.substring(currencyName.indexOf(":") + 1);
                    }
                }
                MutableComponent taxMessage = Component.m_237113_((String)("\u2694 RAID COMPLETED! \u2694\n" + raidData.getColony().getName() + " lost " + amountToDeduct + " " + currencyName + " to raider " + raiderPlayer.m_7755_().getString() + "!")).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
                HashSet playersToNotify = new HashSet();
                raidData.getColony().getPermissions().getPlayers().forEach((uuid, data) -> {
                    ServerPlayer p = (ServerPlayer)raidData.getColony().getWorld().m_46003_(uuid);
                    if (p != null) {
                        playersToNotify.add(p);
                    }
                });
                if (raidData.getRaiderColony() != null && !raidData.getRaiderColony().equals(raidData.getColony())) {
                    raidData.getRaiderColony().getPermissions().getPlayers().forEach((uuid, data) -> {
                        ServerPlayer p = (ServerPlayer)raidData.getRaiderColony().getWorld().m_46003_(uuid);
                        if (p != null) {
                            playersToNotify.add(p);
                        }
                    });
                }
                for (ServerPlayer player : playersToNotify) {
                    player.m_213846_((Component)taxMessage);
                }
                LOGGER.info("Raid completion tax transfer: {} {} from {} to {}", (Object)amountToDeduct, (Object)currencyName, (Object)raidData.getColony().getName(), (Object)raiderPlayer.m_7755_().getString());
            }
            catch (Exception e) {
                LOGGER.error("Error processing raid completion tax transfer: ", (Throwable)e);
            }
        }
    }

    private static void applyGlowEffectToRaider(ServerPlayer raider) {
        if (raider != null && !raider.m_21023_(MobEffects.f_19619_)) {
            MobEffectInstance glowEffect = new MobEffectInstance(MobEffects.f_19619_, 1400, 0, false, true, true);
            raider.m_7292_(glowEffect);
            LOGGER.debug("Applied GLOW effect to raider: {}", (Object)raider.m_7755_().getString());
        }
    }

    private void sendRaidInstructions(ServerPlayer raider, IColony colony, int totalDefenders) {
        String currencyName = RaidManager.getCurrencyName();
        int colonyBalance = TaxManager.getStoredTaxForColony(colony);
        int maxRaidDuration = RaidManager.getMaxRaidDurationSeconds();
        double maxTaxPercentage = (Double)TaxConfig.MAX_RAID_TAX_PERCENTAGE.get();
        int militiaCount = 0;
        if (((Boolean)TaxConfig.ENABLE_CITIZEN_MILITIA.get()).booleanValue()) {
            militiaCount = CitizenMilitiaManager.getInstance().getMilitiaCount(colony.getID());
        }
        MutableComponent instructions = Component.m_237113_((String)"\u2694 RAID INITIATED \u2694").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"TARGET: ").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)colony.getName()).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"OBJECTIVE: ").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"Kill guards/militia to steal tax revenue").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"TIME LIMIT: ").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)String.format("%d:%02d minutes", maxRaidDuration / 60, maxRaidDuration % 60)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"\n\n")).m_7220_((Component)Component.m_237113_((String)"\u26a1 COLONY STATUS \u26a1").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 Guards: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)String.valueOf(totalDefenders - militiaCount)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 Militia: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)String.valueOf(militiaCount)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 Tax Balance: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)(colonyBalance + " " + currencyName)).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 Max Steal: ").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)String.format("%.1f%% (%d %s)", maxTaxPercentage * 100.0, (int)((double)colonyBalance * maxTaxPercentage), currencyName)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n\n")).m_7220_((Component)Component.m_237113_((String)"\u26a0 CRITICAL RULES \u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 STAY IN BOUNDARIES: ").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"Leaving colony = INSTANT DISQUALIFICATION").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 DEATH PENALTY: ").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"Death = Colony gets your potential earnings").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 KILL REQUIREMENT: ").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_7220_((Component)Component.m_237113_((String)"No kills = No reward").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237113_((String)"Good luck, raider! Watch the boss bar for your progress.").m_130940_(ChatFormatting.GREEN));
        raider.m_213846_((Component)instructions);
        try {
            String titleCmd = String.format("title %s title {\"text\":\"RAID STARTED\",\"color\":\"red\",\"bold\":true}", raider.m_7755_().getString());
            String subtitleCmd = String.format("title %s subtitle {\"text\":\"Kill %d defenders \u2022 Stay in boundaries!\",\"color\":\"yellow\"}", raider.m_7755_().getString(), totalDefenders);
            raider.m_20194_().m_129892_().m_230957_(raider.m_20194_().m_129893_(), titleCmd);
            raider.m_20194_().m_129892_().m_230957_(raider.m_20194_().m_129893_(), subtitleCmd);
        }
        catch (Exception e) {
            LOGGER.error("Failed to send raid start title to raider", (Throwable)e);
        }
        LOGGER.info("Sent comprehensive raid instructions to raider {} for colony {}", (Object)raider.m_7755_().getString(), (Object)colony.getName());
    }

    private static String getCurrencyName() {
        if (TaxConfig.isSDMShopConversionEnabled()) {
            return "$";
        }
        return "coins";
    }

    public static void removeGlowEffectFromRaider(ServerPlayer raider) {
        if (raider != null) {
            raider.m_21195_(MobEffects.f_19619_);
            LOGGER.debug("Removed GLOW effect from raider: {}", (Object)raider.m_7755_().getString());
        }
    }

    public static ActiveRaidData getActiveRaidByColony(int colonyId) {
        return activeRaids.values().stream().filter(raid -> raid.getColony().getID() == colonyId).findFirst().orElse(null);
    }

    public static boolean isPlayerCurrentlyRaiding(UUID playerUUID, IColony colony) {
        if (playerUUID == null || colony == null) {
            return false;
        }
        ActiveRaidData raidData = activeRaids.get(playerUUID);
        return raidData != null && raidData.isActive() && raidData.getColony().getID() == colony.getID();
    }
}

