/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.raid;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecruitmentTracker {
    private static final Logger LOGGER = LogManager.getLogger(RecruitmentTracker.class);
    private static final ConcurrentMap<UUID, Long> recruitmentTimes = new ConcurrentHashMap<UUID, Long>();
    private static final long CLEANUP_THRESHOLD_MS = 30000L;
    private static long lastCleanupTime = System.currentTimeMillis();

    public static void recordRecruitment(UUID entityUUID) {
        if (entityUUID != null) {
            long currentTime = System.currentTimeMillis();
            recruitmentTimes.put(entityUUID, currentTime);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recorded recruitment time for entity {}: {}", (Object)(entityUUID.toString().substring(0, 8) + "..."), (Object)currentTime);
            }
        }
    }

    public static Long getRecruitmentTime(UUID entityUUID) {
        if (entityUUID == null) {
            return null;
        }
        RecruitmentTracker.performPeriodicCleanup();
        return (Long)recruitmentTimes.get(entityUUID);
    }

    public static boolean isRecentlyRecruited(UUID entityUUID, long gracePeriodMs) {
        Long recruitmentTime = RecruitmentTracker.getRecruitmentTime(entityUUID);
        if (recruitmentTime == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long timeSinceRecruitment = currentTime - recruitmentTime;
        return timeSinceRecruitment < gracePeriodMs;
    }

    public static void removeTracking(UUID entityUUID) {
        if (entityUUID != null) {
            recruitmentTimes.remove(entityUUID);
        }
    }

    private static void performPeriodicCleanup() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCleanupTime < 30000L) {
            return;
        }
        lastCleanupTime = currentTime;
        recruitmentTimes.entrySet().removeIf(entry -> {
            long age = currentTime - (Long)entry.getValue();
            return age > 30000L;
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Performed recruitment tracker cleanup. Remaining entries: {}", (Object)recruitmentTimes.size());
        }
    }

    public static int getTrackedEntityCount() {
        RecruitmentTracker.performPeriodicCleanup();
        return recruitmentTimes.size();
    }

    public static void clearAll() {
        recruitmentTimes.clear();
        LOGGER.info("Cleared all recruitment tracking data");
    }
}

