/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.raid;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.raid.EntityRaidDebugLogger;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.scores.Team;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionCache {
    private static final Logger LOGGER = LogManager.getLogger(ReflectionCache.class);
    private static Method isAllyMethod;
    private static Method canHarmTeamMethod;
    private static Method getOwnerUUIDMethod;
    private static Method isOwnedMethod;
    private static Method getCreationTimeMethod;
    private static Method getTeamMethod;
    private static Method isEnemyMethod;
    private static Method canAttackMethod;
    private static Method getOwnerMethod;
    private static Method hasOwnerMethod;
    private static final Map<String, Method> dynamicMethodCache;
    private static boolean initialized;
    private static boolean recruitsModAvailable;
    private static boolean recruitsEventsAvailable;
    private static boolean abstractRecruitEntityAvailable;
    private static final String[] RECRUIT_EVENT_CLASS_NAMES;
    private static final String[] RECRUIT_ENTITY_CLASS_NAMES;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        long startTime = System.currentTimeMillis();
        EntityRaidDebugLogger.logReflectionCall("initialize", "ReflectionCache", true, "Starting enhanced reflection cache initialization");
        ReflectionCache.initializeRecruitEventsClass();
        ReflectionCache.initializeRecruitEntityClass();
        recruitsModAvailable = recruitsEventsAvailable || abstractRecruitEntityAvailable;
        long duration = System.currentTimeMillis() - startTime;
        if (recruitsModAvailable) {
            LOGGER.info("ReflectionCache initialized successfully in {}ms - Recruits mod integration available (Events: {}, Entities: {})", (Object)duration, (Object)recruitsEventsAvailable, (Object)abstractRecruitEntityAvailable);
        } else {
            LOGGER.info("ReflectionCache initialized in {}ms - Recruits mod not available, using fallback methods", (Object)duration);
        }
        initialized = true;
    }

    private static void initializeRecruitEventsClass() {
        Class<?> recruitEventsClass = null;
        for (String className : RECRUIT_EVENT_CLASS_NAMES) {
            try {
                recruitEventsClass = Class.forName(className);
                EntityRaidDebugLogger.logReflectionCall("Class.forName", className, true, "RecruitEvents class found");
                break;
            }
            catch (ClassNotFoundException e) {
                EntityRaidDebugLogger.logReflectionCall("Class.forName", className, false, "Class not found");
            }
        }
        if (recruitEventsClass == null) {
            EntityRaidDebugLogger.logReflectionCall("RecruitEvents", "all variants", false, "No RecruitEvents class found");
            return;
        }
        recruitsEventsAvailable = true;
        ReflectionCache.cacheAllianceMethod(recruitEventsClass, "isAlly", new Class[]{Team.class, Team.class});
        ReflectionCache.cacheAllianceMethod(recruitEventsClass, "areAllies", new Class[]{Team.class, Team.class});
        ReflectionCache.cacheAllianceMethod(recruitEventsClass, "isTeamAlly", new Class[]{Team.class, Team.class});
        ReflectionCache.cacheHarmMethod(recruitEventsClass, "canHarmTeam", new Class[]{LivingEntity.class, LivingEntity.class});
        ReflectionCache.cacheHarmMethod(recruitEventsClass, "canAttack", new Class[]{LivingEntity.class, LivingEntity.class});
        ReflectionCache.cacheHarmMethod(recruitEventsClass, "canHarm", new Class[]{LivingEntity.class, LivingEntity.class});
        ReflectionCache.cacheAdditionalMethod(recruitEventsClass, "isEnemy", new Class[]{Team.class, Team.class});
        ReflectionCache.cacheAdditionalMethod(recruitEventsClass, "getTeam", new Class[]{LivingEntity.class});
    }

    private static void initializeRecruitEntityClass() {
        Class<?> recruitEntityClass = null;
        for (String className : RECRUIT_ENTITY_CLASS_NAMES) {
            try {
                recruitEntityClass = Class.forName(className);
                EntityRaidDebugLogger.logReflectionCall("Class.forName", className, true, "Recruit entity class found");
                break;
            }
            catch (ClassNotFoundException e) {
                EntityRaidDebugLogger.logReflectionCall("Class.forName", className, false, "Class not found");
            }
        }
        if (recruitEntityClass == null) {
            EntityRaidDebugLogger.logReflectionCall("RecruitEntity", "all variants", false, "No recruit entity class found");
            return;
        }
        abstractRecruitEntityAvailable = true;
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "getOwnerUUID", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "getOwner", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "getOwnerID", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "isOwned", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "hasOwner", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "getCreationTime", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "getSpawnTime", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "getBirthTime", new Class[0]);
        ReflectionCache.cacheEntityMethod(recruitEntityClass, "getTeam", new Class[0]);
    }

    private static void cacheAllianceMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            Method method = clazz.getMethod(methodName, paramTypes);
            if (isAllyMethod == null) {
                isAllyMethod = method;
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Primary alliance method cached");
            } else {
                dynamicMethodCache.put("alliance_" + methodName, method);
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Fallback alliance method cached");
            }
        }
        catch (NoSuchMethodException e) {
            EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), false, "Method not found");
        }
    }

    private static void cacheHarmMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            Method method = clazz.getMethod(methodName, paramTypes);
            if (canHarmTeamMethod == null) {
                canHarmTeamMethod = method;
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Primary harm method cached");
            } else {
                dynamicMethodCache.put("harm_" + methodName, method);
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Fallback harm method cached");
            }
        }
        catch (NoSuchMethodException e) {
            EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), false, "Method not found");
        }
    }

    private static void cacheAdditionalMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            Method method = clazz.getMethod(methodName, paramTypes);
            dynamicMethodCache.put("additional_" + methodName, method);
            EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Additional method cached");
        }
        catch (NoSuchMethodException e) {
            EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), false, "Method not found");
        }
    }

    private static void cacheEntityMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            Method method = clazz.getMethod(methodName, paramTypes);
            if (methodName.contains("Owner") && methodName.contains("UUID") && getOwnerUUIDMethod == null) {
                getOwnerUUIDMethod = method;
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Primary owner UUID method cached");
            } else if (methodName.contains("Owner") && !methodName.contains("UUID") && getOwnerMethod == null) {
                getOwnerMethod = method;
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Primary owner method cached");
            } else if ((methodName.equals("isOwned") || methodName.equals("hasOwner")) && isOwnedMethod == null) {
                isOwnedMethod = method;
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Primary ownership check method cached");
            } else if (methodName.contains("Time") && getCreationTimeMethod == null) {
                getCreationTimeMethod = method;
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Primary time method cached");
            } else if (methodName.equals("getTeam") && getTeamMethod == null) {
                getTeamMethod = method;
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Primary team method cached");
            } else {
                dynamicMethodCache.put("entity_" + methodName, method);
                EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), true, "Fallback entity method cached");
            }
        }
        catch (NoSuchMethodException e) {
            EntityRaidDebugLogger.logReflectionCall(methodName, clazz.getSimpleName(), false, "Method not found");
        }
    }

    public static Boolean isAlly(Team team1, Team team2) {
        ReflectionCache.initialize();
        if (!recruitsEventsAvailable) {
            EntityRaidDebugLogger.logReflectionCall("isAlly", "ReflectionCache", false, "RecruitEvents not available");
            return null;
        }
        if (isAllyMethod != null) {
            try {
                Object result = isAllyMethod.invoke(null, team1, team2);
                if (result instanceof Boolean) {
                    EntityRaidDebugLogger.logReflectionCall("isAlly", "primary", true, "Result: " + result);
                    return (Boolean)result;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.isAlly", "Error invoking primary isAlly method", e);
            }
        }
        for (Map.Entry<String, Method> entry : dynamicMethodCache.entrySet()) {
            if (!entry.getKey().startsWith("alliance_")) continue;
            try {
                Object result = entry.getValue().invoke(null, team1, team2);
                if (!(result instanceof Boolean)) continue;
                EntityRaidDebugLogger.logReflectionCall("isAlly", entry.getKey(), true, "Fallback result: " + result);
                return (Boolean)result;
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.isAlly", "Error invoking fallback method " + entry.getKey(), e);
            }
        }
        Boolean harmResult = ReflectionCache.tryInvertedHarmCheck(team1, team2);
        if (harmResult != null) {
            EntityRaidDebugLogger.logReflectionCall("isAlly", "inverted_harm", true, "Inverted harm result: " + harmResult);
            return harmResult;
        }
        EntityRaidDebugLogger.logReflectionCall("isAlly", "all_methods", false, "All alliance detection methods failed");
        return null;
    }

    private static Boolean tryInvertedHarmCheck(Team team1, Team team2) {
        return null;
    }

    public static Boolean canHarmTeam(LivingEntity entity1, LivingEntity entity2) {
        ReflectionCache.initialize();
        if (!recruitsEventsAvailable) {
            EntityRaidDebugLogger.logReflectionCall("canHarmTeam", "ReflectionCache", false, "RecruitEvents not available");
            return null;
        }
        if (canHarmTeamMethod != null) {
            try {
                Object result = canHarmTeamMethod.invoke(null, entity1, entity2);
                if (result instanceof Boolean) {
                    EntityRaidDebugLogger.logReflectionCall("canHarmTeam", "primary", true, "Result: " + result);
                    return (Boolean)result;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.canHarmTeam", "Error invoking primary canHarmTeam method", e);
            }
        }
        for (Map.Entry<String, Method> entry : dynamicMethodCache.entrySet()) {
            if (!entry.getKey().startsWith("harm_")) continue;
            try {
                Object result = entry.getValue().invoke(null, entity1, entity2);
                if (!(result instanceof Boolean)) continue;
                EntityRaidDebugLogger.logReflectionCall("canHarmTeam", entry.getKey(), true, "Fallback result: " + result);
                return (Boolean)result;
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.canHarmTeam", "Error invoking fallback method " + entry.getKey(), e);
            }
        }
        Method isEnemyMethod = dynamicMethodCache.get("additional_isEnemy");
        if (isEnemyMethod != null) {
            try {
                Object result;
                Team team1 = entity1.m_5647_();
                Team team2 = entity2.m_5647_();
                if (team1 != null && team2 != null && (result = isEnemyMethod.invoke(null, team1, team2)) instanceof Boolean) {
                    Boolean isEnemy = (Boolean)result;
                    EntityRaidDebugLogger.logReflectionCall("canHarmTeam", "isEnemy_inverted", true, "Enemy result: " + isEnemy + ", can harm: " + isEnemy);
                    return isEnemy;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.canHarmTeam", "Error invoking isEnemy method", e);
            }
        }
        EntityRaidDebugLogger.logReflectionCall("canHarmTeam", "all_methods", false, "All harm detection methods failed");
        return null;
    }

    public static UUID getOwnerUUID(Object entity) {
        Object result;
        ReflectionCache.initialize();
        if (!abstractRecruitEntityAvailable) {
            EntityRaidDebugLogger.logReflectionCall("getOwnerUUID", "ReflectionCache", false, "Recruit entity classes not available");
            return null;
        }
        if (getOwnerUUIDMethod != null) {
            try {
                result = getOwnerUUIDMethod.invoke(entity, new Object[0]);
                if (result instanceof UUID) {
                    EntityRaidDebugLogger.logReflectionCall("getOwnerUUID", "primary", true, "UUID retrieved successfully");
                    return (UUID)result;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.getOwnerUUID", "Error invoking primary getOwnerUUID method", e);
            }
        }
        for (Map.Entry<String, Method> entry : dynamicMethodCache.entrySet()) {
            if (!entry.getKey().startsWith("entity_") || !entry.getKey().contains("Owner") || !entry.getKey().contains("UUID")) continue;
            try {
                Object result2 = entry.getValue().invoke(entity, new Object[0]);
                if (!(result2 instanceof UUID)) continue;
                EntityRaidDebugLogger.logReflectionCall("getOwnerUUID", entry.getKey(), true, "Fallback UUID retrieved");
                return (UUID)result2;
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.getOwnerUUID", "Error invoking fallback method " + entry.getKey(), e);
            }
        }
        if (getOwnerMethod != null) {
            try {
                UUID uuid;
                result = getOwnerMethod.invoke(entity, new Object[0]);
                if (result != null && (uuid = ReflectionCache.extractUUIDFromOwner(result)) != null) {
                    EntityRaidDebugLogger.logReflectionCall("getOwnerUUID", "getOwner_extracted", true, "UUID extracted from owner object");
                    return uuid;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.getOwnerUUID", "Error invoking getOwner method", e);
            }
        }
        try {
            String[] methodNames;
            Class<?> entityClass = entity.getClass();
            for (String methodName : methodNames = new String[]{"getOwnerUUID", "getOwner", "getOwnerID", "getPlayerUUID"}) {
                try {
                    UUID uuid;
                    Method method = entityClass.getMethod(methodName, new Class[0]);
                    Object result3 = method.invoke(entity, new Object[0]);
                    if (result3 instanceof UUID) {
                        EntityRaidDebugLogger.logReflectionCall("getOwnerUUID", "dynamic_" + methodName, true, "Dynamic UUID retrieved");
                        return (UUID)result3;
                    }
                    if (result3 == null || (uuid = ReflectionCache.extractUUIDFromOwner(result3)) == null) continue;
                    EntityRaidDebugLogger.logReflectionCall("getOwnerUUID", "dynamic_" + methodName + "_extracted", true, "Dynamic UUID extracted");
                    return uuid;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("ReflectionCache.getOwnerUUID", "Error with dynamic method lookup", e);
        }
        EntityRaidDebugLogger.logReflectionCall("getOwnerUUID", "all_methods", false, "All owner UUID retrieval methods failed");
        return null;
    }

    private static UUID extractUUIDFromOwner(Object owner) {
        if (owner == null) {
            return null;
        }
        try {
            Method getUUIDMethod2;
            Object result;
            if (owner instanceof UUID) {
                return (UUID)owner;
            }
            if (owner.getClass().getSimpleName().contains("Player") && (result = (getUUIDMethod2 = owner.getClass().getMethod("getUUID", new Class[0])).invoke(owner, new Object[0])) instanceof UUID) {
                return (UUID)result;
            }
            if (owner instanceof String) {
                try {
                    return UUID.fromString((String)owner);
                }
                catch (IllegalArgumentException getUUIDMethod2) {}
            }
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("ReflectionCache.extractUUIDFromOwner", "Error extracting UUID from owner object", e);
        }
        return null;
    }

    public static Boolean isOwned(Object entity) {
        ReflectionCache.initialize();
        if (!abstractRecruitEntityAvailable) {
            EntityRaidDebugLogger.logReflectionCall("isOwned", "ReflectionCache", false, "Recruit entity classes not available");
            return null;
        }
        if (isOwnedMethod != null) {
            try {
                Object result = isOwnedMethod.invoke(entity, new Object[0]);
                if (result instanceof Boolean) {
                    EntityRaidDebugLogger.logReflectionCall("isOwned", "primary", true, "Result: " + result);
                    return (Boolean)result;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.isOwned", "Error invoking primary isOwned method", e);
            }
        }
        for (Map.Entry<String, Method> entry : dynamicMethodCache.entrySet()) {
            if (!entry.getKey().startsWith("entity_") || !entry.getKey().contains("Owned") && !entry.getKey().contains("Owner")) continue;
            try {
                Object result = entry.getValue().invoke(entity, new Object[0]);
                if (!(result instanceof Boolean)) continue;
                EntityRaidDebugLogger.logReflectionCall("isOwned", entry.getKey(), true, "Fallback result: " + result);
                return (Boolean)result;
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.isOwned", "Error invoking fallback method " + entry.getKey(), e);
            }
        }
        UUID ownerUUID = ReflectionCache.getOwnerUUID(entity);
        if (ownerUUID != null) {
            EntityRaidDebugLogger.logReflectionCall("isOwned", "inferred_from_uuid", true, "Inferred ownership from UUID presence");
            return true;
        }
        try {
            String[] methodNames;
            Class<?> entityClass = entity.getClass();
            for (String methodName : methodNames = new String[]{"isOwned", "hasOwner", "isTamed", "isPlayerOwned"}) {
                try {
                    Method method = entityClass.getMethod(methodName, new Class[0]);
                    Object result = method.invoke(entity, new Object[0]);
                    if (!(result instanceof Boolean)) continue;
                    EntityRaidDebugLogger.logReflectionCall("isOwned", "dynamic_" + methodName, true, "Dynamic result: " + result);
                    return (Boolean)result;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("ReflectionCache.isOwned", "Error with dynamic method lookup", e);
        }
        EntityRaidDebugLogger.logReflectionCall("isOwned", "all_methods", false, "All ownership detection methods failed");
        return null;
    }

    public static Long getCreationTime(Object entity) {
        ReflectionCache.initialize();
        if (!recruitsModAvailable) {
            return null;
        }
        if (getCreationTimeMethod != null) {
            try {
                Object result = getCreationTimeMethod.invoke(entity, new Object[0]);
                if (result instanceof Long) {
                    return (Long)result;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.getCreationTime", "Error invoking cached getCreationTime method", e);
            }
        }
        try {
            Class<?> entityClass = entity.getClass();
            Method method = entityClass.getMethod("getCreationTime", new Class[0]);
            Object result = method.invoke(entity, new Object[0]);
            if (result instanceof Long) {
                return (Long)result;
            }
        }
        catch (Exception e) {
            EntityRaidDebugLogger.logError("ReflectionCache.getCreationTime", "Error with dynamic method lookup", e);
        }
        return null;
    }

    public static boolean isRecruitsModAvailable() {
        ReflectionCache.initialize();
        return recruitsModAvailable;
    }

    public static Team getEntityTeam(Object entity) {
        Team team;
        Method teamMethod;
        ReflectionCache.initialize();
        if (!abstractRecruitEntityAvailable) {
            return null;
        }
        if (getTeamMethod != null) {
            try {
                Object result = getTeamMethod.invoke(entity, new Object[0]);
                if (result instanceof Team) {
                    EntityRaidDebugLogger.logReflectionCall("getEntityTeam", "primary", true, "Team retrieved successfully");
                    return (Team)result;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.getEntityTeam", "Error invoking primary getTeam method", e);
            }
        }
        if ((teamMethod = dynamicMethodCache.get("additional_getTeam")) != null) {
            try {
                Object result = teamMethod.invoke(entity, new Object[0]);
                if (result instanceof Team) {
                    EntityRaidDebugLogger.logReflectionCall("getEntityTeam", "fallback", true, "Team retrieved via fallback");
                    return (Team)result;
                }
            }
            catch (Exception e) {
                EntityRaidDebugLogger.logError("ReflectionCache.getEntityTeam", "Error invoking fallback getTeam method", e);
            }
        }
        if (entity instanceof LivingEntity && (team = ((LivingEntity)entity).m_5647_()) != null) {
            EntityRaidDebugLogger.logReflectionCall("getEntityTeam", "minecraft_standard", true, "Team retrieved via standard method");
            return team;
        }
        EntityRaidDebugLogger.logReflectionCall("getEntityTeam", "all_methods", false, "All team retrieval methods failed");
        return null;
    }

    public static boolean isRecruitsEventsAvailable() {
        ReflectionCache.initialize();
        return recruitsEventsAvailable;
    }

    public static boolean isRecruitEntityClassAvailable() {
        ReflectionCache.initialize();
        return abstractRecruitEntityAvailable;
    }

    public static UUID getRecruitOwnerUUID(Object entity) {
        if (entity == null) {
            EntityRaidDebugLogger.logReflectionCall("getRecruitOwnerUUID", "null_entity", false, "Entity is null");
            return null;
        }
        ReflectionCache.initialize();
        if (!abstractRecruitEntityAvailable || !ReflectionCache.isRecruitEntity(entity)) {
            EntityRaidDebugLogger.logReflectionCall("getRecruitOwnerUUID", "not_recruit", false, "Entity is not a recruit entity");
            return null;
        }
        UUID ownerUUID = ReflectionCache.getOwnerUUID(entity);
        if (ownerUUID != null) {
            EntityRaidDebugLogger.logReflectionCall("getRecruitOwnerUUID", "success", true, "Recruit owner UUID retrieved: " + ownerUUID.toString());
        } else {
            EntityRaidDebugLogger.logReflectionCall("getRecruitOwnerUUID", "failed", false, "Failed to retrieve recruit owner UUID");
        }
        return ownerUUID;
    }

    private static boolean isRecruitEntity(Object entity) {
        if (entity == null) {
            return false;
        }
        String entityClass = entity.getClass().getName();
        return entityClass.contains("recruit") || entityClass.contains("Recruit") || entityClass.contains("soldier") || entityClass.contains("guard");
    }

    public static String getCacheStatistics() {
        ReflectionCache.initialize();
        StringBuilder stats = new StringBuilder();
        stats.append("ReflectionCache Statistics:\n");
        stats.append("- Recruits Mod Available: ").append(recruitsModAvailable).append("\n");
        stats.append("- Events Available: ").append(recruitsEventsAvailable).append("\n");
        stats.append("- Entity Classes Available: ").append(abstractRecruitEntityAvailable).append("\n");
        stats.append("- Primary Methods Cached: ");
        int primaryCount = 0;
        if (isAllyMethod != null) {
            ++primaryCount;
        }
        if (canHarmTeamMethod != null) {
            ++primaryCount;
        }
        if (getOwnerUUIDMethod != null) {
            ++primaryCount;
        }
        if (isOwnedMethod != null) {
            ++primaryCount;
        }
        if (getCreationTimeMethod != null) {
            ++primaryCount;
        }
        if (getTeamMethod != null) {
            ++primaryCount;
        }
        stats.append(primaryCount).append("\n");
        stats.append("- Fallback Methods Cached: ").append(dynamicMethodCache.size()).append("\n");
        return stats.toString();
    }

    public static synchronized void clearDynamicCache() {
        dynamicMethodCache.clear();
        EntityRaidDebugLogger.logReflectionCall("clearDynamicCache", "ReflectionCache", true, "Dynamic cache cleared");
    }

    public static synchronized void forceReinitialize() {
        initialized = false;
        recruitsModAvailable = false;
        recruitsEventsAvailable = false;
        abstractRecruitEntityAvailable = false;
        isAllyMethod = null;
        canHarmTeamMethod = null;
        getOwnerUUIDMethod = null;
        isOwnedMethod = null;
        getCreationTimeMethod = null;
        getTeamMethod = null;
        isEnemyMethod = null;
        canAttackMethod = null;
        getOwnerMethod = null;
        hasOwnerMethod = null;
        dynamicMethodCache.clear();
        ReflectionCache.initialize();
    }

    static {
        dynamicMethodCache = new ConcurrentHashMap<String, Method>();
        initialized = false;
        recruitsModAvailable = false;
        recruitsEventsAvailable = false;
        abstractRecruitEntityAvailable = false;
        RECRUIT_EVENT_CLASS_NAMES = new String[]{"com.talhanation.recruits.RecruitEvents", "com.talhanation.recruits.events.RecruitEvents", "com.talhanation.recruits.util.RecruitEvents"};
        RECRUIT_ENTITY_CLASS_NAMES = new String[]{"com.talhanation.recruits.entities.AbstractRecruitEntity", "com.talhanation.recruits.entities.RecruitEntity", "com.talhanation.recruits.entities.BaseRecruitEntity", "com.talhanation.recruits.entity.AbstractRecruitEntity"};
    }
}

