/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.server;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Rank;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.data.WarData;
import net.machiavelli.minecolonytax.gui.data.ColonyTaxData;
import net.machiavelli.minecolonytax.gui.data.VassalIncomeData;
import net.machiavelli.minecolonytax.raid.RaidManager;
import net.machiavelli.minecolonytax.vassalization.VassalManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColonyDataCollector {
    private static final Logger LOGGER = LogManager.getLogger(ColonyDataCollector.class);

    public static List<ColonyTaxData> collectColonyData(ServerPlayer player) {
        ArrayList<ColonyTaxData> colonyDataList = new ArrayList<ColonyTaxData>();
        UUID playerId = player.m_20148_();
        IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
        for (IColony colony : colonyManager.getAllColonies()) {
            ColonyTaxData data;
            if (!ColonyDataCollector.isPlayerManagerOfColony(player, colony) || (data = ColonyDataCollector.collectSingleColonyData(colony, playerId)) == null) continue;
            colonyDataList.add(data);
        }
        return colonyDataList;
    }

    public static List<VassalIncomeData> collectVassalIncomeData(ServerPlayer player) {
        ArrayList<VassalIncomeData> vassalIncomes = new ArrayList<VassalIncomeData>();
        UUID playerId = player.m_20148_();
        try {
            List<VassalIncomeData> vassalData = VassalManager.getVassalIncomeForPlayer(playerId);
            for (VassalIncomeData data : vassalData) {
                boolean canClaim = true;
                try {
                    IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
                    IColony vassalColony = colonyManager.getColonyByWorld(data.getVassalColonyId(), (Level)player.m_284548_());
                    if (vassalColony != null) {
                        WarData war = WarSystem.ACTIVE_WARS.get(data.getVassalColonyId());
                        boolean isBeingRaided = RaidManager.getActiveRaidForColony(data.getVassalColonyId()) != null;
                        canClaim = war == null && !isBeingRaided && !TaxManager.isGenerationDisabled(data.getVassalColonyId());
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error checking claim status for vassal colony {}: {}", (Object)data.getVassalColonyName(), (Object)e.getMessage());
                    canClaim = false;
                }
                vassalIncomes.add(new VassalIncomeData(data.getVassalColonyId(), data.getVassalColonyName(), data.getTributeRate(), data.getTributeOwed(), data.getLastTribute(), data.getLastPayment(), canClaim));
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error collecting vassal income data for player {}: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
        }
        return vassalIncomes;
    }

    private static boolean isPlayerManagerOfColony(ServerPlayer player, IColony colony) {
        Rank rank = colony.getPermissions().getRank(player.m_20148_());
        return rank != null && rank.isColonyManager();
    }

    private static ColonyTaxData collectSingleColonyData(IColony colony, UUID playerId) {
        try {
            int colonyId = colony.getID();
            String colonyName = colony.getName();
            int taxBalance = TaxManager.getStoredTaxForColony(colony);
            int maxTaxRevenue = TaxConfig.getMaxTaxRevenue();
            int buildingCount = 0;
            int guardCount = 0;
            int guardTowerCount = 0;
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (building.getBuildingLevel() <= 0 || !building.isBuilt()) continue;
                ++buildingCount;
                String displayName = building.getBuildingDisplayName();
                String className = building.getClass().getName().toLowerCase();
                String toString = building.toString().toLowerCase();
                if (displayName != null && "Guard Tower".equalsIgnoreCase(displayName) || className.contains("guardtower") || toString.contains("guardtower") || toString.contains("guard_tower")) {
                    ++guardTowerCount;
                }
                try {
                    if (building.getAllAssignedCitizen() == null) continue;
                    guardCount += building.getAllAssignedCitizen().size();
                }
                catch (Exception exception) {}
            }
            boolean isAtWar = false;
            boolean isBeingRaided = false;
            WarData war = WarSystem.ACTIVE_WARS.get(colonyId);
            if (war == null) {
                for (WarData wd : WarSystem.ACTIVE_WARS.values()) {
                    if (wd.getAttackerColony() == null || wd.getAttackerColony().getID() != colonyId) continue;
                    war = wd;
                    break;
                }
            }
            isAtWar = war != null;
            isBeingRaided = RaidManager.getActiveRaidForColony(colonyId) != null;
            boolean canClaimTax = !isAtWar && !isBeingRaided && !TaxManager.isGenerationDisabled(colonyId);
            boolean isVassal = false;
            int vassalTributeRate = 0;
            boolean hasVassals = false;
            int vassalCount = 0;
            try {
                isVassal = VassalManager.isColonyVassal(colonyId);
                if (isVassal) {
                    vassalTributeRate = VassalManager.getVassalTributeRate(colonyId);
                }
                boolean bl = hasVassals = (vassalCount = VassalManager.countVassalsForPlayer(playerId)) > 0;
                if (isVassal || hasVassals) {
                    LOGGER.info("Colony {} (Player: {}) - isVassal: {}, vassalRate: {}, hasVassals: {}, vassalCount: {}", (Object)colonyId, (Object)playerId, (Object)isVassal, (Object)vassalTributeRate, (Object)hasVassals, (Object)vassalCount);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Error checking vassal status for colony {}: {}", (Object)colonyName, (Object)e.getMessage());
            }
            long lastTaxGeneration = System.currentTimeMillis();
            int debtAmount = taxBalance < 0 ? Math.abs(taxBalance) : 0;
            int approximateRevenue = ColonyDataCollector.calculateApproximateRevenue(buildingCount, guardTowerCount);
            boolean isOwner = colony.getPermissions().getOwner().equals(playerId);
            return new ColonyTaxData(colonyId, colonyName, taxBalance, maxTaxRevenue, buildingCount, guardCount, guardTowerCount, canClaimTax, isAtWar, isBeingRaided, isVassal, vassalTributeRate, hasVassals, vassalCount, lastTaxGeneration, debtAmount, approximateRevenue, isOwner);
        }
        catch (Exception e) {
            LOGGER.error("Error collecting data for colony {}: {}", (Object)colony.getName(), (Object)e.getMessage());
            return null;
        }
    }

    private static int calculateApproximateRevenue(int buildingCount, int guardTowerCount) {
        double baseTaxPerBuilding = 3.5;
        boolean hasGuardBoost = guardTowerCount >= 5;
        double boostMultiplier = hasGuardBoost ? 1.25 : 1.0;
        double approximateRevenue = (double)buildingCount * baseTaxPerBuilding * boostMultiplier;
        int maxRevenue = TaxConfig.getMaxTaxRevenue();
        if (maxRevenue > 0) {
            approximateRevenue = Math.min(approximateRevenue, (double)maxRevenue);
        }
        return (int)Math.round(approximateRevenue);
    }
}

