/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.util;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColonyActivityTracker {
    private static final Logger LOGGER = LogManager.getLogger(ColonyActivityTracker.class);
    private static final Map<Integer, ActivityStatus> activityCache = new ConcurrentHashMap<Integer, ActivityStatus>();
    private static long lastCacheUpdate = 0L;
    private static final long CACHE_VALIDITY_MS = 300000L;

    public static boolean isColonyActive(IColony colony) {
        int threshold;
        if (!TaxConfig.isColonyInactivityTaxPauseEnabled()) {
            return true;
        }
        int colonyId = colony.getID();
        ActivityStatus cached = activityCache.get(colonyId);
        if (cached != null && !cached.isExpired()) {
            return cached.isActive;
        }
        int lastContactHours = colony.getLastContactInHours();
        boolean isActive = lastContactHours < (threshold = TaxConfig.getColonyInactivityHoursThreshold());
        activityCache.put(colonyId, new ActivityStatus(isActive, lastContactHours));
        return isActive;
    }

    public static ActivityStatus getColonyActivityStatus(IColony colony) {
        int threshold;
        if (!TaxConfig.isColonyInactivityTaxPauseEnabled()) {
            return new ActivityStatus(true, colony.getLastContactInHours());
        }
        int colonyId = colony.getID();
        ActivityStatus cached = activityCache.get(colonyId);
        if (cached != null && !cached.isExpired()) {
            return cached;
        }
        int lastContactHours = colony.getLastContactInHours();
        boolean isActive = lastContactHours < (threshold = TaxConfig.getColonyInactivityHoursThreshold());
        ActivityStatus status = new ActivityStatus(isActive, lastContactHours);
        activityCache.put(colonyId, status);
        return status;
    }

    public static Map<String, Integer> getGlobalActivityStatistics(MinecraftServer server) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("total", 0);
        stats.put("active", 0);
        stats.put("inactive", 0);
        if (server == null) {
            return stats;
        }
        int threshold = TaxConfig.getColonyInactivityHoursThreshold();
        boolean systemEnabled = TaxConfig.isColonyInactivityTaxPauseEnabled();
        for (Level world : server.m_129785_()) {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            for (IColony colony : colonyManager.getColonies(world)) {
                stats.put("total", (Integer)stats.get("total") + 1);
                if (!systemEnabled || colony.getLastContactInHours() < threshold) {
                    stats.put("active", (Integer)stats.get("active") + 1);
                    continue;
                }
                stats.put("inactive", (Integer)stats.get("inactive") + 1);
            }
        }
        return stats;
    }

    public static List<IColony> getInactiveColonies(MinecraftServer server) {
        ArrayList<IColony> inactiveColonies = new ArrayList<IColony>();
        if (server == null || !TaxConfig.isColonyInactivityTaxPauseEnabled()) {
            return inactiveColonies;
        }
        int threshold = TaxConfig.getColonyInactivityHoursThreshold();
        for (Level world : server.m_129785_()) {
            IColonyManager colonyManager = IMinecoloniesAPI.getInstance().getColonyManager();
            for (IColony colony : colonyManager.getColonies(world)) {
                if (colony.getLastContactInHours() < threshold) continue;
                inactiveColonies.add(colony);
            }
        }
        return inactiveColonies;
    }

    public static void clearCache() {
        activityCache.clear();
        lastCacheUpdate = System.currentTimeMillis();
        if (TaxConfig.showTaxGenerationLogs()) {
            LOGGER.debug("Colony activity cache cleared");
        }
    }

    public static void cleanupExpiredCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCacheUpdate > 300000L) {
            Iterator<Map.Entry<Integer, ActivityStatus>> iterator = activityCache.entrySet().iterator();
            int removedCount = 0;
            while (iterator.hasNext()) {
                Map.Entry<Integer, ActivityStatus> entry = iterator.next();
                if (!entry.getValue().isExpired()) continue;
                iterator.remove();
                ++removedCount;
            }
            lastCacheUpdate = currentTime;
            if (removedCount > 0 && TaxConfig.showTaxGenerationLogs()) {
                LOGGER.debug("Cleaned up {} expired entries from colony activity cache", (Object)removedCount);
            }
        }
    }

    public static int getHoursSinceLastContact(IColony colony) {
        return colony.getLastContactInHours();
    }

    public static boolean isInactivitySystemEnabled() {
        return TaxConfig.isColonyInactivityTaxPauseEnabled() && TaxConfig.getColonyInactivityHoursThreshold() > 0;
    }

    public static String getActivityStatusDescription(IColony colony) {
        int threshold;
        if (!TaxConfig.isColonyInactivityTaxPauseEnabled()) {
            return "Active (inactivity system disabled)";
        }
        int lastContactHours = colony.getLastContactInHours();
        if (lastContactHours < (threshold = TaxConfig.getColonyInactivityHoursThreshold())) {
            return String.format("Active (last contact: %d hours ago)", lastContactHours);
        }
        int hoursOverThreshold = lastContactHours - threshold;
        return String.format("Inactive (last contact: %d hours ago, %d hours over threshold)", lastContactHours, hoursOverThreshold);
    }

    public static class ActivityStatus {
        public final boolean isActive;
        public final int lastContactHours;
        public final long timestamp;

        public ActivityStatus(boolean isActive, int lastContactHours) {
            this.isActive = isActive;
            this.lastContactHours = lastContactHours;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 300000L;
        }
    }
}

