/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.util;

import net.machiavelli.minecolonytax.TaxConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemUtils {
    private static final Logger LOGGER = LogManager.getLogger(ItemUtils.class);

    public static boolean giveItemsToPlayer(ServerPlayer player, String itemName, int amount) {
        if (player == null || amount <= 0) {
            return false;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item != null) {
            ItemStack itemStack = new ItemStack((ItemLike)item, amount);
            boolean added = player.m_150109_().m_36054_(itemStack);
            if (!added) {
                player.m_36176_(itemStack, false);
                player.m_213846_((Component)Component.m_237110_((String)"taxmanager.inventory_full", (Object[])new Object[]{amount, itemName}));
                LOGGER.debug("Player's inventory was full, dropped {} {} near them", (Object)amount, (Object)itemName);
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"taxmanager.currency_received", (Object[])new Object[]{amount, itemName}));
                LOGGER.debug("Successfully gave {} {} to player {}", (Object)amount, (Object)itemName, (Object)player.m_7755_().getString());
            }
            return true;
        }
        LOGGER.warn("Item {} not found in registry, falling back to give command", (Object)itemName);
        String giveCommand = String.format("give %s %s %d", player.m_7755_().getString(), itemName, amount);
        try {
            player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), giveCommand);
            LOGGER.debug("Executed fallback give command: {}", (Object)giveCommand);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute give command: {}", (Object)giveCommand, (Object)e);
            return false;
        }
    }

    public static boolean giveCurrencyToPlayer(ServerPlayer player, int amount) {
        return ItemUtils.giveItemsToPlayer(player, TaxConfig.getCurrencyItemName(), amount);
    }
}

