/*
 * Decompiled with CFR 0.152.
 */
package net.machiavelli.minecolonytax.vassalization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import dev.ftb.mods.ftbteams.api.Team;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.machiavelli.minecolonytax.TaxConfig;
import net.machiavelli.minecolonytax.TaxManager;
import net.machiavelli.minecolonytax.WarSystem;
import net.machiavelli.minecolonytax.gui.data.VassalIncomeData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="minecolonytax", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VassalManager {
    private static final Logger LOGGER = LogManager.getLogger(VassalManager.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String STORAGE_FILE = "config/warntax/vassals.json";
    private static final Map<Integer, VassalRelation> ACTIVE_VASSALS = new ConcurrentHashMap<Integer, VassalRelation>();
    private static final Map<Integer, VassalProposal> PENDING_PROPOSALS = new ConcurrentHashMap<Integer, VassalProposal>();
    private static final Map<UUID, List<Component>> OFFLINE_MESSAGES = new ConcurrentHashMap<UUID, List<Component>>();
    private static MinecraftServer SERVER;

    public static void initialize(MinecraftServer server) {
        SERVER = server;
        VassalManager.loadData(server);
        LOGGER.info("VassalManager initialized");
    }

    public static void shutdown() {
        VassalManager.saveData();
    }

    public static int requestVassalization(ServerPlayer overlord, IColony targetColony, int percent) {
        if (percent <= 0 || percent > 100) {
            overlord.m_213846_((Component)Component.m_237113_((String)"Percentage must be between 1 and 100"));
            return 0;
        }
        if (ACTIVE_VASSALS.containsKey(targetColony.getID()) || PENDING_PROPOSALS.containsKey(targetColony.getID())) {
            overlord.m_213846_((Component)Component.m_237113_((String)"A vassalization relation or proposal already exists for this colony."));
            return 0;
        }
        VassalProposal proposal = new VassalProposal(targetColony.getID(), overlord.m_20148_(), percent);
        PENDING_PROPOSALS.put(targetColony.getID(), proposal);
        try {
            VassalManager.sendToColonyManagers(targetColony, (Component)Component.m_237113_((String)(overlord.m_7755_().getString() + " requests that your colony become a vassal, paying " + percent + "% of its tax income.")));
            MutableComponent accept = Component.m_237113_((String)"[Accept]").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt vasalaccept " + targetColony.getID())));
            MutableComponent decline = Component.m_237113_((String)"[Decline]").m_130938_(style -> style.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wnt vasaldecline " + targetColony.getID())));
            VassalManager.sendToColonyManagers(targetColony, (Component)Component.m_237113_((String)" ").m_7220_((Component)accept).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)decline));
            overlord.m_213846_((Component)Component.m_237113_((String)"Vassalization proposal sent."));
            return 1;
        }
        catch (Throwable t) {
            PENDING_PROPOSALS.remove(targetColony.getID());
            LOGGER.warn("Failed to deliver vassalization request notifications for colony {}: {}", (Object)targetColony.getName(), (Object)t.toString());
            overlord.m_213846_((Component)Component.m_237113_((String)"Failed to send vassalization request. Please try again in a moment."));
            return 0;
        }
    }

    public static int acceptProposal(ServerPlayer executor, int colonyId) {
        VassalProposal prop = PENDING_PROPOSALS.get(colonyId);
        if (prop == null) {
            executor.m_213846_((Component)Component.m_237113_((String)"No pending proposal for this colony."));
            return 0;
        }
        IColony colony = VassalManager.getColonyById(colonyId);
        if (colony == null) {
            executor.m_213846_((Component)Component.m_237113_((String)"Colony not found."));
            return 0;
        }
        if (!VassalManager.isPlayerManagerOfColony(executor, colony)) {
            executor.m_213846_((Component)Component.m_237113_((String)"You are not authorized to accept proposals for this colony."));
            return 0;
        }
        VassalRelation rel = new VassalRelation(colonyId, prop.overlordUUID, prop.percent, System.currentTimeMillis());
        ACTIVE_VASSALS.put(colonyId, rel);
        PENDING_PROPOSALS.remove(colonyId);
        VassalManager.saveData();
        ServerPlayer overlord = SERVER.m_6846_().m_11259_(prop.overlordUUID);
        if (overlord != null) {
            overlord.m_213846_((Component)Component.m_237113_((String)("Your vassalization proposal for colony " + colony.getName() + " has been accepted.")));
        } else {
            VassalManager.queueMessage(prop.overlordUUID, (Component)Component.m_237113_((String)("Your vassalization proposal for colony " + colony.getName() + " has been accepted.")));
        }
        executor.m_213846_((Component)Component.m_237113_((String)("Colony is now a vassal. It will pay " + prop.percent + "% of its taxes.")));
        return 1;
    }

    public static int declineProposal(ServerPlayer executor, int colonyId) {
        VassalProposal prop = PENDING_PROPOSALS.get(colonyId);
        if (prop == null) {
            executor.m_213846_((Component)Component.m_237113_((String)"No pending proposal."));
            return 0;
        }
        IColony colony = VassalManager.getColonyById(colonyId);
        if (colony == null) {
            PENDING_PROPOSALS.remove(colonyId);
            return 1;
        }
        if (!VassalManager.isPlayerManagerOfColony(executor, colony)) {
            executor.m_213846_((Component)Component.m_237113_((String)"You are not authorized to respond."));
            return 0;
        }
        PENDING_PROPOSALS.remove(colonyId);
        ServerPlayer overlord = SERVER.m_6846_().m_11259_(prop.overlordUUID);
        if (overlord != null) {
            overlord.m_213846_((Component)Component.m_237113_((String)("Your vassalization proposal for colony " + colony.getName() + " was declined.")));
        } else {
            VassalManager.queueMessage(prop.overlordUUID, (Component)Component.m_237113_((String)("Your vassalization proposal for colony " + colony.getName() + " was declined.")));
        }
        executor.m_213846_((Component)Component.m_237113_((String)"You declined the vassalization proposal."));
        return 1;
    }

    public static int revokeRelation(ServerPlayer executor, String overlordNameOrTarget) {
        UUID executorId = executor.m_20148_();
        boolean found = false;
        Iterator<Map.Entry<Integer, VassalRelation>> it = ACTIVE_VASSALS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, VassalRelation> e = it.next();
            VassalRelation rel = e.getValue();
            IColony colony = VassalManager.getColonyById(e.getKey());
            if (colony == null) continue;
            String overlordName = VassalManager.getPlayerName(rel.overlordUUID);
            if (!rel.overlordUUID.equals(executorId) && (!VassalManager.isPlayerManagerOfColony(executor, colony) || !overlordName.equalsIgnoreCase(overlordNameOrTarget))) continue;
            it.remove();
            VassalManager.saveData();
            ServerPlayer overlord = SERVER.m_6846_().m_11259_(rel.overlordUUID);
            String msg = "Vassalization between colony " + colony.getName() + " and player " + overlordName + " has been revoked.";
            executor.m_213846_((Component)Component.m_237113_((String)"You revoked the vassalization."));
            if (overlord != null) {
                overlord.m_213846_((Component)Component.m_237113_((String)msg));
            } else {
                VassalManager.queueMessage(rel.overlordUUID, (Component)Component.m_237113_((String)msg));
            }
            found = true;
        }
        if (!found) {
            executor.m_213846_((Component)Component.m_237113_((String)"No matching vassalization found."));
            return 0;
        }
        return 1;
    }

    public static int listVassals(ServerPlayer player) {
        UUID id = player.m_20148_();
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76\u00a7l=== Vassalization Status ==="));
        boolean isVassal = false;
        for (VassalRelation rel : ACTIVE_VASSALS.values()) {
            IColony playerColony = VassalManager.getPrimaryColonyOfPlayer(id);
            if (playerColony == null || rel.colonyId != playerColony.getID()) continue;
            isVassal = true;
            ServerPlayer overlord = SERVER.m_6846_().m_11259_(rel.overlordUUID);
            String overlordName = overlord != null ? overlord.m_36316_().getName() : "Unknown";
            String currencyName = VassalManager.getCurrencyName();
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[VASSAL STATUS] Your colony is a vassal to " + overlordName + "'s colony (" + rel.percent + "% tribute rate)")));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[VASSAL STATUS] Last tribute: " + rel.lastTribute + " " + currencyName)));
            break;
        }
        if (!isVassal) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[VASSAL STATUS] Your colony is independent"));
        }
        boolean hasVassals = false;
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7e--- Your Vassals ---"));
        for (VassalRelation rel : ACTIVE_VASSALS.values()) {
            IColony colony;
            if (!rel.overlordUUID.equals(id) || (colony = VassalManager.getColonyById(rel.colonyId)) == null) continue;
            long minutes = (System.currentTimeMillis() - rel.lastPayment) / 60000L;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a- " + colony.getName() + ": " + rel.percent + "% tribute rate")));
            player.m_213846_((Component)Component.m_237113_((String)("  \u00a77Last payment: " + minutes + "m ago, Amount: " + rel.lastTribute + " " + VassalManager.getCurrencyName())));
            hasVassals = true;
        }
        if (!hasVassals) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77You have no vassals."));
        }
        return 1;
    }

    public static int handleTaxIncome(IColony colony, int generatedTax) {
        VassalRelation rel = ACTIVE_VASSALS.get(colony.getID());
        if (rel == null) {
            return 0;
        }
        int tribute = (int)((double)(generatedTax * rel.percent) / 100.0);
        if (tribute <= 0) {
            return 0;
        }
        TaxManager.adjustTax(colony, -tribute);
        IColony overlordColony = VassalManager.getPrimaryColonyOfPlayer(rel.overlordUUID);
        if (overlordColony != null) {
            TaxManager.adjustTax(overlordColony, tribute);
        }
        rel.lastPayment = System.currentTimeMillis();
        rel.lastTribute = tribute;
        ServerPlayer overlordPlayer = SERVER.m_6846_().m_11259_(rel.overlordUUID);
        MutableComponent msg = Component.m_237113_((String)("Received tribute of " + tribute + " coins from vassal colony " + colony.getName()));
        if (overlordPlayer != null) {
            overlordPlayer.m_213846_((Component)msg);
        } else {
            VassalManager.queueMessage(rel.overlordUUID, (Component)msg);
        }
        return tribute;
    }

    public static int getTributePaid(int colonyId) {
        VassalRelation rel = ACTIVE_VASSALS.get(colonyId);
        if (rel == null) {
            return 0;
        }
        return rel.lastTribute;
    }

    private static boolean isPlayerManagerOfColony(ServerPlayer player, IColony colony) {
        Rank rank = colony.getPermissions().getRank(player.m_20148_());
        return rank != null && rank.isColonyManager();
    }

    private static void sendToColonyManagers(IColony colony, Component message) {
        HashSet<UUID> recipients;
        block22: {
            if (colony == null) {
                return;
            }
            IPermissions perms = colony.getPermissions();
            recipients = new HashSet<UUID>();
            UUID ownerId = perms.getOwner();
            if (ownerId != null) {
                recipients.add(ownerId);
            }
            try {
                Rank officerRank = perms.getRankOfficer();
                if (officerRank != null) {
                    for (ColonyPlayer cp : perms.getPlayersByRank(officerRank)) {
                        if (cp == null || cp.getID() == null) continue;
                        recipients.add(cp.getID());
                    }
                }
            }
            catch (Throwable officerRank) {
                // empty catch block
            }
            try {
                if (SERVER != null && colony.getWorld() != null && colony.getWorld().m_7654_() != null) {
                    for (ServerPlayer p : colony.getWorld().m_7654_().m_6846_().m_11314_()) {
                        try {
                            if (!perms.hasPermission((Player)p, Action.ACCESS_HUTS)) continue;
                            recipients.add(p.m_20148_());
                        }
                        catch (Throwable cp) {}
                    }
                }
            }
            catch (Throwable officerRank) {
                // empty catch block
            }
            if (recipients.isEmpty()) {
                try {
                    Map playersMap = perms.getPlayers();
                    if (playersMap != null) {
                        recipients.addAll(playersMap.keySet());
                    }
                }
                catch (Throwable playersMap) {
                    // empty catch block
                }
            }
            try {
                Optional teamOpt;
                if (ownerId == null || !WarSystem.FTB_TEAMS_INSTALLED || WarSystem.FTB_TEAM_MANAGER == null || !(teamOpt = WarSystem.FTB_TEAM_MANAGER.getTeamForPlayerID(ownerId)).isPresent()) break block22;
                Team team = (Team)teamOpt.get();
                try {
                    Set members = team.getMembers();
                    if (members != null) {
                        recipients.addAll(members);
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (UUID id : recipients) {
            VassalManager.sendOrQueue(id, message);
        }
    }

    private static void sendOrQueue(UUID playerId, Component msg) {
        ServerPlayer player = SERVER.m_6846_().m_11259_(playerId);
        if (player != null) {
            player.m_213846_(msg);
        } else {
            VassalManager.queueMessage(playerId, msg);
        }
    }

    private static void queueMessage(UUID playerId, Component msg) {
        OFFLINE_MESSAGES.computeIfAbsent(playerId, k -> new ArrayList()).add(msg);
    }

    private static String getPlayerName(UUID uuid) {
        ServerPlayer p = SERVER.m_6846_().m_11259_(uuid);
        return p != null ? p.m_7755_().getString() : uuid.toString();
    }

    private static IColony getPrimaryColonyOfPlayer(UUID playerId) {
        IColonyManager cm = IMinecoloniesAPI.getInstance().getColonyManager();
        for (IColony c : cm.getAllColonies()) {
            if (!c.getPermissions().getOwner().equals(playerId)) continue;
            return c;
        }
        return null;
    }

    private static IColony getColonyById(int colonyId) {
        return IMinecoloniesAPI.getInstance().getColonyManager().getAllColonies().stream().filter(c -> c.getID() == colonyId).findFirst().orElse(null);
    }

    private static void loadData(MinecraftServer server) {
        File f = new File(server.m_6237_(), STORAGE_FILE);
        if (!f.exists()) {
            return;
        }
        try (FileReader r = new FileReader(f);){
            Type type = new TypeToken<List<VassalRelation>>(){}.getType();
            List list = (List)GSON.fromJson((Reader)r, type);
            if (list != null) {
                for (VassalRelation rel : list) {
                    ACTIVE_VASSALS.put(rel.colonyId, rel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load vassal data", (Throwable)e);
        }
    }

    private static void saveData() {
        if (SERVER == null) {
            return;
        }
        File f = new File(SERVER.m_6237_(), STORAGE_FILE);
        try (FileWriter w = new FileWriter(f);){
            ArrayList<VassalRelation> list = new ArrayList<VassalRelation>(ACTIVE_VASSALS.values());
            GSON.toJson(list, (Appendable)w);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save vassal data", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        List<Component> msgs = OFFLINE_MESSAGES.remove(player.m_20148_());
        if (msgs != null) {
            msgs.forEach(arg_0 -> ((ServerPlayer)player).m_213846_(arg_0));
        }
    }

    private static String getCurrencyName() {
        if (TaxConfig.isSDMShopConversionEnabled()) {
            return "$";
        }
        String currencyName = TaxConfig.getCurrencyItemName();
        if (currencyName.contains(":")) {
            currencyName = currencyName.substring(currencyName.indexOf(":") + 1);
        }
        return currencyName;
    }

    public static boolean isColonyVassal(int colonyId) {
        return ACTIVE_VASSALS.containsKey(colonyId);
    }

    public static int getVassalTributeRate(int colonyId) {
        VassalRelation rel = ACTIVE_VASSALS.get(colonyId);
        return rel != null ? rel.percent : 0;
    }

    public static int countVassalsForPlayer(UUID playerId) {
        int count = 0;
        for (VassalRelation rel : ACTIVE_VASSALS.values()) {
            if (!rel.overlordUUID.equals(playerId)) continue;
            ++count;
        }
        return count;
    }

    public static boolean removeVassalRelation(int vassalColonyId) {
        VassalRelation relation = ACTIVE_VASSALS.remove(vassalColonyId);
        if (relation != null) {
            VassalManager.saveData();
            LOGGER.info("Vassalization ended for colony " + vassalColonyId);
            return true;
        }
        return false;
    }

    public static boolean endVassalizationWithNotification(int vassalColonyId, ServerPlayer player, IColony colony) {
        VassalRelation relation = ACTIVE_VASSALS.get(vassalColonyId);
        if (relation == null) {
            return false;
        }
        UUID overlordId = relation.overlordUUID;
        String playerName = player.m_7755_().getString();
        String colonyName = colony.getName();
        boolean success = VassalManager.removeVassalRelation(vassalColonyId);
        if (success) {
            MutableComponent notificationMsg = Component.m_237113_((String)("\u00a7c\u26a0 Vassalization Ended: Colony '" + colonyName + "' (managed by " + playerName + ") has ended their vassalage to you."));
            ServerPlayer overlord = SERVER.m_6846_().m_11259_(overlordId);
            if (overlord != null) {
                overlord.m_213846_((Component)notificationMsg);
                overlord.m_213846_((Component)Component.m_237113_((String)"\u00a77You will no longer receive tribute from this colony."));
            } else {
                VassalManager.addOfflineMessage(overlordId, (Component)notificationMsg);
                VassalManager.addOfflineMessage(overlordId, (Component)Component.m_237113_((String)"\u00a77You will no longer receive tribute from this colony."));
            }
            LOGGER.info("Vassalization ended for colony {} with notification sent to overlord {}", (Object)vassalColonyId, (Object)overlordId);
        }
        return success;
    }

    public static void addOfflineMessage(UUID playerId, Component message) {
        OFFLINE_MESSAGES.computeIfAbsent(playerId, k -> new ArrayList()).add(message);
    }

    public static List<VassalIncomeData> getVassalIncomeForPlayer(UUID overlordId) {
        ArrayList<VassalIncomeData> vassalIncomes = new ArrayList<VassalIncomeData>();
        for (VassalRelation rel : ACTIVE_VASSALS.values()) {
            IColony colony;
            if (!rel.overlordUUID.equals(overlordId) || (colony = VassalManager.getColonyById(rel.colonyId)) == null) continue;
            int currentTaxBalance = TaxManager.getStoredTaxForColony(colony);
            int tributeOwed = (int)((double)(currentTaxBalance * rel.percent) / 100.0);
            vassalIncomes.add(new VassalIncomeData(rel.colonyId, colony.getName(), rel.percent, tributeOwed, rel.lastTribute, rel.lastPayment, false));
        }
        return vassalIncomes;
    }

    public static int claimVassalTribute(UUID overlordId, int vassalColonyId) {
        VassalRelation rel = ACTIVE_VASSALS.get(vassalColonyId);
        if (rel == null || !rel.overlordUUID.equals(overlordId)) {
            return 0;
        }
        IColony vassalColony = VassalManager.getColonyById(vassalColonyId);
        if (vassalColony == null) {
            return 0;
        }
        int currentTaxBalance = TaxManager.getStoredTaxForColony(vassalColony);
        int tributeOwed = (int)((double)(currentTaxBalance * rel.percent) / 100.0);
        if (tributeOwed <= 0) {
            return 0;
        }
        TaxManager.adjustTax(vassalColony, -tributeOwed);
        IColony overlordColony = VassalManager.getPrimaryColonyOfPlayer(overlordId);
        if (overlordColony != null) {
            TaxManager.adjustTax(overlordColony, tributeOwed);
        }
        rel.lastPayment = System.currentTimeMillis();
        rel.lastTribute = tributeOwed;
        VassalManager.saveData();
        return tributeOwed;
    }

    private static class VassalProposal {
        int colonyId;
        UUID overlordUUID;
        int percent;

        public VassalProposal(int colonyId, UUID overlordUUID, int percent) {
            this.colonyId = colonyId;
            this.overlordUUID = overlordUUID;
            this.percent = percent;
        }
    }

    private static class VassalRelation {
        int colonyId;
        UUID overlordUUID;
        int percent;
        long lastPayment;
        int lastTribute;

        public VassalRelation(int colonyId, UUID overlordUUID, int percent, long lastPayment) {
            this.colonyId = colonyId;
            this.overlordUUID = overlordUUID;
            this.percent = percent;
            this.lastPayment = lastPayment;
            this.lastTribute = 0;
        }
    }
}

