/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block.bibliophage.agar;

import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.registries.RegisterItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractAgarBlock
extends HalfTransparentBlock {
    private final int lightLevel;

    public AbstractAgarBlock(int lightLevel, boolean emissiveRendering) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SLIME_BLOCK).noOcclusion().isViewBlocking((state, getter, pos) -> false).lightLevel(value -> 0).emissiveRendering((state, getter, pos) -> emissiveRendering));
        this.lightLevel = lightLevel;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)Config.COMMON.agarEmitsLight.get() != false ? this.lightLevel : 0;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float damage) {
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = super.getCollisionShape(state, getter, pos, context);
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollisionContext = (EntityCollisionContext)context;
            Entity e = entityCollisionContext.getEntity();
            if (e instanceof ExperienceOrb) {
                return Shapes.empty();
            }
            if (e instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)e;
                if (((Boolean)Config.COMMON.agarPermeableToDust.get()).booleanValue()) {
                    return item.getItem().is((Item)RegisterItems.FORGOTTEN_DUST.get()) ? Shapes.empty() : shape;
                }
            }
        }
        return shape;
    }
}

