/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block.bibliophage.bookshelves;

import com.cyanogen.cognition.block.bibliophage.bookshelves.BookshelfBlock;
import com.cyanogen.cognition.block_entities.bibliophage.bookshelves.AbstractInfectedBookshelfEntity;
import com.cyanogen.cognition.config.Config;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import com.cyanogen.cognition.registries.RegisterItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class InfectedBookshelfBlock
extends BookshelfBlock
implements EntityBlock {
    public InfectedBookshelfBlock(float enchantPowerBonus) {
        super(enchantPowerBonus);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape = super.getCollisionShape(state, getter, pos, context);
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollisionContext = (EntityCollisionContext)context;
            Entity e = entityCollisionContext.getEntity();
            if (e instanceof ExperienceOrb) {
                return Shapes.empty();
            }
            if (e instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)e;
                if (((Boolean)Config.COMMON.shelvesPermeableToDust.get()).booleanValue()) {
                    return item.getItem().is((Item)RegisterItems.FORGOTTEN_DUST.get()) ? Shapes.empty() : shape;
                }
            }
        }
        return shape;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (stack.is((Item)RegisterItems.ATTUNEMENT_STAFF.get()) && !player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractInfectedBookshelfEntity) {
            AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)blockEntity;
            int decayValue = bookshelf.getDecayValue();
            int spawns = bookshelf.getSpawns();
            int durability = 100 - decayValue * 100 / spawns;
            MutableComponent durabilityStatus = Component.literal((String)(durability + "%"));
            if (durability > 50) {
                durabilityStatus.withStyle(ChatFormatting.GREEN);
            } else if (durability > 25) {
                durabilityStatus.withStyle(ChatFormatting.YELLOW);
            } else {
                durabilityStatus.withStyle(ChatFormatting.RED);
            }
            MutableComponent message = Component.translatable((String)"message.cognition.binding_wand.query_bookshelf", (Object[])new Object[]{durabilityStatus});
            if (!level.isClientSide) {
                player.displayClientMessage((Component)message, true);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractInfectedBookshelfEntity) {
            AbstractInfectedBookshelfEntity bookshelf = (AbstractInfectedBookshelfEntity)blockEntity;
            int remaining = bookshelf.getSpawns() - bookshelf.getDecayValue();
            int remainingProduction = remaining * bookshelf.getOrbValue();
            int totalValue = (int)((double)remainingProduction * 0.377 * Math.random());
            int orbCount = (int)(2.0 + Math.random() * 3.0);
            int orbValue = totalValue / orbCount;
            if (!level.isClientSide && totalValue > 10 && !player.isCreative()) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < orbCount; ++i) {
                    server.addFreshEntity((Entity)new ExperienceOrb(level, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, orbValue));
                }
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.INFECTED_BOOKSHELF.get() ? AbstractInfectedBookshelfEntity::tick : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.INFECTED_BOOKSHELF.get()).create(pos, state);
    }
}

