/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ExperienceReceivingEntity
extends BlockEntity {
    private int boundX;
    private int boundY;
    private int boundZ;
    private boolean isBound = false;
    public boolean redstoneEnabled = false;

    public ExperienceReceivingEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isBound() {
        return this.isBound;
    }

    public void setBoundPos(BlockPos pos) {
        this.isBound = true;
        this.boundX = pos.getX();
        this.boundY = pos.getY();
        this.boundZ = pos.getZ();
        this.setChanged();
    }

    public void clearBoundPos() {
        this.isBound = false;
        this.boundX = 0;
        this.boundY = 0;
        this.boundZ = 0;
        this.setChanged();
    }

    public BlockPos getBoundPos() {
        return new BlockPos(this.boundX, this.boundY, this.boundZ);
    }

    @Nullable
    public ExperienceObeliskEntity getBoundObelisk() {
        BlockEntity blockEntity;
        if (this.isBound && this.level != null && (blockEntity = this.level.getBlockEntity(this.getBoundPos())) instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            return obelisk;
        }
        return null;
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    public void setRedstoneEnabled(boolean enabled) {
        this.redstoneEnabled = enabled;
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        this.setChanged();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.isBound = tag.getBoolean("isBound");
        this.boundX = tag.getInt("BoundX");
        this.boundY = tag.getInt("BoundY");
        this.boundZ = tag.getInt("BoundZ");
        this.redstoneEnabled = tag.getBoolean("RedstoneEnabled");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("isBound", this.isBound);
        tag.putInt("BoundX", this.boundX);
        tag.putInt("BoundY", this.boundY);
        tag.putInt("BoundZ", this.boundZ);
        tag.putBoolean("RedstoneEnabled", this.redstoneEnabled);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.isBound = tag.getBoolean("isBound");
        this.boundX = tag.getInt("BoundX");
        this.boundY = tag.getInt("BoundY");
        this.boundZ = tag.getInt("BoundZ");
        this.redstoneEnabled = tag.getBoolean("RedstoneEnabled");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putBoolean("isBound", this.isBound);
        tag.putInt("BoundX", this.boundX);
        tag.putInt("BoundY", this.boundY);
        tag.putInt("BoundZ", this.boundZ);
        tag.putBoolean("RedstoneEnabled", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

