/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe;

import com.cyanogen.cognition.registries.RegisterRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class EmptyingRecipe
implements Recipe<RecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final boolean hasResultStack;
    private final int mBgain;
    private final ResourceLocation id;

    public EmptyingRecipe(Ingredient ingredient, ItemStack result, boolean hasResultStack, int mBgain, ResourceLocation id) {
        this.ingredient = ingredient;
        this.result = result;
        this.hasResultStack = hasResultStack;
        this.mBgain = mBgain;
        this.id = id;
    }

    @Nullable
    public static EmptyingRecipe getRecipe(Level level, ItemStack stack) {
        List recipeList = level.getRecipeManager().getAllRecipesFor((RecipeType)RegisterRecipes.EMPTYING_TYPE.get());
        EmptyingRecipe infectingRecipe = null;
        for (RecipeHolder holder : recipeList) {
            if (!((EmptyingRecipe)holder.value()).matches(stack)) continue;
            infectingRecipe = (EmptyingRecipe)holder.value();
            break;
        }
        return infectingRecipe;
    }

    public boolean matches(final ItemStack stack) {
        return this.matches(new RecipeInput(){

            public ItemStack getItem(int i) {
                return stack;
            }

            public int size() {
                return 1;
            }
        }, null);
    }

    public boolean matches(RecipeInput recipeInput, @Nullable Level level) {
        return this.ingredient.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(@Nullable HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean hasResultStack() {
        return this.hasResultStack;
    }

    public int getCognitiumGain() {
        return this.mBgain;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<EmptyingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"emptying");
        private static final MapCodec<EmptyingRecipe> CODEC = RecordCodecBuilder.mapCodec(recipeInstance -> recipeInstance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.fieldOf("hasResultStack").forGetter(recipe -> recipe.hasResultStack), (App)Codec.INT.fieldOf("gain_mB").forGetter(recipe -> recipe.mBgain), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(recipe -> recipe.id)).apply((Applicative)recipeInstance, EmptyingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EmptyingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static EmptyingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean hasResultStack = buffer.readBoolean();
            int mBcost = buffer.readInt();
            ResourceLocation id = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new EmptyingRecipe(ingredient, result, hasResultStack, mBcost, id);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, EmptyingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.hasResultStack);
            buffer.writeInt(recipe.mBgain);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.id);
        }

        public MapCodec<EmptyingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EmptyingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<EmptyingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "emptying";
    }
}

