/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei;

import com.cyanogen.cognition.item.ExperienceFountainItem;
import com.cyanogen.cognition.recipe.EmptyingRecipe;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.utils.ExperienceUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EmptyingCategory
implements IRecipeCategory<EmptyingRecipe> {
    IRecipeCategoryRegistration registration;
    IGuiHelper guiHelper;
    public final ResourceLocation emptyingBackground = ResourceLocation.parse((String)"cognition:textures/gui/recipes/emptying_jei.png");
    public final ResourceLocation cognitiumTexture = ResourceLocation.parse((String)"cognition:textures/block/cognitium_still.png");
    public final IDrawableAnimated arrow;
    public final IDrawable cognitiumStack;
    private final int arrowWidth = 41;
    private final int arrowHeight = 7;
    private final int arrowOffsetX = 35;
    private final int arrowOffsetY = 21;
    private final int cognitiumOffsetX = 110;
    private final int cognitiumOffsetY = 18;
    public static final RecipeType<EmptyingRecipe> EMPTYING_TYPE = RecipeType.create((String)"cognition", (String)"emptying", EmptyingRecipe.class);

    public EmptyingCategory(IRecipeCategoryRegistration registration) {
        this.registration = registration;
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.emptyingBackground, 0, 66, 41, 7).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.cognitiumStack = this.guiHelper.drawableBuilder(this.cognitiumTexture, 0, 0, 16, 16).build();
    }

    public RecipeType<EmptyingRecipe> getRecipeType() {
        return EMPTYING_TYPE;
    }

    public int getWidth() {
        return 136;
    }

    public int getHeight() {
        return 66;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.cognition.emptying.title");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(EmptyingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.guiHelper.createDrawable(this.emptyingBackground, 0, 0, 136, 66).draw(guiGraphics);
        this.arrow.draw(guiGraphics, 35, 21);
        if (recipe.getCognitiumGain() > 0) {
            this.cognitiumStack.draw(guiGraphics, 110, 18);
        }
    }

    public void getTooltip(ITooltipBuilder tooltipBuilder, EmptyingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        this.getArrowTooltip(tooltipBuilder, mouseX, mouseY);
        this.getCognitiumTooltip(recipe.getCognitiumGain(), tooltipBuilder, mouseX, mouseY);
    }

    public void getArrowTooltip(ITooltipBuilder tooltipBuilder, double mouseX, double mouseY) {
        MutableComponent arrowTooltip = Component.translatable((String)"jei.cognition.emptying.tooltip");
        int x1 = 32;
        int x2 = 79;
        int y1 = 19;
        int y2 = 30;
        if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            tooltipBuilder.add((FormattedText)arrowTooltip);
        }
    }

    public void getCognitiumTooltip(int cognitiumGain, ITooltipBuilder tooltipBuilder, double mouseX, double mouseY) {
        int x1 = 110;
        int x2 = x1 + 16;
        int y1 = 18;
        int y2 = y1 + 16;
        if (cognitiumGain > 0 && mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            int xp = cognitiumGain / 20;
            int levels = ExperienceUtils.xpToLevels(xp);
            MutableComponent volumeComponent = Component.translatable((String)"jei.cognition.shared.cognitium_amount.mb", (Object[])new Object[]{Component.literal((String)String.valueOf(cognitiumGain)).withStyle(ChatFormatting.GREEN)});
            MutableComponent xpLevelsComponent = Component.translatable((String)"jei.cognition.shared.cognitium_amount.levels_xp", (Object[])new Object[]{Component.literal((String)String.valueOf(levels)).withStyle(ChatFormatting.GREEN), Component.literal((String)String.valueOf(xp)).withStyle(ChatFormatting.GREEN)});
            tooltipBuilder.add((FormattedText)volumeComponent);
            tooltipBuilder.add((FormattedText)xpLevelsComponent);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EmptyingRecipe recipe, IFocusGroup focuses) {
        ItemStack catalyst = ((ExperienceFountainItem)((Object)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get())).getDefaultInstance();
        ItemStack result = ItemStack.EMPTY;
        if (recipe.hasResultStack()) {
            result = recipe.getResultItem(null);
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setSlotName("input").addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 47, 34).setSlotName("catalyst").addItemStack(catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 18).setSlotName("output").addItemStack(result);
    }
}

