/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.network.experience_obelisk.UpdateContents;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import com.cyanogen.experienceobelisk.registries.RegisterFluids;
import com.cyanogen.experienceobelisk.registries.RegisterTags;
import com.cyanogen.experienceobelisk.saved_data.MemoryTabletData;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExperienceObeliskEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation IDLE_INACTIVE = RawAnimation.begin().thenPlay("idle.inactive");
    protected boolean redstoneEnabled = false;
    protected double radius = 2.5;
    protected String savedPlayer = "";
    protected final FluidTank tank = this.experienceObeliskTank();
    private final LazyOptional<IFluidHandler> handler = LazyOptional.of(() -> this.tank);
    private static final Fluid cognitium = ((FlowingFluid)RegisterFluids.COGNITIUM.get()).m_5613_();
    public static final int capacity = (int)Math.min(Math.round((double)((Integer)Config.COMMON.capacity.get()).intValue() / 20.0) * 20L, 0x7FFFFFF8L);

    public ExperienceObeliskEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.EXPERIENCE_OBELISK_BE.get(), pos, state);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::controller)});
    }

    protected <E extends ExperienceObeliskEntity> PlayState controller(AnimationState<E> state) {
        ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)state.getAnimatable();
        AnimationController controller = state.getController();
        RawAnimation animation = controller.getCurrentRawAnimation();
        if (animation == null || this.f_58857_ == null) {
            controller.setAnimation(IDLE);
        } else {
            boolean isInactive;
            boolean bl = isInactive = obelisk.redstoneEnabled && !this.f_58857_.m_276867_(obelisk.m_58899_());
            if (isInactive && animation.equals((Object)IDLE)) {
                controller.setAnimation(IDLE_INACTIVE);
            } else if (!isInactive && animation.equals((Object)IDLE_INACTIVE)) {
                controller.setAnimation(IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        boolean isRedstonePowered = level.m_276867_(pos);
        if (blockEntity instanceof ExperienceObeliskEntity) {
            AABB area;
            List list;
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)((Object)blockEntity);
            boolean absorb = !obelisk.isRedstoneEnabled() || isRedstonePowered;
            double radius = obelisk.getRadius();
            int space = obelisk.getSpace();
            if (absorb && level.m_46467_() % 10L == 0L && !(list = level.m_45976_(ExperienceOrb.class, area = ExperienceObeliskEntity.getAreaOfEffect(pos, radius))).isEmpty()) {
                for (int i = 0; i < Math.min(30, list.size()); ++i) {
                    ExperienceOrb orb = (ExperienceOrb)list.get(i);
                    CompoundTag tag = new CompoundTag();
                    orb.m_7380_(tag);
                    int value = orb.f_20770_;
                    int count = tag.m_128451_("Count");
                    int amount = value * 20 * count;
                    if (space < amount) continue;
                    obelisk.fill(amount);
                    space -= amount;
                    orb.m_146870_();
                }
            }
            if (!level.f_46443_) {
                obelisk.checkAroundForMemorized();
            }
        }
    }

    public static AABB getAreaOfEffect(BlockPos pos, double radius) {
        return new AABB((double)pos.m_123341_() - radius, (double)pos.m_123342_() - radius, (double)pos.m_123343_() - radius, (double)pos.m_123341_() + radius, (double)pos.m_123342_() + radius, (double)pos.m_123343_() + radius);
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    public void setRedstoneEnabled(boolean state) {
        this.redstoneEnabled = state;
        this.m_6596_();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        super.m_6596_();
    }

    public String getSavedPlayer() {
        return this.savedPlayer;
    }

    public void syncFromStorage() {
        MemoryTabletData data;
        if (this.f_58857_ != null && (data = MemoryTabletData.getFromStorage(this.f_58857_, this.savedPlayer)) != null && data.hasLinkedObelisk() && data.getLinkedObelisk() != this.m_58899_()) {
            this.savedPlayer = "";
            this.m_6596_();
        }
    }

    public void remember(Player player, MemoryTabletData data) {
        this.savedPlayer = player.m_20149_();
        if (data == null) {
            MemoryTabletData newData = new MemoryTabletData();
            newData.setLinkedObelisk(this.m_58899_(), player.m_9236_().m_46472_().m_135782_().toString(), true);
            MemoryTabletData.createAndSaveToStorage(player, newData);
        } else {
            data.setLinkedObelisk(this.m_58899_(), player.m_9236_().m_46472_().m_135782_().toString(), true);
        }
        this.m_6596_();
    }

    public void forget(Player player, MemoryTabletData data) {
        this.savedPlayer = "";
        if (data == null) {
            MemoryTabletData newData = new MemoryTabletData();
            newData.setLinkedObelisk(new BlockPos(0, 0, 0), "minecraft:overworld", false);
            MemoryTabletData.createAndSaveToStorage(player, newData);
        } else {
            data.setLinkedObelisk(new BlockPos(0, 0, 0), "minecraft:overworld", false);
        }
        this.m_6596_();
    }

    public void checkAroundForMemorized() {
        if (this.f_58857_ != null && this.f_58857_.m_46467_() % 20L == 0L) {
            BlockPos pos = this.m_58899_();
            List list = this.f_58857_.m_45976_(Player.class, ExperienceObeliskEntity.getAreaOfEffect(pos, this.getRadius()));
            for (Player player : list) {
                if (player.m_21224_() || !this.hasMemorized(player) || !this.hasXpToRecover(player)) continue;
                this.handleExperienceRecovery(player);
                break;
            }
        }
    }

    public boolean hasMemorized(Player player) {
        MemoryTabletData data = MemoryTabletData.getFromStorage(player);
        return data != null && data.getLinkedObelisk().equals((Object)this.m_58899_());
    }

    public boolean hasXpToRecover(Player player) {
        MemoryTabletData data = MemoryTabletData.getFromStorage(player);
        return data != null && data.getExperienceToRecover() > 0L;
    }

    public void handleExperienceRecovery(Player player) {
        MemoryTabletData data = MemoryTabletData.getFromStorage(player);
        assert (data != null);
        long xp = data.getExperienceToRecover();
        int pointsRecovered = (int)Math.min((long)(5000000 - this.getExperiencePoints()), xp);
        player.m_6756_(pointsRecovered);
        assert (this.f_58857_ != null);
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 0.25f);
        ServerLevel server = (ServerLevel)this.f_58857_;
        BlockPos pos = this.m_58899_();
        server.m_8624_((ServerPlayer)player, (ParticleOptions)ParticleTypes.f_123767_, false, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, 64, 1.0, 1.0, 1.0, 0.1);
        data.setExperienceToRecover(0L);
        player.m_5661_((Component)Component.m_237110_((String)"message.experienceobelisk.experience_obelisk.experience_recovered", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(ExperienceUtils.xpToLevels(pointsRecovered))).m_130940_(ChatFormatting.GREEN)}), true);
    }

    private FluidTank experienceObeliskTank() {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                ExperienceObeliskEntity.this.m_6596_();
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return this.isFluidValid(stack);
            }

            public boolean isFluidValid(FluidStack stack) {
                String fluidName = String.valueOf(ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()));
                if (stack.getFluid() == cognitium) {
                    return true;
                }
                return stack.getFluid().m_205067_(RegisterTags.Fluids.EXPERIENCE) && ((List)Config.COMMON.allowedFluids.get()).contains(fluidName);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.isFluidValid(resource)) {
                    return super.fill(new FluidStack(cognitium, resource.getAmount()), action);
                }
                return 0;
            }

            public void setFluid(FluidStack stack) {
                this.fluid = stack;
                this.onContentsChanged();
            }
        };
    }

    public int fill(int amount) {
        return this.tank.fill(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void drain(int amount) {
        this.tank.drain(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void setFluid(int amount) {
        this.tank.setFluid(new FluidStack(cognitium, amount));
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getSpace() {
        return this.tank.getSpace();
    }

    public int getExperiencePoints() {
        return this.getFluidAmount() / 20;
    }

    public int getLevels() {
        return ExperienceUtils.xpToLevels(this.getExperiencePoints());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        this.handler.invalidate();
        super.invalidateCaps();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag);
        this.savedPlayer = tag.m_128461_("SavedPlayer");
        this.radius = tag.m_128459_("Radius");
        this.redstoneEnabled = tag.m_128471_("isRedstoneControllable");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.tank.writeToNBT(tag);
        tag.m_128359_("SavedPlayer", this.savedPlayer);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.tank.writeToNBT(tag);
        tag.m_128359_("SavedPlayer", this.savedPlayer);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleRequest(UpdateContents.Request request, int XP, ServerPlayer sender) {
        long playerXP = ExperienceUtils.getTotalXP((Player)sender);
        if (request == UpdateContents.Request.FILL && this.getSpace() != 0) {
            long finalXP = ExperienceUtils.levelsToXP(sender.f_36078_ - XP) + Math.round(sender.f_36080_ * (float)(ExperienceUtils.levelsToXP(sender.f_36078_ - XP + 1) - ExperienceUtils.levelsToXP(sender.f_36078_ - XP)));
            long addAmount = (playerXP - finalXP) * 20L;
            if (addAmount >= (long)this.getSpace()) {
                sender.m_6756_(-this.fill(this.getSpace()) / 20);
            } else if (sender.f_36078_ >= XP) {
                this.fill((int)addAmount);
                sender.m_6749_(-XP);
            } else if (playerXP >= 1L) {
                this.fill((int)(playerXP * 20L));
                sender.m_8985_(0);
                sender.m_9174_(0);
            }
        } else if (request == UpdateContents.Request.DRAIN) {
            long finalXP;
            long drainAmount;
            int amount = this.getFluidAmount();
            if ((long)amount >= (drainAmount = ((finalXP = (long)(ExperienceUtils.levelsToXP(sender.f_36078_ + XP) + Math.round(sender.f_36080_ * (float)(ExperienceUtils.levelsToXP(sender.f_36078_ + XP + 1) - ExperienceUtils.levelsToXP(sender.f_36078_ + XP))))) - playerXP) * 20L)) {
                this.drain((int)drainAmount);
                sender.m_6749_(XP);
            } else if (amount >= 1) {
                sender.m_6756_(amount / 20);
                this.setFluid(0);
            }
        } else if (request == UpdateContents.Request.FILL_ALL) {
            if (playerXP * 20L <= (long)this.getSpace()) {
                this.fill((int)(playerXP * 20L));
                sender.m_8985_(0);
                sender.m_9174_(0);
            } else {
                sender.m_6756_(-this.getSpace() / 20);
                this.setFluid(capacity);
            }
        } else if (request == UpdateContents.Request.DRAIN_ALL) {
            sender.m_6756_(this.getFluidAmount() / 20);
            this.setFluid(0);
        }
    }
}

