/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities.bibliophage;

import com.cyanogen.experienceobelisk.item.BibliophageItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractInfectiveEntity
extends BlockEntity {
    public AbstractInfectiveEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void infectAdjacent(Level level, BlockPos pos) {
        HashMap<BlockPos, Block> adjacentMap = new HashMap<BlockPos, Block>();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos adjacentPos : this.getAdjacents(pos)) {
            if (!BibliophageItem.getValidBlocksForInfection().contains(level.m_8055_(adjacentPos).m_60734_())) continue;
            Block adjacentBlock = level.m_8055_(adjacentPos).m_60734_();
            adjacentMap.put(adjacentPos, adjacentBlock);
            posList.add(adjacentPos);
        }
        if (!adjacentMap.isEmpty()) {
            int index = (int)Math.floor(Math.random() * (double)posList.size());
            BlockPos posToInfect = (BlockPos)posList.get(index);
            Block block = (Block)adjacentMap.get(posToInfect);
            BibliophageItem.infectBlock(level, posToInfect, block);
        }
    }

    public List<BlockPos> getAdjacents(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        list.add(pos.m_7494_());
        list.add(pos.m_7495_());
        list.add(pos.m_122012_());
        list.add(pos.m_122019_());
        list.add(pos.m_122029_());
        list.add(pos.m_122024_());
        return list;
    }

    public List<BlockPos> getEdgeBlocks(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos above = pos.m_7494_();
        BlockPos below = pos.m_7495_();
        list.add(above.m_122012_());
        list.add(above.m_122019_());
        list.add(above.m_122029_());
        list.add(above.m_122024_());
        list.add(below.m_122012_());
        list.add(below.m_122019_());
        list.add(below.m_122029_());
        list.add(below.m_122024_());
        list.add(pos.m_122012_().m_122024_());
        list.add(pos.m_122012_().m_122029_());
        list.add(pos.m_122019_().m_122024_());
        list.add(pos.m_122019_().m_122029_());
        return list;
    }

    public List<BlockPos> getVertexBlocks(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos above = pos.m_7494_();
        BlockPos below = pos.m_7495_();
        list.add(above.m_122012_().m_122024_());
        list.add(above.m_122012_().m_122029_());
        list.add(above.m_122019_().m_122024_());
        list.add(above.m_122019_().m_122029_());
        list.add(below.m_122012_().m_122024_());
        list.add(below.m_122012_().m_122029_());
        list.add(below.m_122019_().m_122024_());
        list.add(below.m_122019_().m_122029_());
        return list;
    }
}

