/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.block_entities.ExperienceFountainEntity;
import com.cyanogen.experienceobelisk.block_entities.bibliophage.bookshelves.AbstractInfectedBookshelfEntity;
import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.item.ActivatableItem;
import com.cyanogen.experienceobelisk.registries.RegisterSounds;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnlightenedAmuletItem
extends ActivatableItem {
    public EnlightenedAmuletItem(Item.Properties p) {
        super(p);
    }

    @Override
    public void playActivationSound(Player player) {
        player.m_5496_((SoundEvent)RegisterSounds.ENLIGHTENED_AMULET_ACTIVATE.get(), 0.2f, 1.0f);
    }

    @Override
    public void playDeactivationSound(Player player) {
        player.m_5496_((SoundEvent)RegisterSounds.ENLIGHTENED_AMULET_DEACTIVATE.get(), 0.2f, 0.8f);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isCurrentItem) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isActive(stack) && !level.f_46443_ && level.m_46467_() % 10L == 0L) {
                double radius = (Double)Config.COMMON.amuletRange.get();
                Vec3 pos = player.m_20182_();
                AABB area = new AABB(pos.m_7096_() - radius, pos.m_7098_() - radius, pos.m_7094_() - radius, pos.m_7096_() + radius, pos.m_7098_() + radius, pos.m_7094_() + radius);
                List list = level.m_45976_(ExperienceOrb.class, area);
                int totalValue = 0;
                if (!list.isEmpty()) {
                    ExperienceOrb orb;
                    for (int i = 0; i < Math.min(30, list.size()); ++i) {
                        boolean shouldCollect;
                        orb = (ExperienceOrb)list.get(i);
                        CompoundTag tag = new CompoundTag();
                        orb.m_7380_(tag);
                        boolean spawnedFromFountain = orb.m_8077_() && Objects.equals(orb.m_7770_(), ExperienceFountainEntity.FROM_FOUNTAIN);
                        boolean ignoreFountain = (Boolean)Config.COMMON.amuletIgnoresFountainOrbs.get();
                        boolean spawnedFromBookshelf = orb.m_8077_() && Objects.equals(orb.m_7770_(), AbstractInfectedBookshelfEntity.FROM_BOOKSHELF);
                        boolean ignoreBookshelf = (Boolean)Config.COMMON.amuletIgnoresBookshelfOrbs.get();
                        boolean bl = shouldCollect = !(ignoreFountain && spawnedFromFountain || ignoreBookshelf && spawnedFromBookshelf);
                        if (!shouldCollect) continue;
                        int value = orb.f_20770_;
                        int count = tag.m_128451_("Count");
                        totalValue += value * count;
                        orb.m_146870_();
                    }
                    ServerLevel server = (ServerLevel)level;
                    if (totalValue < 32768 && totalValue > 0) {
                        orb = new ExperienceOrb((Level)server, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), totalValue);
                        server.m_7967_((Entity)orb);
                    } else if (totalValue > 0) {
                        while (totalValue > 0) {
                            int v = Math.min(totalValue, Short.MAX_VALUE);
                            ExperienceOrb orb2 = new ExperienceOrb((Level)server, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), v);
                            server.m_7967_((Entity)orb2);
                            totalValue -= v;
                        }
                    }
                }
            }
        }
        super.m_6883_(stack, level, entity, slot, isCurrentItem);
    }
}

