/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.block.ExperienceObeliskBlock;
import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.registries.RegisterSounds;
import com.cyanogen.experienceobelisk.saved_data.MemoryTabletData;
import com.cyanogen.experienceobelisk.utils.ExperienceUtils;
import com.cyanogen.experienceobelisk.utils.MiscUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.network.NetworkHooks;

public class MemoryTabletItem
extends Item {
    public MemoryTabletItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (!level.f_46443_) {
            MemoryTabletData data = MemoryTabletData.getFromStorage(player);
            if (data != null && data.hasLinkedObelisk()) {
                BlockPos pos = data.getLinkedObelisk();
                BlockState state = level.m_8055_(pos);
                if (!player.m_6144_()) {
                    if (state.m_60734_() instanceof ExperienceObeliskBlock && data.dimensionMatches(level) && MiscUtils.straightLineDistance(player.m_20183_(), pos) <= (Double)Config.COMMON.bindingRange.get()) {
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)state.m_60750_(level, pos), (BlockPos)pos);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.memory_tablet.out_of_range"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"message.experienceobelisk.memory_tablet.query", (Object[])new Object[]{Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.GREEN), Component.m_237113_((String)data.getDimension()).m_130940_(ChatFormatting.GRAY)}), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.memory_tablet.query_fail"), true);
            }
        }
        if (player.m_6144_()) {
            return super.m_7203_(level, player, usedHand);
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(usedHand), (boolean)level.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            if (player != null && player.m_6144_()) {
                obelisk.syncFromStorage();
                MemoryTabletData data = MemoryTabletData.getFromStorage(player);
                if (obelisk.getSavedPlayer().isEmpty()) {
                    obelisk.remember(player, data);
                    player.m_5661_((Component)Component.m_237110_((String)"message.experienceobelisk.memory_tablet.link", (Object[])new Object[]{Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.GREEN)}), true);
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)RegisterSounds.MEMORY_TABLET_LINK.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
                } else if (obelisk.getSavedPlayer().equals(player.m_20149_())) {
                    obelisk.forget(player, data);
                    player.m_5661_((Component)Component.m_237110_((String)"message.experienceobelisk.memory_tablet.unlink", (Object[])new Object[]{Component.m_237113_((String)pos.m_123344_()).m_130940_(ChatFormatting.GREEN)}), true);
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)RegisterSounds.MEMORY_TABLET_UNLINK.get(), SoundSource.PLAYERS, 0.2f, 0.8f);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.experienceobelisk.memory_tablet.obelisk_in_use"), true);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return super.m_6225_(context);
    }

    public static void handleDeath(LivingDeathEvent event) {
        boolean keepInventory = ((GameRules.BooleanValue)event.getEntity().m_9236_().m_46469_().m_46170_(GameRules.f_46133_)).m_46223_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            MemoryTabletData data;
            Player player = (Player)livingEntity;
            if (!keepInventory && (data = MemoryTabletData.getFromStorage(player)) != null && data.hasLinkedObelisk()) {
                data.setExperienceToRecover(ExperienceUtils.getTotalXP(player));
            }
        }
    }

    public static void handleExperience(LivingExperienceDropEvent event) {
        Player player;
        MemoryTabletData data;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (data = MemoryTabletData.getFromStorage(player = (Player)livingEntity)) != null && data.hasLinkedObelisk()) {
            event.setDroppedExperience(0);
            event.setCanceled(true);
        }
    }
}

