/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei.info;

import com.cyanogen.experienceobelisk.recipe.jei.info.FillingRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FillingCategory
implements IRecipeCategory<FillingRecipe> {
    private final IGuiHelper guiHelper;
    private final ResourceLocation texture = new ResourceLocation("experienceobelisk:textures/gui/recipes/information_jei.png");
    private final IDrawableAnimated arrow;
    public static final RecipeType<FillingRecipe> fillingType = RecipeType.create((String)"experienceobelisk", (String)"filling", FillingRecipe.class);

    public FillingCategory(IRecipeCategoryRegistration registration) {
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.texture, 0, 66, 41, 7).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<FillingRecipe> getRecipeType() {
        return fillingType;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.experienceobelisk.info.filling.title");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(FillingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 46, 22);
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public List<Component> getTooltipStrings(FillingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        MutableComponent tooltip = Component.m_237115_((String)"jei.experienceobelisk.info.filling.tooltip");
        int x1 = 46;
        int x2 = x1 + 43;
        int y1 = 22;
        int y2 = y1 + 11;
        if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            tooltipList.add((Component)tooltip);
            return tooltipList;
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FillingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 19).setSlotName("input").addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 58, 35).setSlotName("catalyst").addIngredients(recipe.getCatalyst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 19).setSlotName("output").addItemStack(recipe.m_8043_(null));
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(this.texture, 0, 0, 136, 66);
    }
}

