/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.recipe.jei.info;

import com.cyanogen.experienceobelisk.recipe.jei.info.InfectingRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterItems;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InfectingCategory
implements IRecipeCategory<InfectingRecipe> {
    IRecipeCategoryRegistration registration;
    IGuiHelper guiHelper;
    private final ResourceLocation texture = new ResourceLocation("experienceobelisk:textures/gui/recipes/information_jei.png");
    private final IDrawableAnimated arrow;
    private final IDrawable counterArrow;
    public static final RecipeType<InfectingRecipe> infectingType = RecipeType.create((String)"experienceobelisk", (String)"infecting", InfectingRecipe.class);

    public InfectingCategory(IRecipeCategoryRegistration registration) {
        this.registration = registration;
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.texture, 0, 66, 41, 7).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.counterArrow = this.guiHelper.drawableBuilder(this.texture, 0, 73, 11, 9).build();
    }

    public RecipeType<InfectingRecipe> getRecipeType() {
        return infectingType;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.experienceobelisk.info.infecting.title");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.BIBLIOPHAGE.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(InfectingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.count > 0) {
            this.counterArrow.draw(guiGraphics, 52, 8);
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, "x" + recipe.count, 67, 8, 0xFFFFFF);
        }
        this.arrow.draw(guiGraphics, 46, 22);
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public List<Component> getTooltipStrings(InfectingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        MutableComponent desc = Component.m_237115_((String)"jei.experienceobelisk.info.infecting.tooltip");
        MutableComponent requiredCount = Component.m_237110_((String)"jei.experienceobelisk.info.infecting.tooltip_count", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(recipe.count)).m_130940_(ChatFormatting.GREEN)});
        int arrow_x1 = 46;
        int arrow_x2 = arrow_x1 + 43;
        int arrow_y1 = 22;
        int arrow_y2 = arrow_y1 + 11;
        int counterarrow_x1 = 52;
        int counterarrow_x2 = counterarrow_x1 + 30;
        int counterarrow_y1 = 8;
        int counterarrow_y2 = counterarrow_y1 + 9;
        if (mouseX >= (double)arrow_x1 && mouseX <= (double)arrow_x2 && mouseY >= (double)arrow_y1 && mouseY <= (double)arrow_y2) {
            tooltipList.add((Component)desc);
            return tooltipList;
        }
        if (recipe.getCount() > 0 && mouseX >= (double)counterarrow_x1 && mouseX <= (double)counterarrow_x2 && mouseY >= (double)counterarrow_y1 && mouseY <= (double)counterarrow_y2) {
            tooltipList.add((Component)requiredCount);
            return tooltipList;
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfectingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 15, 19).setSlotName("input").addIngredients(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 58, 35).setSlotName("catalyst").addIngredients(recipe.getCatalyst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 19).setSlotName("output").addItemStack(recipe.m_8043_(null));
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(this.texture, 0, 0, 136, 66);
    }
}

